/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.persistent;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.regex.Matcher;
import seph.lang.persistent.APersistentMap;
import seph.lang.persistent.APersistentVector;
import seph.lang.persistent.ASeq;
import seph.lang.persistent.Counted;
import seph.lang.persistent.IPersistentCollection;
import seph.lang.persistent.IPersistentVector;
import seph.lang.persistent.ISeq;
import seph.lang.persistent.Indexed;
import seph.lang.persistent.IteratorSeq;
import seph.lang.persistent.PersistentVector;
import seph.lang.persistent.Seqable;
import seph.lang.persistent.Sequential;
import seph.lang.persistent.Util;

public class RT {
    public static final Object[] EMPTY_ARRAY = new Object[0];

    public static int count(Object o) {
        if (o instanceof Counted) {
            return ((Counted)o).count();
        }
        Object object = o;
        o = null;
        return RT.countFrom(Util.ret1(object, null));
    }

    static int countFrom(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof IPersistentCollection) {
            ISeq s = RT.seq(o);
            o = null;
            int i = 0;
            while (s != null) {
                if (s instanceof Counted) {
                    return i + s.count();
                }
                ++i;
                s = s.next();
            }
            return i;
        }
        if (o instanceof CharSequence) {
            return ((CharSequence)o).length();
        }
        if (o instanceof Collection) {
            return ((Collection)o).size();
        }
        if (o instanceof Map) {
            return ((Map)o).size();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o);
        }
        throw new UnsupportedOperationException("count not supported on this type: " + o.getClass().getSimpleName());
    }

    public static ISeq seq(Object coll) {
        if (coll instanceof ASeq) {
            return (ASeq)coll;
        }
        return RT.seqFrom(coll);
    }

    static ISeq seqFrom(Object coll) {
        if (coll instanceof Seqable) {
            return ((Seqable)coll).seq();
        }
        if (coll == null) {
            return null;
        }
        if (coll instanceof Iterable) {
            return IteratorSeq.create(((Iterable)coll).iterator());
        }
        Class<?> c = coll.getClass();
        Class<?> sc = c.getSuperclass();
        throw new IllegalArgumentException("Don't know how to create ISeq from: " + c.getName());
    }

    public static Object nth(Object coll, int n) {
        if (coll instanceof Indexed) {
            return ((Indexed)coll).at(n);
        }
        Object object = coll;
        coll = null;
        return RT.nthFrom(Util.ret1(object, null), n);
    }

    static Object nthFrom(Object coll, int n) {
        if (coll == null) {
            return null;
        }
        if (coll instanceof CharSequence) {
            return Character.valueOf(((CharSequence)coll).charAt(n));
        }
        if (coll instanceof RandomAccess) {
            return ((List)coll).get(n);
        }
        if (coll instanceof Matcher) {
            return ((Matcher)coll).group(n);
        }
        if (coll instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)coll;
            if (n == 0) {
                return e.getKey();
            }
            if (n == 1) {
                return e.getValue();
            }
            throw new IndexOutOfBoundsException();
        }
        if (coll instanceof Sequential) {
            ISeq seq = RT.seq(coll);
            coll = null;
            for (int i = 0; i <= n && seq != null; ++i, seq = seq.next()) {
                if (i != n) continue;
                return seq.first();
            }
            throw new IndexOutOfBoundsException();
        }
        throw new UnsupportedOperationException("nth not supported on this type: " + coll.getClass().getSimpleName());
    }

    public static Object nth(Object coll, int n, Object notFound) {
        if (coll instanceof Indexed) {
            Indexed v = (Indexed)coll;
            return v.at(n, notFound);
        }
        return RT.nthFrom(coll, n, notFound);
    }

    static Object nthFrom(Object coll, int n, Object notFound) {
        if (coll == null) {
            return notFound;
        }
        if (n < 0) {
            return notFound;
        }
        if (coll instanceof CharSequence) {
            CharSequence s = (CharSequence)coll;
            if (n < s.length()) {
                return Character.valueOf(s.charAt(n));
            }
            return notFound;
        }
        if (coll instanceof RandomAccess) {
            List list = (List)coll;
            if (n < list.size()) {
                return list.get(n);
            }
            return notFound;
        }
        if (coll instanceof Matcher) {
            Matcher m = (Matcher)coll;
            if (n < m.groupCount()) {
                return m.group(n);
            }
            return notFound;
        }
        if (coll instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)coll;
            if (n == 0) {
                return e.getKey();
            }
            if (n == 1) {
                return e.getValue();
            }
            return notFound;
        }
        if (coll instanceof Sequential) {
            ISeq seq = RT.seq(coll);
            coll = null;
            for (int i = 0; i <= n && seq != null; ++i, seq = seq.next()) {
                if (i != n) continue;
                return seq.first();
            }
            return notFound;
        }
        throw new UnsupportedOperationException("nth not supported on this type: " + coll.getClass().getSimpleName());
    }

    public static Object[] seqToArray(ISeq seq) {
        int len = RT.length(seq);
        Object[] ret = new Object[len];
        int i = 0;
        while (seq != null) {
            ret[i] = seq.first();
            ++i;
            seq = seq.next();
        }
        return ret;
    }

    public static int length(ISeq list) {
        int i = 0;
        for (ISeq c = list; c != null; c = c.next()) {
            ++i;
        }
        return i;
    }

    public static Object first(Object x) {
        if (x instanceof ISeq) {
            return ((ISeq)x).first();
        }
        ISeq seq = RT.seq(x);
        if (seq == null) {
            return null;
        }
        return seq.first();
    }

    public static Object second(Object x) {
        return RT.first(RT.next(x));
    }

    public static ISeq next(Object x) {
        if (x instanceof ISeq) {
            return ((ISeq)x).next();
        }
        ISeq seq = RT.seq(x);
        if (seq == null) {
            return null;
        }
        return seq.next();
    }

    public static IPersistentVector subvec(IPersistentVector v, int start, int end) {
        if (end < start || start < 0 || end > v.count()) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            return PersistentVector.EMPTY;
        }
        return new APersistentVector.SubVector(null, v, start, end);
    }

    public static ISeq keys(Object coll) {
        return APersistentMap.KeySeq.create(RT.seq(coll));
    }
}

