/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.persistent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import seph.lang.SimpleSephObject;
import seph.lang.persistent.ASeq;
import seph.lang.persistent.Counted;
import seph.lang.persistent.IPersistentCollection;
import seph.lang.persistent.IPersistentList;
import seph.lang.persistent.IPersistentMap;
import seph.lang.persistent.ISeq;
import seph.lang.persistent.RT;
import seph.lang.persistent.Sequential;

public class PersistentList
extends ASeq
implements IPersistentList,
List,
Counted {
    private final Object first;
    private final IPersistentList rest;
    private final int count;
    public static final EmptyList EMPTY = new EmptyList(null);

    public PersistentList(Object first) {
        this.first = first;
        this.rest = null;
        this.count = 1;
    }

    PersistentList(IPersistentMap meta, Object first, IPersistentList rest, int count) {
        super(meta);
        this.first = first;
        this.rest = rest;
        this.count = count;
    }

    public static IPersistentList create(List init) {
        IPersistentList ret = EMPTY;
        ListIterator i = init.listIterator(init.size());
        while (i.hasPrevious()) {
            ret = (IPersistentList)ret.cons(i.previous());
        }
        return ret;
    }

    @Override
    public Object first() {
        return this.first;
    }

    @Override
    public ISeq next() {
        if (this.count == 1) {
            return null;
        }
        return (ISeq)((Object)this.rest);
    }

    public Object peek() {
        return this.first();
    }

    public IPersistentList pop() {
        if (this.rest == null) {
            return EMPTY.withMeta(this.meta());
        }
        return this.rest;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public PersistentList cons(Object o) {
        return new PersistentList(this.meta(), o, this, this.count + 1);
    }

    @Override
    public IPersistentCollection empty() {
        return EMPTY.withMeta(this.meta());
    }

    public PersistentList withMeta(IPersistentMap metaArg) {
        if (metaArg != this.meta()) {
            return new PersistentList(metaArg, this.first, this.rest, this.count);
        }
        return this;
    }

    static class EmptyList
    extends SimpleSephObject
    implements IPersistentList,
    List,
    ISeq,
    Counted {
        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object o) {
            return (o instanceof Sequential || o instanceof List) && RT.seq(o) == null;
        }

        @Override
        public boolean equiv(Object o) {
            return this.equals(o);
        }

        EmptyList(IPersistentMap meta) {
            super(meta);
        }

        @Override
        public Object first() {
            return null;
        }

        @Override
        public ISeq next() {
            return null;
        }

        @Override
        public ISeq more() {
            return this;
        }

        @Override
        public PersistentList cons(Object o) {
            return new PersistentList(this.meta(), o, null, 1);
        }

        @Override
        public IPersistentCollection empty() {
            return this;
        }

        public EmptyList withMeta(IPersistentMap meta) {
            if (meta != this.meta()) {
                return new EmptyList(meta);
            }
            return this;
        }

        public Object peek() {
            return null;
        }

        public IPersistentList pop() {
            throw new IllegalStateException("Can't pop empty list");
        }

        @Override
        public int count() {
            return 0;
        }

        @Override
        public ISeq seq() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return RT.EMPTY_ARRAY;
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection collection) {
            return collection.isEmpty();
        }

        @Override
        public Object[] toArray(Object[] objects) {
            if (objects.length > 0) {
                objects[0] = null;
            }
            return objects;
        }

        private List reify() {
            return Collections.unmodifiableList(new ArrayList(this));
        }

        public List subList(int fromIndex, int toIndex) {
            return this.reify().subList(fromIndex, toIndex);
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return -1;
        }

        public ListIterator listIterator() {
            return this.reify().listIterator();
        }

        public ListIterator listIterator(int index) {
            return this.reify().listIterator(index);
        }

        public Object get(int index) {
            throw new IndexOutOfBoundsException();
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }
    }
}

