/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.persistent;

import java.util.List;
import seph.lang.SephObject;
import seph.lang.persistent.APersistentSet;
import seph.lang.persistent.ATransientSet;
import seph.lang.persistent.EditableCollection;
import seph.lang.persistent.IPersistentCollection;
import seph.lang.persistent.IPersistentMap;
import seph.lang.persistent.IPersistentSet;
import seph.lang.persistent.ISeq;
import seph.lang.persistent.ITransientCollection;
import seph.lang.persistent.ITransientMap;
import seph.lang.persistent.PersistentHashMap;

public class PersistentHashSet
extends APersistentSet
implements SephObject,
EditableCollection {
    public static final PersistentHashSet EMPTY = new PersistentHashSet(null, PersistentHashMap.EMPTY);

    public static PersistentHashSet create(Object ... init) {
        PersistentHashSet ret = EMPTY;
        for (int i = 0; i < init.length; ++i) {
            ret = (PersistentHashSet)ret.cons(init[i]);
        }
        return ret;
    }

    public static PersistentHashSet create(List init) {
        PersistentHashSet ret = EMPTY;
        for (Object key : init) {
            ret = (PersistentHashSet)ret.cons(key);
        }
        return ret;
    }

    public static PersistentHashSet create(ISeq items) {
        PersistentHashSet ret = EMPTY;
        while (items != null) {
            ret = (PersistentHashSet)ret.cons(items.first());
            items = items.next();
        }
        return ret;
    }

    public static PersistentHashSet createWithCheck(Object ... init) {
        PersistentHashSet ret = EMPTY;
        for (int i = 0; i < init.length; ++i) {
            if ((ret = (PersistentHashSet)ret.cons(init[i])).count() == i + 1) continue;
            throw new IllegalArgumentException("Duplicate key: " + init[i]);
        }
        return ret;
    }

    public static PersistentHashSet createWithCheck(List init) {
        PersistentHashSet ret = EMPTY;
        int i = 0;
        for (Object key : init) {
            if ((ret = (PersistentHashSet)ret.cons(key)).count() != i + 1) {
                throw new IllegalArgumentException("Duplicate key: " + key);
            }
            ++i;
        }
        return ret;
    }

    public static PersistentHashSet createWithCheck(ISeq items) {
        PersistentHashSet ret = EMPTY;
        int i = 0;
        while (items != null) {
            if ((ret = (PersistentHashSet)ret.cons(items.first())).count() != i + 1) {
                throw new IllegalArgumentException("Duplicate key: " + items.first());
            }
            items = items.next();
            ++i;
        }
        return ret;
    }

    PersistentHashSet(IPersistentMap meta, IPersistentMap impl) {
        super(meta, impl);
    }

    @Override
    public IPersistentSet disjoin(Object key) throws Exception {
        if (this.contains(key)) {
            return new PersistentHashSet(this.meta(), this.impl.without(key));
        }
        return this;
    }

    @Override
    public IPersistentSet cons(Object o) {
        if (this.contains(o)) {
            return this;
        }
        return new PersistentHashSet(this.meta(), this.impl.associate(o, o));
    }

    @Override
    public IPersistentCollection empty() {
        return EMPTY.withMeta(this.meta());
    }

    public PersistentHashSet withMeta(IPersistentMap meta) {
        return new PersistentHashSet(meta, this.impl);
    }

    @Override
    public ITransientCollection asTransient() {
        return new TransientHashSet(((PersistentHashMap)this.impl).asTransient());
    }

    static final class TransientHashSet
    extends ATransientSet {
        TransientHashSet(ITransientMap impl) {
            super(impl);
        }

        @Override
        public IPersistentCollection persistent() {
            return new PersistentHashSet(null, this.impl.persistent());
        }
    }
}

