/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.persistent;

import java.util.Iterator;
import java.util.Map;
import seph.lang.SephObject;
import seph.lang.persistent.APersistentMap;
import seph.lang.persistent.ASeq;
import seph.lang.persistent.ATransientMap;
import seph.lang.persistent.Counted;
import seph.lang.persistent.EditableCollection;
import seph.lang.persistent.IMapEntry;
import seph.lang.persistent.IPersistentMap;
import seph.lang.persistent.ISeq;
import seph.lang.persistent.ITransientMap;
import seph.lang.persistent.MapEntry;
import seph.lang.persistent.PersistentHashMap;

public class PersistentArrayMap
extends APersistentMap
implements SephObject,
EditableCollection {
    final Object[] array;
    static final int HASHTABLE_THRESHOLD = 16;
    public static final PersistentArrayMap EMPTY = new PersistentArrayMap();

    public static IPersistentMap create(Map other) {
        ITransientMap ret = EMPTY.asTransient();
        Iterator i$ = other.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = i$.next();
            ret = ret.associate(e.getKey(), e.getValue());
        }
        return ret.persistent();
    }

    protected PersistentArrayMap() {
        this.array = new Object[0];
    }

    public PersistentArrayMap withMeta(IPersistentMap meta) {
        return new PersistentArrayMap(meta, this.array);
    }

    PersistentArrayMap create(Object ... init) {
        return new PersistentArrayMap(this.meta(), init);
    }

    IPersistentMap createHT(Object[] init) {
        return PersistentHashMap.create(this.meta(), init);
    }

    public static PersistentArrayMap createWithCheck(Object[] init) {
        for (int i = 0; i < init.length; i += 2) {
            for (int j = i + 2; j < init.length; j += 2) {
                if (!PersistentArrayMap.equalKey(init[i], init[j])) continue;
                throw new IllegalArgumentException("Duplicate key: " + init[i]);
            }
        }
        return new PersistentArrayMap(init);
    }

    public PersistentArrayMap(Object[] init) {
        this.array = init;
    }

    public PersistentArrayMap(IPersistentMap meta, Object[] init) {
        super(meta);
        this.array = init;
    }

    @Override
    public int count() {
        return this.array.length / 2;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexOf(key) >= 0;
    }

    @Override
    public IMapEntry entryAt(Object key) {
        int i = this.indexOf(key);
        if (i >= 0) {
            return new MapEntry(this.array[i], this.array[i + 1]);
        }
        return null;
    }

    @Override
    public IPersistentMap associateOrFail(Object key, Object val) throws Exception {
        int i = this.indexOf(key);
        if (i >= 0) {
            throw new Exception("Key already present");
        }
        if (this.array.length > 16) {
            return this.createHT(this.array).associateOrFail(key, val);
        }
        Object[] newArray = new Object[this.array.length + 2];
        if (this.array.length > 0) {
            System.arraycopy(this.array, 0, newArray, 2, this.array.length);
        }
        newArray[0] = key;
        newArray[1] = val;
        return this.create(newArray);
    }

    @Override
    public IPersistentMap associate(Object key, Object val) {
        Object[] newArray;
        int i = this.indexOf(key);
        if (i >= 0) {
            if (this.array[i + 1] == val) {
                return this;
            }
            newArray = (Object[])this.array.clone();
            newArray[i + 1] = val;
        } else {
            if (this.array.length > 16) {
                return this.createHT(this.array).associate(key, val);
            }
            newArray = new Object[this.array.length + 2];
            if (this.array.length > 0) {
                System.arraycopy(this.array, 0, newArray, 2, this.array.length);
            }
            newArray[0] = key;
            newArray[1] = val;
        }
        return this.create(newArray);
    }

    @Override
    public IPersistentMap without(Object key) {
        int i = this.indexOf(key);
        if (i >= 0) {
            int newlen = this.array.length - 2;
            if (newlen == 0) {
                return this.empty();
            }
            Object[] newArray = new Object[newlen];
            int d = 0;
            for (int s = 0; s < this.array.length; s += 2) {
                if (PersistentArrayMap.equalKey(this.array[s], key)) continue;
                newArray[d] = this.array[s];
                newArray[d + 1] = this.array[s + 1];
                d += 2;
            }
            return this.create(newArray);
        }
        return this;
    }

    @Override
    public IPersistentMap empty() {
        return EMPTY.withMeta(this.meta());
    }

    @Override
    public final Object valueAt(Object key, Object notFound) {
        int i = this.indexOf(key);
        if (i >= 0) {
            return this.array[i + 1];
        }
        return notFound;
    }

    @Override
    public Object valueAt(Object key) {
        return this.valueAt(key, null);
    }

    public int capacity() {
        return this.count();
    }

    private int indexOf(Object key) {
        for (int i = 0; i < this.array.length; i += 2) {
            if (!PersistentArrayMap.equalKey(this.array[i], key)) continue;
            return i;
        }
        return -1;
    }

    static boolean equalKey(Object k1, Object k2) {
        if (k1 == null) {
            return k2 == null;
        }
        return k1.equals(k2);
    }

    public Iterator iterator() {
        return new Iter(this.array);
    }

    @Override
    public ISeq seq() {
        if (this.array.length > 0) {
            return new Seq(this.array, 0);
        }
        return null;
    }

    @Override
    public ITransientMap asTransient() {
        return new TransientArrayMap(this.array);
    }

    static final class TransientArrayMap
    extends ATransientMap {
        int len;
        final Object[] array;
        Thread owner = Thread.currentThread();

        public TransientArrayMap(Object[] array) {
            this.array = new Object[Math.max(16, array.length)];
            System.arraycopy(array, 0, this.array, 0, array.length);
            this.len = array.length;
        }

        private int indexOf(Object key) {
            for (int i = 0; i < this.len; i += 2) {
                if (!PersistentArrayMap.equalKey(this.array[i], key)) continue;
                return i;
            }
            return -1;
        }

        @Override
        ITransientMap doAssoc(Object key, Object val) {
            int i = this.indexOf(key);
            if (i >= 0) {
                if (this.array[i + 1] != val) {
                    this.array[i + 1] = val;
                }
            } else {
                if (this.len >= this.array.length) {
                    return PersistentHashMap.create(this.array).asTransient().associate(key, val);
                }
                this.array[this.len++] = key;
                this.array[this.len++] = val;
            }
            return this;
        }

        @Override
        ITransientMap doWithout(Object key) {
            int i = this.indexOf(key);
            if (i >= 0) {
                if (this.len >= 2) {
                    this.array[i] = this.array[this.len - 2];
                    this.array[i + 1] = this.array[this.len - 1];
                }
                this.len -= 2;
            }
            return this;
        }

        @Override
        Object doValAt(Object key, Object notFound) {
            int i = this.indexOf(key);
            if (i >= 0) {
                return this.array[i + 1];
            }
            return notFound;
        }

        @Override
        int doCount() {
            return this.len / 2;
        }

        @Override
        IPersistentMap doPersistent() {
            this.ensureEditable();
            this.owner = null;
            Object[] a = new Object[this.len];
            System.arraycopy(this.array, 0, a, 0, this.len);
            return new PersistentArrayMap(a);
        }

        @Override
        void ensureEditable() {
            if (this.owner == Thread.currentThread()) {
                return;
            }
            if (this.owner != null) {
                throw new IllegalAccessError("Transient used by non-owner thread");
            }
            throw new IllegalAccessError("Transient used after persistent! call");
        }
    }

    static class Iter
    implements Iterator {
        Object[] array;
        int i;

        Iter(Object[] array) {
            this(array, -2);
        }

        Iter(Object[] array, int i) {
            this.array = array;
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.array.length - 2;
        }

        public Object next() {
            this.i += 2;
            return new MapEntry(this.array[this.i], this.array[this.i + 1]);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Seq
    extends ASeq
    implements Counted {
        final Object[] array;
        final int i;

        Seq(Object[] array, int i) {
            this.array = array;
            this.i = i;
        }

        public Seq(IPersistentMap meta, Object[] array, int i) {
            super(meta);
            this.array = array;
            this.i = i;
        }

        @Override
        public Object first() {
            return new MapEntry(this.array[this.i], this.array[this.i + 1]);
        }

        @Override
        public ISeq next() {
            if (this.i + 2 < this.array.length) {
                return new Seq(this.array, this.i + 2);
            }
            return null;
        }

        @Override
        public int count() {
            return (this.array.length - this.i) / 2;
        }

        public Seq withMeta(IPersistentMap meta) {
            return new Seq(meta, this.array, this.i);
        }
    }
}

