/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.persistent;

import java.math.BigDecimal;
import java.math.BigInteger;

public class Numbers {
    static final IntegerOps INTEGER_OPS = new IntegerOps();
    static final LongOps LONG_OPS = new LongOps();
    static final FloatOps FLOAT_OPS = new FloatOps();
    static final DoubleOps DOUBLE_OPS = new DoubleOps();
    static final BigIntegerOps BIGINTEGER_OPS = new BigIntegerOps();
    static final BigDecimalOps BIGDECIMAL_OPS = new BigDecimalOps();

    public static int compare(Number x, Number y) {
        Ops ops = Numbers.ops(x).combine(Numbers.ops(y));
        if (ops.lt(x, y)) {
            return -1;
        }
        if (ops.lt(y, x)) {
            return 1;
        }
        return 0;
    }

    static BigInteger toBigInteger(Object x) {
        if (x instanceof BigInteger) {
            return (BigInteger)x;
        }
        return BigInteger.valueOf(((Number)x).longValue());
    }

    static BigDecimal toBigDecimal(Object x) {
        if (x instanceof BigDecimal) {
            return (BigDecimal)x;
        }
        if (x instanceof BigInteger) {
            return new BigDecimal((BigInteger)x);
        }
        return BigDecimal.valueOf(((Number)x).longValue());
    }

    static Ops ops(Object x) {
        Class<?> xc = x.getClass();
        if (xc == Integer.class) {
            return INTEGER_OPS;
        }
        if (xc == Double.class) {
            return DOUBLE_OPS;
        }
        if (xc == Float.class) {
            return FLOAT_OPS;
        }
        if (xc == BigInteger.class) {
            return BIGINTEGER_OPS;
        }
        if (xc == Long.class) {
            return LONG_OPS;
        }
        if (xc == BigDecimal.class) {
            return BIGDECIMAL_OPS;
        }
        return INTEGER_OPS;
    }

    static final class BigDecimalOps
    implements Ops {
        BigDecimalOps() {
        }

        @Override
        public Ops combine(Ops y) {
            return y.opsWith(this);
        }

        @Override
        public final Ops opsWith(IntegerOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(LongOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(FloatOps x) {
            return FLOAT_OPS;
        }

        @Override
        public final Ops opsWith(DoubleOps x) {
            return DOUBLE_OPS;
        }

        @Override
        public final Ops opsWith(BigIntegerOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(BigDecimalOps x) {
            return this;
        }

        @Override
        public boolean lt(Number x, Number y) {
            return Numbers.toBigDecimal(x).compareTo(Numbers.toBigDecimal(y)) < 0;
        }
    }

    static final class BigIntegerOps
    implements Ops {
        BigIntegerOps() {
        }

        @Override
        public Ops combine(Ops y) {
            return y.opsWith(this);
        }

        @Override
        public final Ops opsWith(IntegerOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(LongOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(FloatOps x) {
            return FLOAT_OPS;
        }

        @Override
        public final Ops opsWith(DoubleOps x) {
            return DOUBLE_OPS;
        }

        @Override
        public final Ops opsWith(BigIntegerOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(BigDecimalOps x) {
            return BIGDECIMAL_OPS;
        }

        @Override
        public boolean lt(Number x, Number y) {
            return Numbers.toBigInteger(x).compareTo(Numbers.toBigInteger(y)) < 0;
        }
    }

    static final class DoubleOps
    implements Ops {
        DoubleOps() {
        }

        @Override
        public Ops combine(Ops y) {
            return y.opsWith(this);
        }

        @Override
        public final Ops opsWith(IntegerOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(LongOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(FloatOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(DoubleOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(BigIntegerOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(BigDecimalOps x) {
            return this;
        }

        @Override
        public boolean lt(Number x, Number y) {
            return x.doubleValue() < y.doubleValue();
        }
    }

    static final class FloatOps
    implements Ops {
        FloatOps() {
        }

        @Override
        public Ops combine(Ops y) {
            return y.opsWith(this);
        }

        @Override
        public final Ops opsWith(IntegerOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(LongOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(FloatOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(DoubleOps x) {
            return DOUBLE_OPS;
        }

        @Override
        public final Ops opsWith(BigIntegerOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(BigDecimalOps x) {
            return this;
        }

        @Override
        public boolean lt(Number x, Number y) {
            return x.floatValue() < y.floatValue();
        }
    }

    static final class LongOps
    implements Ops {
        LongOps() {
        }

        @Override
        public Ops combine(Ops y) {
            return y.opsWith(this);
        }

        @Override
        public final Ops opsWith(IntegerOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(LongOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(FloatOps x) {
            return FLOAT_OPS;
        }

        @Override
        public final Ops opsWith(DoubleOps x) {
            return DOUBLE_OPS;
        }

        @Override
        public final Ops opsWith(BigIntegerOps x) {
            return BIGINTEGER_OPS;
        }

        @Override
        public final Ops opsWith(BigDecimalOps x) {
            return BIGDECIMAL_OPS;
        }

        @Override
        public boolean lt(Number x, Number y) {
            return x.longValue() < y.longValue();
        }
    }

    static final class IntegerOps
    implements Ops {
        IntegerOps() {
        }

        @Override
        public Ops combine(Ops y) {
            return y.opsWith(this);
        }

        @Override
        public final Ops opsWith(IntegerOps x) {
            return this;
        }

        @Override
        public final Ops opsWith(LongOps x) {
            return LONG_OPS;
        }

        @Override
        public final Ops opsWith(FloatOps x) {
            return FLOAT_OPS;
        }

        @Override
        public final Ops opsWith(DoubleOps x) {
            return DOUBLE_OPS;
        }

        @Override
        public final Ops opsWith(BigIntegerOps x) {
            return BIGINTEGER_OPS;
        }

        @Override
        public final Ops opsWith(BigDecimalOps x) {
            return BIGDECIMAL_OPS;
        }

        @Override
        public boolean lt(Number x, Number y) {
            return x.intValue() < y.intValue();
        }
    }

    static interface Ops {
        public Ops combine(Ops var1);

        public Ops opsWith(IntegerOps var1);

        public Ops opsWith(LongOps var1);

        public Ops opsWith(FloatOps var1);

        public Ops opsWith(DoubleOps var1);

        public Ops opsWith(BigIntegerOps var1);

        public Ops opsWith(BigDecimalOps var1);

        public boolean lt(Number var1, Number var2);
    }
}

