/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.persistent;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import seph.lang.SimpleSephObject;
import seph.lang.persistent.IPersistentMap;
import seph.lang.persistent.IPersistentSet;
import seph.lang.persistent.ISeq;
import seph.lang.persistent.RT;
import seph.lang.persistent.SeqIterator;
import seph.lang.persistent.Util;

public abstract class APersistentSet
extends SimpleSephObject
implements IPersistentSet,
Collection,
Set,
Serializable {
    int _hash = -1;
    final IPersistentMap impl;

    protected APersistentSet(IPersistentMap impl) {
        this.impl = impl;
    }

    protected APersistentSet(IPersistentMap meta, IPersistentMap impl) {
        super(meta);
        this.impl = impl;
    }

    @Override
    public boolean contains(Object key) {
        return this.impl.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        return this.impl.valueAt(key);
    }

    @Override
    public int count() {
        return this.impl.count();
    }

    @Override
    public ISeq seq() {
        return RT.keys(this.impl);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        Set m = (Set)obj;
        if (m.size() != this.count() || m.hashCode() != this.hashCode()) {
            return false;
        }
        for (Object aM : m) {
            if (this.contains(aM)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equiv(Object o) {
        return this.equals(o);
    }

    @Override
    public int hashCode() {
        if (this._hash == -1) {
            int hash = 0;
            for (ISeq s = this.seq(); s != null; s = s.next()) {
                Object e = s.first();
                hash += Util.hash(e);
            }
            this._hash = hash;
        }
        return this._hash;
    }

    @Override
    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length >= this.count()) {
            int i = 0;
            for (ISeq s = this.seq(); s != null; s = s.next()) {
                a[i] = s.first();
                ++i;
            }
            if (a.length > this.count()) {
                a[this.count()] = null;
            }
            return a;
        }
        return this.toArray();
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    @Override
    public Iterator iterator() {
        return new SeqIterator(this.seq());
    }
}

