/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.performance;

import java.util.Arrays;
import seph.lang.SephObject;
import seph.lang.persistent.PersistentArrayMap;
import seph.lang.persistent.PersistentHashMap;
import seph.lang.structure.SephObject_0_1;
import seph.lang.structure.SephObject_0_10;
import seph.lang.structure.SephObject_0_2;
import seph.lang.structure.SephObject_0_30;
import seph.lang.structure.SephObject_0_n;

public class CellLookup {
    private static final String KEY = "foobar";
    private static final String RESET = "\u001b[0m";
    private static final String RED = "\u001b[31m";
    private static final String GREEN = "\u001b[32m";
    private static final String YELLOW = "\u001b[33m";

    private static final void single(int iterations, SephObject obj, long[] result) throws Exception {
        for (int j = 0; j < 10; ++j) {
            long before = System.currentTimeMillis();
            for (int i = 0; i < iterations; ++i) {
                obj.get(KEY);
            }
            long after = System.currentTimeMillis();
            result[j] = after - before;
        }
    }

    private static void bench(String desc, int iterations, boolean warmup, SephObject hard, SephObject array, SephObject hash) throws Exception {
        long[] hard_results = new long[10];
        long[] array_results = new long[10];
        long[] hash_results = new long[10];
        CellLookup.single(iterations, hard, hard_results);
        CellLookup.single(iterations, array, array_results);
        CellLookup.single(iterations, hash, hash_results);
        if (!warmup) {
            Arrays.sort(hard_results);
            Arrays.sort(array_results);
            Arrays.sort(hash_results);
            String color = hard_results[0] <= array_results[0] && hard_results[0] <= hash_results[0] ? GREEN : (array_results[0] <= hash_results[0] ? YELLOW : RED);
            System.out.printf(" %s%-40s hard: %-6d array: %-6d hash: %-6d%s\n", color, desc, hard_results[0], array_results[0], hash_results[0], RESET);
        } else {
            System.out.print(".");
        }
    }

    private static void bench1(String desc, int iterations, boolean warmup) throws Exception {
        SephObject_0_1 hard = new SephObject_0_1(null, KEY, null);
        SephObject_0_n array = new SephObject_0_n(null, new PersistentArrayMap(new Object[]{KEY, null}));
        SephObject_0_n hash = new SephObject_0_n(null, PersistentHashMap.create(KEY, null));
        CellLookup.bench(desc, iterations, warmup, hard, array, hash);
    }

    private static void bench2(String desc, int iterations, boolean warmup) throws Exception {
        SephObject_0_1 hard = new SephObject_0_1(null, "another key", null);
        SephObject_0_n array = new SephObject_0_n(null, new PersistentArrayMap(new Object[]{"another key", null}));
        SephObject_0_n hash = new SephObject_0_n(null, PersistentHashMap.create("another key", null));
        CellLookup.bench(desc, iterations, warmup, hard, array, hash);
    }

    private static void bench3(String desc, int iterations, boolean warmup) throws Exception {
        SephObject_0_2 hard = new SephObject_0_2(null, KEY, null, "another key", null);
        SephObject_0_n array = new SephObject_0_n(null, new PersistentArrayMap(new Object[]{KEY, null, "another key", null}));
        SephObject_0_n hash = new SephObject_0_n(null, PersistentHashMap.create(KEY, null, "another key", null));
        CellLookup.bench(desc, iterations, warmup, hard, array, hash);
    }

    private static void bench4(String desc, int iterations, boolean warmup) throws Exception {
        SephObject_0_2 hard = new SephObject_0_2(null, "another key", null, KEY, null);
        SephObject_0_n array = new SephObject_0_n(null, new PersistentArrayMap(new Object[]{"another key", null, KEY, null}));
        SephObject_0_n hash = new SephObject_0_n(null, PersistentHashMap.create("another key", null, KEY, null));
        CellLookup.bench(desc, iterations, warmup, hard, array, hash);
    }

    private static void bench5(String desc, int iterations, boolean warmup) throws Exception {
        SephObject_0_2 hard = new SephObject_0_2(null, "another key", null, "newer key", null);
        SephObject_0_n array = new SephObject_0_n(null, new PersistentArrayMap(new Object[]{"another key", null, "newer key", null}));
        SephObject_0_n hash = new SephObject_0_n(null, PersistentHashMap.create("another key", null, "newer key", null));
        CellLookup.bench(desc, iterations, warmup, hard, array, hash);
    }

    private static void bench6(String desc, int iterations, boolean warmup) throws Exception {
        SephObject_0_10 hard = new SephObject_0_10(null, KEY, null, "another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null);
        SephObject_0_n array = new SephObject_0_n(null, new PersistentArrayMap(new Object[]{KEY, null, "another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null}));
        SephObject_0_n hash = new SephObject_0_n(null, PersistentHashMap.create(KEY, null, "another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null));
        CellLookup.bench(desc, iterations, warmup, hard, array, hash);
    }

    private static void bench7(String desc, int iterations, boolean warmup) throws Exception {
        SephObject_0_10 hard = new SephObject_0_10(null, "another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null, KEY, null);
        SephObject_0_n array = new SephObject_0_n(null, new PersistentArrayMap(new Object[]{"another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null, KEY, null}));
        SephObject_0_n hash = new SephObject_0_n(null, PersistentHashMap.create("another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null, KEY, null));
        CellLookup.bench(desc, iterations, warmup, hard, array, hash);
    }

    private static void bench8(String desc, int iterations, boolean warmup) throws Exception {
        SephObject_0_10 hard = new SephObject_0_10(null, "another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null, "another key10", null);
        SephObject_0_n array = new SephObject_0_n(null, new PersistentArrayMap(new Object[]{"another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null, "another key10", null}));
        SephObject_0_n hash = new SephObject_0_n(null, PersistentHashMap.create("another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null, "another key10", null));
        CellLookup.bench(desc, iterations, warmup, hard, array, hash);
    }

    private static void bench9(String desc, int iterations, boolean warmup) throws Exception {
        SephObject_0_30 hard = new SephObject_0_30(null, KEY, null, "another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null, "1another key", null, "1another key2", null, "1another key3", null, "1another key4", null, "1another key5", null, "1another key6", null, "1another key7", null, "1another key8", null, "1another key9", null, "2another key", null, "2another key2", null, "2another key3", null, "2another key4", null, "2another key5", null, "2another key6", null, "2another key7", null, "2another key8", null, "2another key9", null, "3another key7", null, "3another key8", null);
        SephObject_0_n array = new SephObject_0_n(null, new PersistentArrayMap(new Object[]{KEY, null, "another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null, "1another key", null, "1another key2", null, "1another key3", null, "1another key4", null, "1another key5", null, "1another key6", null, "1another key7", null, "1another key8", null, "1another key9", null, "2another key", null, "2another key2", null, "2another key3", null, "2another key4", null, "2another key5", null, "2another key6", null, "2another key7", null, "2another key8", null, "2another key9", null, "3another key7", null, "3another key8", null}));
        SephObject_0_n hash = new SephObject_0_n(null, PersistentHashMap.create(KEY, null, "another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null, "1another key", null, "1another key2", null, "1another key3", null, "1another key4", null, "1another key5", null, "1another key6", null, "1another key7", null, "1another key8", null, "1another key9", null, "2another key", null, "2another key2", null, "2another key3", null, "2another key4", null, "2another key5", null, "2another key6", null, "2another key7", null, "2another key8", null, "2another key9", null, "3another key7", null, "3another key8", null));
        CellLookup.bench(desc, iterations, warmup, hard, array, hash);
    }

    private static void bench10(String desc, int iterations, boolean warmup) throws Exception {
        SephObject_0_30 hard = new SephObject_0_30(null, "another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null, "1another key", null, "1another key2", null, "1another key3", null, "1another key4", null, "1another key5", null, "1another key6", null, "1another key7", null, "1another key8", null, "1another key9", null, "2another key", null, "2another key2", null, "2another key3", null, "2another key4", null, "2another key5", null, "2another key6", null, "2another key7", null, "2another key8", null, "2another key9", null, "3another key7", null, "3another key8", null, KEY, null);
        SephObject_0_n array = new SephObject_0_n(null, new PersistentArrayMap(new Object[]{"another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null, "1another key", null, "1another key2", null, "1another key3", null, "1another key4", null, "1another key5", null, "1another key6", null, "1another key7", null, "1another key8", null, "1another key9", null, "2another key", null, "2another key2", null, "2another key3", null, "2another key4", null, "2another key5", null, "2another key6", null, "2another key7", null, "2another key8", null, "2another key9", null, "3another key7", null, "3another key8", null, KEY, null}));
        SephObject_0_n hash = new SephObject_0_n(null, PersistentHashMap.create("another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null, "1another key", null, "1another key2", null, "1another key3", null, "1another key4", null, "1another key5", null, "1another key6", null, "1another key7", null, "1another key8", null, "1another key9", null, "2another key", null, "2another key2", null, "2another key3", null, "2another key4", null, "2another key5", null, "2another key6", null, "2another key7", null, "2another key8", null, "2another key9", null, "3another key7", null, "3another key8", null, KEY, null));
        CellLookup.bench(desc, iterations, warmup, hard, array, hash);
    }

    private static void bench11(String desc, int iterations, boolean warmup) throws Exception {
        SephObject_0_30 hard = new SephObject_0_30(null, "another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null, "1another key", null, "1another key2", null, "1another key3", null, "1another key4", null, "1another key5", null, "1another key6", null, "1another key7", null, "1another key8", null, "1another key9", null, "2another key", null, "2another key2", null, "2another key3", null, "2another key4", null, "2another key5", null, "2another key6", null, "2another key7", null, "2another key8", null, "2another key9", null, "3another key7", null, "3another key8", null, "3another key9", null);
        SephObject_0_n array = new SephObject_0_n(null, new PersistentArrayMap(new Object[]{"another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null, "1another key", null, "1another key2", null, "1another key3", null, "1another key4", null, "1another key5", null, "1another key6", null, "1another key7", null, "1another key8", null, "1another key9", null, "2another key", null, "2another key2", null, "2another key3", null, "2another key4", null, "2another key5", null, "2another key6", null, "2another key7", null, "2another key8", null, "2another key9", null, "3another key7", null, "3another key8", null, "3another key9", null}));
        SephObject_0_n hash = new SephObject_0_n(null, PersistentHashMap.create("another key", null, "another key2", null, "another key3", null, "another key4", null, "another key5", null, "another key6", null, "another key7", null, "another key8", null, "another key9", null, "1another key", null, "1another key2", null, "1another key3", null, "1another key4", null, "1another key5", null, "1another key6", null, "1another key7", null, "1another key8", null, "1another key9", null, "2another key", null, "2another key2", null, "2another key3", null, "2another key4", null, "2another key5", null, "2another key6", null, "2another key7", null, "2another key8", null, "2another key9", null, "3another key7", null, "3another key8", null, "3another key9", null));
        CellLookup.bench(desc, iterations, warmup, hard, array, hash);
    }

    public static void main(String[] args) throws Exception {
        System.out.print("warmup");
        CellLookup.bench1(null, 1000000, true);
        CellLookup.bench2(null, 1000000, true);
        CellLookup.bench3(null, 1000000, true);
        CellLookup.bench4(null, 1000000, true);
        CellLookup.bench5(null, 1000000, true);
        CellLookup.bench6(null, 1000000, true);
        CellLookup.bench7(null, 1000000, true);
        CellLookup.bench8(null, 1000000, true);
        CellLookup.bench9(null, 1000000, true);
        CellLookup.bench10(null, 1000000, true);
        CellLookup.bench11(null, 1000000, true);
        System.out.println();
        System.out.println();
        CellLookup.bench1("1 cell/0 parents - hit", 1000000, false);
        CellLookup.bench2("1 cell/0 parents - no hit", 1000000, false);
        System.out.println();
        CellLookup.bench3("2 cells/0 parents - hit first", 1000000, false);
        CellLookup.bench4("2 cells/0 parents - hit second", 1000000, false);
        CellLookup.bench5("2 cells/0 parents - no hit", 1000000, false);
        System.out.println();
        CellLookup.bench6("10 cells/0 parents - hit first", 1000000, false);
        CellLookup.bench7("10 cells/0 parents - hit last", 1000000, false);
        CellLookup.bench8("10 cells/0 parents - no hit", 1000000, false);
        System.out.println();
        CellLookup.bench9("30 cells/0 parents - hit first", 1000000, false);
        CellLookup.bench10("30 cells/0 parents - hit last", 1000000, false);
        CellLookup.bench11("30 cells/0 parents - no hit", 1000000, false);
    }
}

