/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.parser;

import gnu.math.DFloNum;
import gnu.math.IntNum;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import seph.lang.ControlFlow;
import seph.lang.Runtime;
import seph.lang.ast.LiteralMessage;
import seph.lang.ast.Message;
import seph.lang.ast.NamedMessage;
import seph.lang.parser.MutableMessage;
import seph.lang.persistent.IPersistentList;
import seph.lang.persistent.IPersistentMap;
import seph.lang.persistent.IPersistentSet;
import seph.lang.persistent.ISeq;
import seph.lang.persistent.PersistentArrayMap;
import seph.lang.persistent.PersistentHashSet;
import seph.lang.persistent.PersistentList;

public class Parser {
    private final Runtime runtime;
    private final Reader reader;
    private final String sourcename;
    private final IPersistentMap operators;
    private final IPersistentMap assignmentOperators;
    private final IPersistentSet unaryOperators;
    public static final IPersistentMap DEFAULT_OPERATORS;
    public static final IPersistentMap DEFAULT_ASSIGNMENT_OPERATORS;
    public static final IPersistentSet DEFAULT_UNARY_OPERATORS;
    private ChainContext top = new ChainContext(null);
    private int lineNumber = 1;
    private int currentCharacter = -1;
    private boolean skipLF = false;
    private int saved2 = -2;
    private int saved = -2;
    private static final String[] RANGES;
    private static final boolean[][] BASES;

    public Parser(Runtime runtime, Reader reader, String sourcename) {
        this(runtime, reader, sourcename, DEFAULT_OPERATORS, DEFAULT_ASSIGNMENT_OPERATORS, DEFAULT_UNARY_OPERATORS);
    }

    public Parser(Runtime runtime, Reader reader, String sourcename, IPersistentMap operators, IPersistentMap assignmentOperators, IPersistentSet unaryOperators) {
        this.runtime = runtime;
        this.reader = reader;
        this.sourcename = sourcename;
        this.operators = operators;
        this.assignmentOperators = assignmentOperators;
        this.unaryOperators = unaryOperators;
    }

    public IPersistentList parseFully() throws IOException, ControlFlow {
        IPersistentList all = this.parseCommaSeparatedMessageChains();
        if (all.count() == 0) {
            all = (IPersistentList)all.cons(NamedMessage.create(".", null, null, this.sourcename, 0, 0));
        }
        return all;
    }

    private static final IPersistentMap addOpEntry(String name, int precedence, IPersistentMap current) {
        return current.associate(name, new OpEntry(name, precedence));
    }

    private static final IPersistentMap addOpArity(String name, int arity, IPersistentMap current) {
        return current.associate(name, new OpArity(name, arity));
    }

    private Message parseMessageChain() throws IOException, ControlFlow {
        this.top = new ChainContext(this.top);
        this.top.push(new ArrayList<Message>());
        while (this.parseMessage()) {
        }
        this.top.popOperatorsTo(999999);
        Message ret = this.top.pop();
        this.top = this.top.parent;
        return ret;
    }

    private IPersistentList parseCommaSeparatedMessageChains() throws IOException, ControlFlow {
        ArrayList<Message> chain = new ArrayList<Message>();
        Message curr = this.parseMessageChain();
        while (curr != null) {
            chain.add(curr);
            this.readWhiteSpace();
            int rr = this.peek();
            if (rr == 44) {
                this.read();
                curr = this.parseMessageChain();
                if (curr != null) continue;
                this.fail("Expected message chain following comma");
                continue;
            }
            if (curr != null && curr.name().equals(".") && curr.next() == null) {
                chain.remove(chain.size() - 1);
            }
            curr = null;
        }
        return PersistentList.create(chain);
    }

    private int read() throws IOException {
        if (this.saved > -2) {
            int x = this.saved;
            this.saved = this.saved2;
            this.saved2 = -2;
            if (this.skipLF) {
                this.skipLF = false;
                if (x == 10) {
                    return x;
                }
            }
            ++this.currentCharacter;
            switch (x) {
                case 13: {
                    this.skipLF = true;
                }
                case 10: {
                    ++this.lineNumber;
                    this.currentCharacter = 0;
                }
            }
            return x;
        }
        int xx = this.reader.read();
        if (this.skipLF) {
            this.skipLF = false;
            if (xx == 10) {
                return xx;
            }
        }
        ++this.currentCharacter;
        switch (xx) {
            case 13: {
                this.skipLF = true;
            }
            case 10: {
                ++this.lineNumber;
                this.currentCharacter = 0;
            }
        }
        return xx;
    }

    private int peek() throws IOException {
        if (this.saved == -2) {
            if (this.saved2 != -2) {
                this.saved = this.saved2;
                this.saved2 = -2;
            } else {
                this.saved = this.reader.read();
            }
        }
        return this.saved;
    }

    private int peek2() throws IOException {
        if (this.saved == -2) {
            this.saved = this.reader.read();
        }
        if (this.saved2 == -2) {
            this.saved2 = this.reader.read();
        }
        return this.saved2;
    }

    private boolean parseMessage() throws IOException, ControlFlow {
        int rr;
        block29: while (true) {
            rr = this.peek();
            switch (rr) {
                case -1: {
                    this.read();
                    return false;
                }
                case 41: 
                case 44: 
                case 93: 
                case 125: {
                    return false;
                }
                case 40: {
                    this.read();
                    this.parseEmptyMessageSend();
                    return true;
                }
                case 91: {
                    this.read();
                    this.parseOpenCloseMessageSend(']', "[]");
                    return true;
                }
                case 123: {
                    this.read();
                    this.parseOpenCloseMessageSend('}', "{}");
                    return true;
                }
                case 35: {
                    this.read();
                    switch (this.peek()) {
                        case 123: {
                            this.parseSimpleOpenCloseMessageSend('}', "set");
                            return true;
                        }
                        case 91: {
                            this.parseSimpleOpenCloseMessageSend(']', "vector");
                            return true;
                        }
                        case 33: {
                            this.parseComment();
                            continue block29;
                        }
                    }
                    this.parseOperatorChars(35);
                    return true;
                }
                case 34: {
                    this.read();
                    this.parseText(34);
                    return true;
                }
                case 46: {
                    this.read();
                    rr = this.peek();
                    if (rr == 46) {
                        this.parseRange();
                    } else {
                        this.parseTerminator(46);
                    }
                    return true;
                }
                case 59: {
                    this.read();
                    this.parseComment();
                    continue block29;
                }
                case 9: 
                case 11: 
                case 12: 
                case 32: {
                    this.read();
                    this.readWhiteSpace();
                    continue block29;
                }
                case 10: 
                case 13: {
                    this.read();
                    this.parseTerminator(rr);
                    return true;
                }
                case 92: {
                    this.read();
                    rr = this.peek();
                    if (rr == 10) {
                        this.read();
                        continue block29;
                    }
                    this.fail("Expected newline after free-floating escape character");
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.read();
                    this.parseNumber(rr);
                    return true;
                }
                case 37: {
                    this.read();
                    switch (this.peek()) {
                        case 47: {
                            this.parseRegexpLiteral(47);
                            break;
                        }
                        case 114: {
                            this.parseRegexpLiteral(114);
                            break;
                        }
                        case 91: {
                            this.parseText(91);
                            break;
                        }
                        default: {
                            this.parseOperatorChars(37);
                        }
                    }
                    return true;
                }
                case 45: {
                    if (this.isDigit(this.peek2())) {
                        this.read();
                        this.parseNumber(rr);
                        return true;
                    }
                }
                case 33: 
                case 36: 
                case 38: 
                case 39: 
                case 42: 
                case 43: 
                case 47: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 94: 
                case 96: 
                case 124: 
                case 126: {
                    this.read();
                    this.parseOperatorChars(rr);
                    return true;
                }
                case 58: {
                    this.read();
                    rr = this.peek();
                    if (this.isLetter(rr) || this.isIDDigit(rr)) {
                        this.parseRegularMessageSend(58);
                    } else {
                        this.parseOperatorChars(58);
                    }
                    return true;
                }
            }
            break;
        }
        this.read();
        this.parseRegularMessageSend(rr);
        return true;
    }

    private void readWhiteSpace() throws IOException {
        int rr;
        while ((rr = this.peek()) == 32 || rr == 9 || rr == 11 || rr == 12) {
            this.read();
        }
    }

    private void parseRegularMessageSend(int indicator) throws IOException, ControlFlow {
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        StringBuilder sb = new StringBuilder();
        sb.append((char)indicator);
        int rr = -1;
        while (this.isLetter(rr = this.peek()) || this.isIDDigit(rr) || rr == 58 || rr == 33 || rr == 63 || rr == 36) {
            this.read();
            sb.append((char)rr);
        }
        IPersistentList args = null;
        if (rr == 40) {
            this.read();
            args = this.parseCommaSeparatedMessageChains();
            this.parseCharacter(41);
            this.top.currentMessageChain.add(NamedMessage.create(sb.toString(), args, null, this.sourcename, l, cc));
            this.top.added();
        } else {
            this.possibleOperator(sb.toString(), this.sourcename, l, cc);
        }
    }

    private void parseComment() throws IOException {
        int rr;
        while ((rr = this.peek()) != 10 && rr != 13 && rr != -1) {
            this.read();
        }
    }

    private void parseRange() throws IOException, ControlFlow {
        int rr;
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        int count = 2;
        this.read();
        while ((rr = this.peek()) == 46) {
            ++count;
            this.read();
        }
        String result = null;
        if (count < 13) {
            result = RANGES[count];
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < count; ++i) {
                sb.append('.');
            }
            result = sb.toString();
        }
        if (rr == 40) {
            this.read();
            IPersistentList args = this.parseCommaSeparatedMessageChains();
            this.parseCharacter(41);
            this.top.currentMessageChain.add(NamedMessage.create(result, args, null, this.sourcename, l, cc));
            this.top.added();
            return;
        }
        this.possibleOperator(result, this.sourcename, l, cc);
    }

    private void parseTerminator(int indicator) throws IOException {
        int rr;
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        if (indicator == 13 && (rr = this.peek()) == 10) {
            this.read();
        }
        while (true) {
            rr = this.peek();
            int rr2 = this.peek2();
            if (rr == 46 && rr2 != 46 || rr == 10) {
                this.read();
                continue;
            }
            if (rr != 13 || rr2 != 10) break;
            this.read();
            this.read();
        }
        this.top.popOperatorsTo(999999);
        this.top.currentMessageChain.add(NamedMessage.create(".", null, null, this.sourcename, l, cc));
        this.top.added();
    }

    private void parseRegexpLiteral(int indicator) throws IOException, ControlFlow {
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        StringBuilder sb = new StringBuilder();
        boolean slash = indicator == 47;
        this.read();
        if (!slash) {
            this.parseCharacter(91);
        }
        String name = null;
        ArrayList<Message> args = new ArrayList<Message>();
        block13: while (true) {
            int rr = this.peek();
            switch (rr) {
                case -1: {
                    this.fail("Expected end of regular expression, found EOF");
                    continue block13;
                }
                case 47: {
                    this.read();
                    if (slash) {
                        String pattern = sb.toString();
                        sb = new StringBuilder();
                        block14: while (true) {
                            rr = this.peek();
                            switch (rr) {
                                case 105: 
                                case 109: 
                                case 115: 
                                case 117: 
                                case 120: {
                                    this.read();
                                    sb.append((char)rr);
                                    continue block14;
                                }
                            }
                            break;
                        }
                        if (name == null) {
                            this.top.currentMessageChain.add(new LiteralMessage(this.runtime.newRegexp(pattern, sb.toString()), null, this.sourcename, l, cc));
                            this.top.added();
                            return;
                        }
                        if (pattern.length() > 0) {
                            args.add(new LiteralMessage(this.runtime.newUnescapedText(pattern), null, this.sourcename, l, cc));
                        }
                        args.add(new LiteralMessage(this.runtime.newText(sb.toString()), null, this.sourcename, l, cc));
                        this.top.currentMessageChain.add(NamedMessage.create(name, PersistentList.create(args), null, this.sourcename, l, cc));
                        this.top.added();
                        return;
                    }
                    sb.append((char)rr);
                    continue block13;
                }
                case 93: {
                    this.read();
                    if (!slash) {
                        String pattern = sb.toString();
                        sb = new StringBuilder();
                        block15: while (true) {
                            rr = this.peek();
                            switch (rr) {
                                case 105: 
                                case 109: 
                                case 115: 
                                case 117: 
                                case 120: {
                                    this.read();
                                    sb.append((char)rr);
                                    continue block15;
                                }
                            }
                            break;
                        }
                        if (name == null) {
                            this.top.currentMessageChain.add(new LiteralMessage(this.runtime.newRegexp(pattern, sb.toString()), null, this.sourcename, l, cc));
                            this.top.added();
                            return;
                        }
                        if (pattern.length() > 0) {
                            args.add(new LiteralMessage(this.runtime.newUnescapedText(pattern), null, this.sourcename, l, cc));
                        }
                        args.add(new LiteralMessage(this.runtime.newText(sb.toString()), null, this.sourcename, l, cc));
                        this.top.currentMessageChain.add(NamedMessage.create(name, PersistentList.create(args), null, this.sourcename, l, cc));
                        this.top.added();
                        return;
                    }
                    sb.append((char)rr);
                    continue block13;
                }
                case 37: {
                    this.read();
                    rr = this.peek();
                    if (rr == 123) {
                        this.read();
                        args.add(new LiteralMessage(this.runtime.newUnescapedText(sb.toString()), null, this.sourcename, l, cc));
                        sb = new StringBuilder();
                        name = "internal:compositeRegexp";
                        args.add(this.parseMessageChain());
                        this.readWhiteSpace();
                        this.parseCharacter(125);
                        continue block13;
                    }
                    sb.append('#');
                    continue block13;
                }
                case 92: {
                    this.read();
                    this.parseRegexpEscape(sb);
                    continue block13;
                }
            }
            this.read();
            sb.append((char)rr);
        }
    }

    private void parseText(int indicator) throws IOException, ControlFlow {
        boolean dquote;
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        StringBuilder sb = new StringBuilder();
        boolean bl = dquote = indicator == 34;
        if (!dquote) {
            this.read();
        }
        String name = null;
        ArrayList<Message> args = new ArrayList<Message>();
        block7: while (true) {
            int rr = this.peek();
            switch (rr) {
                case -1: {
                    this.fail("Expected end of text, found EOF");
                    continue block7;
                }
                case 34: {
                    this.read();
                    if (dquote) {
                        if (name == null) {
                            this.top.currentMessageChain.add(new LiteralMessage(this.runtime.newText(sb.toString()), null, this.sourcename, l, cc));
                            this.top.added();
                            return;
                        }
                        if (sb.length() > 0) {
                            args.add(new LiteralMessage(this.runtime.newText(sb.toString()), null, this.sourcename, l, cc));
                        }
                        this.top.currentMessageChain.add(NamedMessage.create(name, PersistentList.create(args), null, this.sourcename, l, cc));
                        this.top.added();
                        return;
                    }
                    sb.append((char)rr);
                    continue block7;
                }
                case 93: {
                    this.read();
                    if (!dquote) {
                        if (name == null) {
                            this.top.currentMessageChain.add(new LiteralMessage(this.runtime.newText(sb.toString()), null, this.sourcename, l, cc));
                            this.top.added();
                            return;
                        }
                        if (sb.length() > 0) {
                            args.add(new LiteralMessage(this.runtime.newText(sb.toString()), null, this.sourcename, l, cc));
                        }
                        this.top.currentMessageChain.add(NamedMessage.create(name, PersistentList.create(args), null, this.sourcename, l, cc));
                        this.top.added();
                        return;
                    }
                    sb.append((char)rr);
                    continue block7;
                }
                case 37: {
                    this.read();
                    rr = this.peek();
                    if (rr == 123) {
                        this.read();
                        args.add(new LiteralMessage(this.runtime.newText(sb.toString()), null, this.sourcename, l, cc));
                        sb = new StringBuilder();
                        name = "internal:concatenateText";
                        args.add(this.parseMessageChain());
                        this.readWhiteSpace();
                        this.parseCharacter(125);
                        continue block7;
                    }
                    sb.append('%');
                    continue block7;
                }
                case 92: {
                    this.read();
                    this.parseDoubleQuoteEscape(sb);
                    continue block7;
                }
            }
            this.read();
            sb.append((char)rr);
        }
    }

    private void parseRegexpEscape(StringBuilder sb) throws IOException, ControlFlow {
        sb.append('\\');
        int rr = this.peek();
        switch (rr) {
            case 117: {
                this.read();
                sb.append((char)rr);
                for (int i = 0; i < 4; ++i) {
                    rr = this.peek();
                    if (rr >= 48 && rr <= 57 || rr >= 97 && rr <= 102 || rr >= 65 && rr <= 70) {
                        this.read();
                        sb.append((char)rr);
                        continue;
                    }
                    this.fail("Expected four hexadecimal characters in unicode escape - got: " + Parser.charDesc(rr));
                }
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.read();
                sb.append((char)rr);
                if (rr <= 51) {
                    rr = this.peek();
                    if (rr < 48 || rr > 55) break;
                    this.read();
                    sb.append((char)rr);
                    rr = this.peek();
                    if (rr < 48 || rr > 55) break;
                    this.read();
                    sb.append((char)rr);
                    break;
                }
                rr = this.peek();
                if (rr < 48 || rr > 55) break;
                this.read();
                sb.append((char)rr);
                break;
            }
            case 10: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 71: 
            case 80: 
            case 83: 
            case 87: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 98: 
            case 100: 
            case 102: 
            case 110: 
            case 112: 
            case 114: 
            case 115: 
            case 116: 
            case 119: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                this.read();
                sb.append((char)rr);
                break;
            }
            case 13: {
                this.read();
                sb.append((char)rr);
                rr = this.peek();
                if (rr != 10) break;
                this.read();
                sb.append((char)rr);
                break;
            }
            default: {
                this.fail("Undefined regular expression escape character: " + Parser.charDesc(rr));
            }
        }
    }

    private void parseDoubleQuoteEscape(StringBuilder sb) throws IOException, ControlFlow {
        sb.append('\\');
        int rr = this.peek();
        switch (rr) {
            case 117: {
                this.read();
                sb.append((char)rr);
                for (int i = 0; i < 4; ++i) {
                    rr = this.peek();
                    if (rr >= 48 && rr <= 57 || rr >= 97 && rr <= 102 || rr >= 65 && rr <= 70) {
                        this.read();
                        sb.append((char)rr);
                        continue;
                    }
                    this.fail("Expected four hexadecimal characters in unicode escape - got: " + Parser.charDesc(rr));
                }
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.read();
                sb.append((char)rr);
                if (rr <= 51) {
                    rr = this.peek();
                    if (rr < 48 || rr > 55) break;
                    this.read();
                    sb.append((char)rr);
                    rr = this.peek();
                    if (rr < 48 || rr > 55) break;
                    this.read();
                    sb.append((char)rr);
                    break;
                }
                rr = this.peek();
                if (rr < 48 || rr > 55) break;
                this.read();
                sb.append((char)rr);
                break;
            }
            case 10: 
            case 34: 
            case 37: 
            case 92: 
            case 93: 
            case 98: 
            case 101: 
            case 102: 
            case 110: 
            case 114: 
            case 116: {
                this.read();
                sb.append((char)rr);
                break;
            }
            case 13: {
                this.read();
                sb.append((char)rr);
                rr = this.peek();
                if (rr != 10) break;
                this.read();
                sb.append((char)rr);
                break;
            }
            default: {
                this.fail("Undefined text escape character: " + Parser.charDesc(rr));
            }
        }
    }

    private boolean isUnary(String name) {
        List cc = this.top.currentMessageChain;
        return this.unaryOperators.contains(name) && (cc.isEmpty() || ((Message)cc.get(cc.size() - 1)).name().equals("."));
    }

    private void possibleOperator(String name, String sourcename, int l, int cc) {
        OpEntry op = (OpEntry)this.operators.valueAt(name);
        if (op != null) {
            boolean unary = this.isUnary(name);
            if (!unary) {
                this.top.popOperatorsTo(op.precedence);
                List currentChain = this.top.currentMessageChain;
                MutableMessage result = new MutableMessage(name, null, sourcename, l, cc);
                currentChain.add(result);
                this.top.added();
                this.top.push(op.precedence, result, false);
            } else {
                List currentChain = this.top.currentMessageChain;
                MutableMessage result = new MutableMessage(name, null, sourcename, l, cc);
                currentChain.add(result);
                this.top.added();
                this.top.push(-1, result, true);
            }
        } else {
            OpArity opa = (OpArity)this.assignmentOperators.valueAt(name);
            if (opa != null && this.top.currentMessageChain.size() > 0) {
                if (opa.arity == 2) {
                    this.top.popOperatorsTo(13);
                    List currentChain = this.top.currentMessageChain;
                    Message last = (Message)currentChain.remove(currentChain.size() - 1);
                    MutableMessage result = new MutableMessage(name, null, sourcename, l, cc);
                    currentChain.add(result);
                    this.top.added();
                    this.top.push(13, result, false);
                    result.firstArgument = last;
                } else {
                    List currentChain = this.top.currentMessageChain;
                    Message last = (Message)currentChain.remove(currentChain.size() - 1);
                    currentChain.add(NamedMessage.create(name, new PersistentList(last), null, sourcename, l, cc));
                    this.top.added();
                }
            } else {
                this.top.currentMessageChain.add(NamedMessage.create(name, null, null, sourcename, l, cc));
                this.top.added();
            }
        }
    }

    private void parseOperatorChars(int indicator) throws IOException, ControlFlow {
        int rr;
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        StringBuilder sb = new StringBuilder();
        sb.append((char)indicator);
        block4: while (true) {
            rr = this.peek();
            switch (rr) {
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 42: 
                case 43: 
                case 45: 
                case 58: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 94: 
                case 96: 
                case 124: 
                case 126: {
                    this.read();
                    sb.append((char)rr);
                    continue block4;
                }
                case 47: {
                    if (indicator == 37) break block4;
                    this.read();
                    sb.append((char)rr);
                    continue block4;
                }
            }
            break;
        }
        if (rr == 40) {
            this.read();
            IPersistentList args = this.parseCommaSeparatedMessageChains();
            this.parseCharacter(41);
            this.top.currentMessageChain.add(NamedMessage.create(sb.toString(), args, null, this.sourcename, l, cc));
            this.top.added();
            return;
        }
        this.possibleOperator(sb.toString(), this.sourcename, l, cc);
    }

    private void parseCharacter(int c) throws IOException, ControlFlow {
        this.readWhiteSpace();
        int l = this.lineNumber;
        int cc = this.currentCharacter;
        int rr = this.read();
        if (rr != c) {
            this.fail(l, cc, "Expected: '" + (char)c + "' got: " + Parser.charDesc(rr), "" + (char)c, Parser.charDesc(rr));
        }
    }

    private void parseEmptyMessageSend() throws IOException, ControlFlow {
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        IPersistentList args = this.parseCommaSeparatedMessageChains();
        this.parseCharacter(41);
        this.top.currentMessageChain.add(NamedMessage.create("", args, null, this.sourcename, l, cc));
        this.top.added();
    }

    private void parseOpenCloseMessageSend(char end, String name) throws IOException, ControlFlow {
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        int rr = this.peek();
        int r2 = this.peek2();
        IPersistentList args = null;
        if (rr == end && r2 == 40) {
            this.read();
            this.read();
            args = this.parseCommaSeparatedMessageChains();
            this.parseCharacter(41);
        } else {
            args = this.parseCommaSeparatedMessageChains();
            this.parseCharacter(end);
        }
        this.top.currentMessageChain.add(NamedMessage.create(name, args, null, this.sourcename, l, cc));
        this.top.added();
    }

    private void parseSimpleOpenCloseMessageSend(char end, String name) throws IOException, ControlFlow {
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        this.read();
        IPersistentList args = this.parseCommaSeparatedMessageChains();
        this.parseCharacter(end);
        this.top.currentMessageChain.add(NamedMessage.create(name, args, null, this.sourcename, l, cc));
        this.top.added();
    }

    private int readNumbersInto(StringBuilder sb) throws IOException {
        int rr;
        while ((rr = this.peek()) >= 48 && rr <= 57 || rr == 95) {
            this.read();
            if (rr == 95) continue;
            sb.append((char)rr);
        }
        return rr;
    }

    private boolean parseBaseTen(StringBuilder sb, int indicator) throws IOException, ControlFlow {
        boolean decimal = false;
        int rr = -1;
        if (indicator == 48) {
            rr = this.peek();
            int r2 = this.peek2();
            if (rr == 46 && r2 >= 48 && r2 <= 57) {
                decimal = true;
                sb.append((char)rr);
                sb.append((char)r2);
                this.read();
                this.read();
                rr = this.readNumbersInto(sb);
                if (rr == 101 || rr == 69) {
                    this.read();
                    sb.append((char)rr);
                    rr = this.peek();
                    if (rr == 45 || rr == 43) {
                        this.read();
                        sb.append((char)rr);
                        rr = this.peek();
                    }
                    if (rr >= 48 && rr <= 57) {
                        this.read();
                        sb.append((char)rr);
                        rr = this.readNumbersInto(sb);
                    } else {
                        this.fail("Expected at least one decimal character following exponent specifier in number literal - got: " + Parser.charDesc(rr));
                    }
                }
            }
        } else {
            rr = this.readNumbersInto(sb);
            int r2 = this.peek2();
            if (rr == 46 && r2 >= 48 && r2 <= 57) {
                decimal = true;
                sb.append((char)rr);
                sb.append((char)r2);
                this.read();
                this.read();
                rr = this.readNumbersInto(sb);
                if (rr == 101 || rr == 69) {
                    this.read();
                    sb.append((char)rr);
                    rr = this.peek();
                    if (rr == 45 || rr == 43) {
                        this.read();
                        sb.append((char)rr);
                        rr = this.peek();
                    }
                    if (rr >= 48 && rr <= 57) {
                        this.read();
                        sb.append((char)rr);
                        rr = this.readNumbersInto(sb);
                    } else {
                        this.fail("Expected at least one decimal character following exponent specifier in number literal - got: " + Parser.charDesc(rr));
                    }
                }
            } else if (rr == 101 || rr == 69) {
                decimal = true;
                this.read();
                sb.append((char)rr);
                rr = this.peek();
                if (rr == 45 || rr == 43) {
                    this.read();
                    sb.append((char)rr);
                    rr = this.peek();
                }
                if (rr >= 48 && rr <= 57) {
                    this.read();
                    sb.append((char)rr);
                    rr = this.readNumbersInto(sb);
                } else {
                    this.fail("Expected at least one decimal character following exponent specifier in number literal - got: " + Parser.charDesc(rr));
                }
            }
        }
        return decimal;
    }

    private void parseOtherBase(StringBuilder sb, int radix, String name) throws IOException, ControlFlow {
        boolean[] base = BASES[radix];
        int rr = this.peek();
        if (rr > -1 && rr < 128 && base[rr]) {
            this.read();
            if (rr != 95) {
                sb.append((char)rr);
            }
            while ((rr = this.peek()) > -1 && rr < 128 && base[rr]) {
                this.read();
                if (rr == 95) continue;
                sb.append((char)rr);
            }
        } else {
            this.fail("Expected at least one " + name + " character in " + name + " number literal - got: " + Parser.charDesc(rr));
        }
    }

    private void parseNumber(int indicator) throws IOException, ControlFlow {
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        boolean decimal = false;
        StringBuilder sb = new StringBuilder();
        if (indicator == 45) {
            sb.append((char)indicator);
            indicator = this.read();
        }
        int rr = -1;
        int radix = 10;
        String name = "decimal";
        rr = this.peek();
        if (rr == 35) {
            radix = (char)indicator - 48;
            this.read();
            switch (radix) {
                case 2: {
                    name = "binary";
                    break;
                }
                case 8: {
                    name = "octal";
                    break;
                }
                default: {
                    name = "base " + radix;
                    break;
                }
            }
        } else if (this.isDigit(indicator) && this.isDigit(rr) && this.peek2() == 35) {
            radix = Integer.valueOf(String.valueOf(new char[]{(char)indicator, (char)rr}));
            this.read();
            this.read();
            switch (radix) {
                case 2: {
                    name = "binary";
                    break;
                }
                case 8: {
                    name = "octal";
                    break;
                }
                case 16: {
                    name = "hexadecimal";
                    break;
                }
                default: {
                    name = "base " + radix;
                    break;
                }
            }
        } else if (indicator == 48 && (rr == 120 || rr == 88)) {
            radix = 16;
            this.read();
            name = "hexadecimal";
        } else {
            sb.append((char)indicator);
        }
        if (radix > 36) {
            this.fail("Expected radix between 0 and 36 - got: " + radix);
        }
        if (radix == 10) {
            decimal = this.parseBaseTen(sb, indicator);
        } else {
            decimal = false;
            this.parseOtherBase(sb, radix, name);
        }
        try {
            this.top.currentMessageChain.add(new LiteralMessage(decimal ? new DFloNum(sb.toString()) : IntNum.valueOf(sb.toString(), radix), null, this.sourcename, l, cc));
            this.top.added();
        }
        catch (NumberFormatException e) {
            this.fail(e.getMessage());
            return;
        }
    }

    private boolean isLetter(int c) {
        return c >= 65 && c <= 90 || c == 95 || c >= 97 && c <= 122 || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 8191 || c >= 8704 && c <= 8959 || c >= 10176 && c <= 10223 || c >= 10624 && c <= 11007 || c >= 12352 && c <= 12687 || c >= 13056 && c <= 13183 || c >= 13312 && c <= 15661 || c >= 19968 && c <= 40959 || c >= 63744 && c <= 64255;
    }

    private boolean isIDDigit(int c) {
        return c >= 48 && c <= 57 || c >= 1632 && c <= 1641 || c >= 1776 && c <= 1785 || c >= 2406 && c <= 2415 || c >= 2534 && c <= 2543 || c >= 2662 && c <= 2671 || c >= 2790 && c <= 2799 || c >= 2918 && c <= 2927 || c >= 3047 && c <= 3055 || c >= 3174 && c <= 3183 || c >= 3302 && c <= 3311 || c >= 3430 && c <= 3439 || c >= 3664 && c <= 3673 || c >= 3792 && c <= 3801 || c >= 4160 && c <= 4169;
    }

    private boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private void fail(int l, int c, String message, String expected, String got) throws ControlFlow {
        throw new ControlFlow(new Failure(l, c, expected, got, this.sourcename, message));
    }

    private void fail(String message) throws ControlFlow {
        this.fail(this.lineNumber, this.currentCharacter, message, null, null);
    }

    private static String charDesc(int c) {
        if (c == -1) {
            return "EOF";
        }
        if (c == 9) {
            return "TAB";
        }
        if (c == 10 || c == 13) {
            return "EOL";
        }
        return "'" + (char)c + "'";
    }

    static {
        int i;
        IPersistentMap operators = PersistentArrayMap.EMPTY;
        operators = Parser.addOpEntry("!", 0, operators);
        operators = Parser.addOpEntry("~", 0, operators);
        operators = Parser.addOpEntry("$", 0, operators);
        operators = Parser.addOpEntry("?", 0, operators);
        operators = Parser.addOpEntry("**", 1, operators);
        operators = Parser.addOpEntry("*", 2, operators);
        operators = Parser.addOpEntry("/", 2, operators);
        operators = Parser.addOpEntry("%", 2, operators);
        operators = Parser.addOpEntry("+", 3, operators);
        operators = Parser.addOpEntry("-", 3, operators);
        operators = Parser.addOpEntry("\u222a", 3, operators);
        operators = Parser.addOpEntry("\u2229", 3, operators);
        operators = Parser.addOpEntry("<<", 4, operators);
        operators = Parser.addOpEntry(">>", 4, operators);
        operators = Parser.addOpEntry("<=>", 5, operators);
        operators = Parser.addOpEntry(">", 5, operators);
        operators = Parser.addOpEntry("<", 5, operators);
        operators = Parser.addOpEntry("<=", 5, operators);
        operators = Parser.addOpEntry(">=", 5, operators);
        operators = Parser.addOpEntry("<>", 5, operators);
        operators = Parser.addOpEntry("<>>", 5, operators);
        operators = Parser.addOpEntry("\u2264", 5, operators);
        operators = Parser.addOpEntry("\u2265", 5, operators);
        operators = Parser.addOpEntry("\u2282", 5, operators);
        operators = Parser.addOpEntry("\u2283", 5, operators);
        operators = Parser.addOpEntry("\u2286", 5, operators);
        operators = Parser.addOpEntry("\u2287", 5, operators);
        operators = Parser.addOpEntry("==", 6, operators);
        operators = Parser.addOpEntry("!=", 6, operators);
        operators = Parser.addOpEntry("\u2260", 6, operators);
        operators = Parser.addOpEntry("===", 6, operators);
        operators = Parser.addOpEntry("=~", 6, operators);
        operators = Parser.addOpEntry("!~", 6, operators);
        operators = Parser.addOpEntry("&", 7, operators);
        operators = Parser.addOpEntry("^", 8, operators);
        operators = Parser.addOpEntry("|", 9, operators);
        operators = Parser.addOpEntry("&&", 10, operators);
        operators = Parser.addOpEntry("?&", 10, operators);
        operators = Parser.addOpEntry("||", 11, operators);
        operators = Parser.addOpEntry("?|", 11, operators);
        operators = Parser.addOpEntry("..", 12, operators);
        operators = Parser.addOpEntry("...", 12, operators);
        operators = Parser.addOpEntry("=>", 12, operators);
        operators = Parser.addOpEntry("<->", 12, operators);
        operators = Parser.addOpEntry("->", 12, operators);
        operators = Parser.addOpEntry("\u2218", 12, operators);
        operators = Parser.addOpEntry("+>", 12, operators);
        operators = Parser.addOpEntry("!>", 12, operators);
        operators = Parser.addOpEntry("&>", 12, operators);
        operators = Parser.addOpEntry("%>", 12, operators);
        operators = Parser.addOpEntry("#>", 12, operators);
        operators = Parser.addOpEntry("@>", 12, operators);
        operators = Parser.addOpEntry("/>", 12, operators);
        operators = Parser.addOpEntry("*>", 12, operators);
        operators = Parser.addOpEntry("?>", 12, operators);
        operators = Parser.addOpEntry("|>", 12, operators);
        operators = Parser.addOpEntry("^>", 12, operators);
        operators = Parser.addOpEntry("~>", 12, operators);
        operators = Parser.addOpEntry("->>", 12, operators);
        operators = Parser.addOpEntry("+>>", 12, operators);
        operators = Parser.addOpEntry("!>>", 12, operators);
        operators = Parser.addOpEntry("&>>", 12, operators);
        operators = Parser.addOpEntry("%>>", 12, operators);
        operators = Parser.addOpEntry("#>>", 12, operators);
        operators = Parser.addOpEntry("@>>", 12, operators);
        operators = Parser.addOpEntry("/>>", 12, operators);
        operators = Parser.addOpEntry("*>>", 12, operators);
        operators = Parser.addOpEntry("?>>", 12, operators);
        operators = Parser.addOpEntry("|>>", 12, operators);
        operators = Parser.addOpEntry("^>>", 12, operators);
        operators = Parser.addOpEntry("~>>", 12, operators);
        operators = Parser.addOpEntry("=>>", 12, operators);
        operators = Parser.addOpEntry("**>", 12, operators);
        operators = Parser.addOpEntry("**>>", 12, operators);
        operators = Parser.addOpEntry("&&>", 12, operators);
        operators = Parser.addOpEntry("&&>>", 12, operators);
        operators = Parser.addOpEntry("||>", 12, operators);
        operators = Parser.addOpEntry("||>>", 12, operators);
        operators = Parser.addOpEntry("$>", 12, operators);
        operators = Parser.addOpEntry("$>>", 12, operators);
        operators = Parser.addOpEntry("and", 13, operators);
        operators = Parser.addOpEntry("nand", 13, operators);
        operators = Parser.addOpEntry("or", 13, operators);
        operators = Parser.addOpEntry("xor", 13, operators);
        operators = Parser.addOpEntry("nor", 13, operators);
        operators = Parser.addOpEntry("<-", 14, operators);
        operators = Parser.addOpEntry("return", 14, operators);
        operators = Parser.addOpEntry("import", 14, operators);
        DEFAULT_OPERATORS = operators;
        DEFAULT_UNARY_OPERATORS = (IPersistentSet)PersistentHashSet.EMPTY.cons("-").cons("+").cons("!").cons("~").cons("$");
        IPersistentMap aoperators = PersistentArrayMap.EMPTY;
        aoperators = Parser.addOpArity("=", 2, aoperators);
        aoperators = Parser.addOpArity("+=", 2, aoperators);
        aoperators = Parser.addOpArity("+=", 2, aoperators);
        aoperators = Parser.addOpArity("-=", 2, aoperators);
        aoperators = Parser.addOpArity("**=", 2, aoperators);
        aoperators = Parser.addOpArity("*=", 2, aoperators);
        aoperators = Parser.addOpArity("/=", 2, aoperators);
        aoperators = Parser.addOpArity("%=", 2, aoperators);
        aoperators = Parser.addOpArity("&=", 2, aoperators);
        aoperators = Parser.addOpArity("&&=", 2, aoperators);
        aoperators = Parser.addOpArity("^=", 2, aoperators);
        aoperators = Parser.addOpArity("|=", 2, aoperators);
        aoperators = Parser.addOpArity("||=", 2, aoperators);
        aoperators = Parser.addOpArity("<<=", 2, aoperators);
        aoperators = Parser.addOpArity(">>=", 2, aoperators);
        aoperators = Parser.addOpArity("++", 1, aoperators);
        aoperators = Parser.addOpArity("--", 1, aoperators);
        DEFAULT_ASSIGNMENT_OPERATORS = aoperators;
        RANGES = new String[]{"", ".", "..", "...", "....", ".....", "......", ".......", "........", ".........", "..........", "...........", "............"};
        BASES = new boolean[37][128];
        for (i = 0; i <= 10; ++i) {
            for (int j = 0; j < i; ++j) {
                Parser.BASES[i][48 + j] = true;
            }
            Parser.BASES[i][95] = true;
        }
        for (i = 11; i <= 36; ++i) {
            int j;
            for (j = 0; j < 10; ++j) {
                Parser.BASES[i][48 + j] = true;
            }
            for (j = 10; j < i; ++j) {
                Parser.BASES[i][97 + (i - (j + 1))] = true;
                Parser.BASES[i][65 + (i - (j + 1))] = true;
            }
            Parser.BASES[i][95] = true;
        }
    }

    public static class Failure {
        public final int line;
        public final int character;
        public final String expected;
        public final String got;
        public final String source;
        public final String message;

        public Failure(int l, int c, String e, String g, String s, String m) {
            this.line = l;
            this.character = c;
            this.expected = e;
            this.got = g;
            this.source = s;
            this.message = m;
        }
    }

    private static final class ChainContext {
        public final ChainContext parent;
        private ISeq messageChainStack = PersistentList.EMPTY.cons(null);
        private List<Message> currentMessageChain = null;
        private Level currentLevel = new Level(-1, null, null, false);

        public ChainContext(ChainContext parent) {
            this.parent = parent;
        }

        public void push(List<Message> messageChain) {
            this.messageChainStack = this.messageChainStack.cons(this.currentMessageChain);
            this.currentMessageChain = messageChain;
        }

        public Message pop() {
            Message ret = null;
            ListIterator<Message> i = this.currentMessageChain.listIterator(this.currentMessageChain.size());
            while (i.hasPrevious()) {
                ret = i.previous().withNext(ret);
            }
            if (ret != null) {
                while (ret.name().equals(".") && ret.next() != null) {
                    ret = ret.next();
                }
            }
            this.currentMessageChain = (List)this.messageChainStack.first();
            this.messageChainStack = this.messageChainStack.next();
            return ret;
        }

        public void popOperatorsTo(int precedence) {
            while ((this.currentLevel.precedence != -1 || this.currentLevel.unary) && this.currentLevel.precedence <= precedence) {
                this.currentLevel.operatorMessage.realArguments = this.pop();
                this.currentLevel = this.currentLevel.parent;
            }
        }

        public void push(int precedence, MutableMessage op, boolean unary) {
            this.currentLevel = new Level(precedence, op, this.currentLevel, unary);
            ArrayList<Message> args = new ArrayList<Message>();
            op.arguments = args;
            this.push(args);
        }

        public void added() {
            if (this.currentLevel.unary) {
                this.currentLevel.operatorMessage.realArguments = this.pop();
                this.currentLevel = this.currentLevel.parent;
            }
        }
    }

    private static class Level {
        public final int precedence;
        public final MutableMessage operatorMessage;
        public final Level parent;
        public final boolean unary;

        public Level(int precedence, MutableMessage op, Level parent, boolean unary) {
            this.precedence = precedence;
            this.operatorMessage = op;
            this.parent = parent;
            this.unary = unary;
        }
    }

    public static class OpArity {
        public final String name;
        public final int arity;

        public OpArity(String name, int arity) {
            this.name = name;
            this.arity = arity;
        }
    }

    public static class OpEntry {
        public final String name;
        public final int precedence;

        public OpEntry(String name, int precedence) {
            this.name = name;
            this.precedence = precedence;
        }
    }
}

