/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.interpreter;

import java.lang.invoke.MethodHandle;
import seph.lang.LexicalScope;
import seph.lang.Runtime;
import seph.lang.SThread;
import seph.lang.SephObject;
import seph.lang.ast.Message;
import seph.lang.ast.Terminator;

public class MessageInterpreter {
    private final SephObject ground;
    private final LexicalScope scope;

    public MessageInterpreter(SephObject ground, Runtime runtime) {
        this.ground = ground;
        this.scope = new LexicalScope(this, runtime);
    }

    public MessageInterpreter(SephObject ground, LexicalScope parent, Runtime runtime) {
        this.ground = ground;
        this.scope = new LexicalScope(this, parent, runtime);
    }

    public LexicalScope newScope(SephObject ground) {
        return new MessageInterpreter((SephObject)ground, (LexicalScope)this.scope, (Runtime)this.scope.runtime).scope;
    }

    public Object evaluate(SThread thread, Message msg) {
        SephObject receiver = this.ground;
        SephObject lastReal = Runtime.NIL;
        Message currentMessage = msg;
        boolean first = true;
        try {
            while (currentMessage != null) {
                String name = currentMessage.name();
                Message next = currentMessage.next();
                if (currentMessage instanceof Terminator) {
                    receiver = this.ground;
                    first = true;
                } else {
                    SephObject tmp = currentMessage.sendTo(thread, this.scope, receiver, first);
                    first = false;
                    if (next != null) {
                        while (tmp == SThread.TAIL_MARKER) {
                            MethodHandle tail = thread.tail;
                            thread.tail = null;
                            tmp = tail.invokeExact();
                        }
                    }
                    if (tmp != null) {
                        receiver = lastReal = tmp;
                    }
                }
                currentMessage = next;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return lastReal;
    }

    public Object evaluateFully(SThread thread, Message msg) {
        SephObject receiver = this.ground;
        SephObject lastReal = Runtime.NIL;
        boolean first = true;
        try {
            for (Message currentMessage = msg; currentMessage != null; currentMessage = currentMessage.next()) {
                String name = currentMessage.name();
                if (currentMessage instanceof Terminator) {
                    receiver = this.ground;
                    first = true;
                    continue;
                }
                SephObject tmp = currentMessage.sendTo(thread, this.scope, receiver, first);
                first = false;
                while (tmp == SThread.TAIL_MARKER) {
                    MethodHandle tail = thread.tail;
                    thread.tail = null;
                    tmp = tail.invokeExact();
                }
                if (tmp == null) continue;
                receiver = lastReal = tmp;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return lastReal;
    }
}

