/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.compiler;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import seph.lang.LexicalScope;
import seph.lang.SThread;
import seph.lang.SephObject;
import seph.lang.compiler.Bootstrap;
import seph.lang.persistent.IPersistentList;

public class SephCallSite
extends MutableCallSite {
    int numberOfGuards = 0;
    Morphicity morphicity = Morphicity.NILADIC;
    private static final MethodHandle EQ_SIMPLE = Bootstrap.findStatic(SephCallSite.class, "eq", MethodType.methodType(Boolean.TYPE, Object.class, SephObject.class));
    private static final MethodHandle EQ_SCOPE = Bootstrap.findStatic(SephCallSite.class, "eq", MethodType.methodType(Boolean.TYPE, Object.class, LexicalScope.class, Integer.TYPE, SephObject.class, LexicalScope.class));
    private static final Class[] INDETERMINATE = new Class[]{IPersistentList.class};
    private static final Class[] CLASS_0 = new Class[0];
    private static final Class[] CLASS_1 = new Class[]{MethodHandle.class};
    private static final Class[] CLASS_2 = new Class[]{MethodHandle.class, MethodHandle.class};
    private static final Class[] CLASS_3 = new Class[]{MethodHandle.class, MethodHandle.class, MethodHandle.class};
    private static final Class[] CLASS_4 = new Class[]{MethodHandle.class, MethodHandle.class, MethodHandle.class, MethodHandle.class};
    private static final Class[] CLASS_5 = new Class[]{MethodHandle.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, MethodHandle.class};
    private static final MethodHandle INSTALL_METHOD_HANDLE_ARGS = Bootstrap.findStatic(SephCallSite.class, "installMethodHandle", MethodType.methodType(SephObject.class, MethodHandle.class, SephObject.class, SThread.class, LexicalScope.class, IPersistentList.class));
    private static final MethodHandle INSTALL_METHOD_HANDLE_ARG0 = Bootstrap.findStatic(SephCallSite.class, "installMethodHandle", MethodType.methodType(SephObject.class, MethodHandle.class, SephObject.class, SThread.class, LexicalScope.class));
    private static final MethodHandle INSTALL_METHOD_HANDLE_ARG1 = Bootstrap.findStatic(SephCallSite.class, "installMethodHandle", MethodType.methodType(SephObject.class, MethodHandle.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class));
    private static final MethodHandle INSTALL_METHOD_HANDLE_ARG2 = Bootstrap.findStatic(SephCallSite.class, "installMethodHandle", MethodType.methodType(SephObject.class, MethodHandle.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class, MethodHandle.class));
    private static final MethodHandle INSTALL_METHOD_HANDLE_ARG3 = Bootstrap.findStatic(SephCallSite.class, "installMethodHandle", MethodType.methodType(SephObject.class, MethodHandle.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class, MethodHandle.class, MethodHandle.class));
    private static final MethodHandle INSTALL_METHOD_HANDLE_ARG4 = Bootstrap.findStatic(SephCallSite.class, "installMethodHandle", MethodType.methodType(SephObject.class, MethodHandle.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, MethodHandle.class));
    private static final MethodHandle INSTALL_METHOD_HANDLE_ARG5 = Bootstrap.findStatic(SephCallSite.class, "installMethodHandle", MethodType.methodType(SephObject.class, MethodHandle.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, MethodHandle.class));

    public SephCallSite(MethodType type) {
        super(type);
    }

    private boolean newEntry() {
        ++this.numberOfGuards;
        if (this.numberOfGuards > 10) {
            this.morphicity = Morphicity.MEGAMORPHIC;
            return false;
        }
        this.morphicity = this.numberOfGuards > 1 ? Morphicity.POLYMORPHIC : Morphicity.MONOMORPHIC;
        return true;
    }

    void installActivatableEntry(SephObject receiver, LexicalScope scope, SephObject value, int args) {
        if (this.newEntry()) {
            MethodHandle currentEntry = this.getTarget();
            this.setTarget(MethodHandles.guardWithTest(this.eq(receiver, scope, args), this.invokeActivateWith(value, args), currentEntry));
        }
    }

    void installActivatableEntry(SephObject receiver, LexicalScope scope, MethodHandle value, int args) {
        if (this.newEntry()) {
            MethodHandle currentEntry = this.getTarget();
            this.setTarget(MethodHandles.guardWithTest(this.eq(receiver, scope, args), this.tailInvokeActivateWith(value, args), currentEntry));
        }
    }

    void installConstantEntry(SephObject receiver, LexicalScope scope, SephObject value, int args) {
        if (this.newEntry()) {
            MethodHandle currentEntry = this.getTarget();
            this.setTarget(MethodHandles.guardWithTest(this.eq(receiver, scope, args), this.constantValue(value, args), currentEntry));
        }
    }

    public static boolean eq(Object first, SephObject receiver) {
        return first == receiver.identity();
    }

    public static boolean eq(Object first, LexicalScope firstScope, int scopeVersion, SephObject receiver, LexicalScope scope) {
        return first == receiver.identity() && firstScope == scope && scopeVersion == scope.version();
    }

    private static Class[] dropClasses(int num) {
        switch (num) {
            case -1: {
                return INDETERMINATE;
            }
            case 0: {
                return CLASS_0;
            }
            case 1: {
                return CLASS_1;
            }
            case 2: {
                return CLASS_2;
            }
            case 3: {
                return CLASS_3;
            }
            case 4: {
                return CLASS_4;
            }
            case 5: {
                return CLASS_5;
            }
        }
        return null;
    }

    private MethodHandle eq(SephObject receiver, LexicalScope scope, int args) {
        Class[] argumentsToDrop = SephCallSite.dropClasses(args);
        if (scope == null) {
            return MethodHandles.dropArguments(MethodHandles.dropArguments(EQ_SIMPLE.bindTo(receiver.identity()), 1, new Class[]{SThread.class, LexicalScope.class}), 3, argumentsToDrop);
        }
        return MethodHandles.dropArguments(MethodHandles.dropArguments(MethodHandles.insertArguments(EQ_SCOPE, 0, receiver.identity(), scope, scope.version()), 1, new Class[]{SThread.class}), 3, argumentsToDrop);
    }

    private MethodHandle invokeActivateWith(SephObject value, int args) {
        return SephCallSite.activateWithMH(args).bindTo(value);
    }

    public static SephObject installMethodHandle(MethodHandle mh, SephObject receiver, SThread thread, LexicalScope scope, IPersistentList args) {
        thread.tail = MethodHandles.insertArguments(mh, 0, receiver, thread, scope, args);
        return SThread.TAIL_MARKER;
    }

    public static SephObject installMethodHandle(MethodHandle mh, SephObject receiver, SThread thread, LexicalScope scope) {
        thread.tail = MethodHandles.insertArguments(mh, 0, receiver, thread, scope);
        return SThread.TAIL_MARKER;
    }

    public static SephObject installMethodHandle(MethodHandle mh, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0) {
        thread.tail = MethodHandles.insertArguments(mh, 0, receiver, thread, scope, arg0);
        return SThread.TAIL_MARKER;
    }

    public static SephObject installMethodHandle(MethodHandle mh, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1) {
        thread.tail = MethodHandles.insertArguments(mh, 0, receiver, thread, scope, arg0, arg1);
        return SThread.TAIL_MARKER;
    }

    public static SephObject installMethodHandle(MethodHandle mh, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2) {
        thread.tail = MethodHandles.insertArguments(mh, 0, receiver, thread, scope, arg0, arg1, arg2);
        return SThread.TAIL_MARKER;
    }

    public static SephObject installMethodHandle(MethodHandle mh, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3) {
        thread.tail = MethodHandles.insertArguments(mh, 0, receiver, thread, scope, arg0, arg1, arg2, arg3);
        return SThread.TAIL_MARKER;
    }

    public static SephObject installMethodHandle(MethodHandle mh, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3, MethodHandle arg4) {
        thread.tail = MethodHandles.insertArguments(mh, 0, receiver, thread, scope, arg0, arg1, arg2, arg3, arg4);
        return SThread.TAIL_MARKER;
    }

    private static MethodHandle methodHandleForTail(int num) {
        switch (num) {
            case -1: {
                return INSTALL_METHOD_HANDLE_ARGS;
            }
            case 0: {
                return INSTALL_METHOD_HANDLE_ARG0;
            }
            case 1: {
                return INSTALL_METHOD_HANDLE_ARG1;
            }
            case 2: {
                return INSTALL_METHOD_HANDLE_ARG2;
            }
            case 3: {
                return INSTALL_METHOD_HANDLE_ARG3;
            }
            case 4: {
                return INSTALL_METHOD_HANDLE_ARG4;
            }
            case 5: {
                return INSTALL_METHOD_HANDLE_ARG5;
            }
        }
        return null;
    }

    private static MethodHandle activateWithMH(int num) {
        switch (num) {
            case -1: {
                return Bootstrap.ACTIVATE_WITH_ARGS;
            }
            case 0: {
                return Bootstrap.ACTIVATE_WITH_ARG0;
            }
            case 1: {
                return Bootstrap.ACTIVATE_WITH_ARG1;
            }
            case 2: {
                return Bootstrap.ACTIVATE_WITH_ARG2;
            }
            case 3: {
                return Bootstrap.ACTIVATE_WITH_ARG3;
            }
            case 4: {
                return Bootstrap.ACTIVATE_WITH_ARG4;
            }
            case 5: {
                return Bootstrap.ACTIVATE_WITH_ARG5;
            }
        }
        return null;
    }

    private MethodHandle tailInvokeActivateWith(MethodHandle value, int args) {
        MethodHandle mh = SephCallSite.methodHandleForTail(args);
        return mh.bindTo(value);
    }

    private MethodHandle constantValue(SephObject value, int args) {
        Class[] argumentsToDrop = SephCallSite.dropClasses(args);
        return MethodHandles.dropArguments(MethodHandles.dropArguments(MethodHandles.constant(SephObject.class, value), 0, SephObject.class, SThread.class, LexicalScope.class), 0, argumentsToDrop);
    }

    private static enum Morphicity {
        NILADIC,
        MONOMORPHIC,
        POLYMORPHIC,
        MEGAMORPHIC;

    }
}

