/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.compiler;

import org.objectweb.asm.Label;
import org.objectweb.asm.MethodHandle;
import org.objectweb.asm.MethodVisitor;
import seph.lang.compiler.CompilationHelpers;

public class MethodAdapter {
    private final MethodVisitor mv;
    private NextLoadOperation next = null;
    private static final Object[] EMPTY = new Object[0];

    public MethodAdapter(MethodVisitor mv) {
        this.mv = mv;
        this.mv.visitCode();
    }

    public void load(final String constant) {
        this.op();
        this.next = new NextLoadOperation(){

            @Override
            public void execute() {
                MethodAdapter.this.mv.visitLdcInsn(constant);
            }
        };
    }

    public void loadThis() {
        this.loadLocal(0);
    }

    public void loadLocal(final int index) {
        this.op();
        this.next = new NextLoadOperation(){

            @Override
            public void execute() {
                MethodAdapter.this.mv.visitVarInsn(25, index);
            }
        };
    }

    public void storeLocal(int index) {
        this.op();
        this.mv.visitVarInsn(58, index);
    }

    public void loadLocalInt(final int index) {
        this.op();
        this.next = new NextLoadOperation(){

            @Override
            public void execute() {
                MethodAdapter.this.mv.visitVarInsn(21, index);
            }
        };
    }

    public void nul() {
        this.op();
        this.next = new NextLoadOperation(){

            @Override
            public void execute() {
                MethodAdapter.this.mv.visitInsn(1);
            }
        };
    }

    public void zero() {
        this.op();
        this.next = new NextLoadOperation(){

            @Override
            public void execute() {
                MethodAdapter.this.mv.visitInsn(3);
            }
        };
    }

    public void one() {
        this.op();
        this.next = new NextLoadOperation(){

            @Override
            public void execute() {
                MethodAdapter.this.mv.visitInsn(4);
            }
        };
    }

    public void dup() {
        this.op();
        this.next = new NextLoadOperation(){

            @Override
            public void execute() {
                MethodAdapter.this.mv.visitInsn(89);
            }
        };
    }

    private void op() {
        if (this.next != null) {
            this.next.execute();
            this.next = null;
        }
    }

    public void pop() {
        if (this.next != null) {
            this.next = null;
        } else {
            this.mv.visitInsn(87);
        }
    }

    public void swap() {
        this.op();
        this.mv.visitInsn(95);
    }

    public void ret() {
        this.op();
        this.mv.visitInsn(177);
    }

    public void retValue() {
        this.op();
        this.mv.visitInsn(176);
    }

    public void end() {
        this.op();
        this.mv.visitMaxs(0, 0);
        this.mv.visitEnd();
    }

    public void ifNotEqual(Label l) {
        this.op();
        this.mv.visitJumpInsn(160, l);
    }

    public void ifEqual(Label l) {
        this.op();
        this.mv.visitJumpInsn(159, l);
    }

    public void ifRefNotEqual(Label l) {
        this.op();
        this.mv.visitJumpInsn(166, l);
    }

    public void jump(Label l) {
        this.op();
        this.mv.visitJumpInsn(167, l);
    }

    public void ifNonNull(Label l) {
        this.op();
        this.mv.visitJumpInsn(199, l);
    }

    public void label(Label l) {
        this.op();
        this.mv.visitLabel(l);
    }

    public void create(String name) {
        this.op();
        this.mv.visitTypeInsn(187, name);
    }

    public void getStatic(Class<?> from, String name, Class<?> type) {
        this.getStatic(CompilationHelpers.p(from), name, CompilationHelpers.c(type));
    }

    public void getStatic(Class<?> from, String name, String type) {
        this.getStatic(CompilationHelpers.p(from), name, type);
    }

    public void getStatic(String from, String name, Class<?> type) {
        this.getStatic(from, name, CompilationHelpers.c(type));
    }

    public void getStatic(String from, String name, String type) {
        this.op();
        this.mv.visitFieldInsn(178, from, name, type);
    }

    public void putField(Class<?> fromClass, String name, Class<?> type) {
        this.putField(CompilationHelpers.p(fromClass), name, CompilationHelpers.c(type));
    }

    public void putField(String fromClass, String name, Class<?> type) {
        this.putField(fromClass, name, CompilationHelpers.c(type));
    }

    public void putField(String fromClass, String name, String type) {
        this.op();
        this.mv.visitFieldInsn(181, fromClass, name, type);
    }

    public void getField(Class<?> fromClass, String name, Class<?> type) {
        this.getField(CompilationHelpers.p(fromClass), name, CompilationHelpers.c(type));
    }

    public void getField(String fromClass, String name, Class<?> type) {
        this.getField(fromClass, name, CompilationHelpers.c(type));
    }

    public void getField(String fromClass, String name, String type) {
        this.op();
        this.mv.visitFieldInsn(180, fromClass, name, type);
    }

    public void staticCall(Class<?> on, String name, Class<?> ret, Class<?> ... params) {
        this.staticCall(CompilationHelpers.p(on), name, ret, params);
    }

    public void staticCall(String on, String name, Class<?> ret, Class<?> ... params) {
        this.op();
        this.mv.visitMethodInsn(184, on, name, CompilationHelpers.sig(ret, params));
    }

    public void virtualCall(Class<?> on, String name, Class<?> ret, Class<?> ... params) {
        this.virtualCall(CompilationHelpers.p(on), name, ret, params);
    }

    public void virtualCall(String on, String name, Class<?> ret, Class<?> ... params) {
        this.virtualCall(on, name, CompilationHelpers.sig(ret, params));
    }

    public void virtualCall(String on, String name, String sig) {
        this.op();
        this.mv.visitMethodInsn(182, on, name, sig);
    }

    public void interfaceCall(Class<?> on, String name, Class<?> ret, Class<?> ... params) {
        this.interfaceCall(CompilationHelpers.p(on), name, ret, params);
    }

    public void interfaceCall(String on, String name, Class<?> ret, Class<?> ... params) {
        this.op();
        this.mv.visitMethodInsn(185, on, name, CompilationHelpers.sig(ret, params));
    }

    public void dynamicCall(String name, String sig, MethodHandle bootstrap) {
        this.op();
        this.mv.visitInvokeDynamicInsn(name, sig, bootstrap, EMPTY);
    }

    public void init(Class<?> on, Class<?> ret, Class<?> ... params) {
        this.init(CompilationHelpers.p(on), ret, params);
    }

    public void init(String on, Class<?> ret, Class<?> ... params) {
        this.op();
        this.mv.visitMethodInsn(183, on, "<init>", CompilationHelpers.sig(ret, params));
    }

    private static interface NextLoadOperation {
        public void execute();
    }
}

