/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.compiler;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import seph.lang.LexicalScope;
import seph.lang.Runtime;
import seph.lang.SThread;
import seph.lang.SephObject;
import seph.lang.compiler.CompilationHelpers;
import seph.lang.compiler.SephCallSite;
import seph.lang.persistent.IPersistentList;

public class Bootstrap {
    public static final MethodType BOOTSTRAP_SIGNATURE = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class);
    public static final String BOOTSTRAP_SIGNATURE_DESC = CompilationHelpers.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class);
    public static final MethodType NO_ARGS_SIGNATURE = MethodType.methodType(SephObject.class, SephObject.class, SThread.class, LexicalScope.class);
    public static final MethodType INITIAL_SETUP_TYPE = MethodType.methodType(SephObject.class, SephCallSite.class, MethodHandle.class, MethodHandle.class, SephObject.class, SThread.class, LexicalScope.class);
    public static final MethodType ARGS_3_SIGNATURE = MethodType.methodType(SephObject.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class, MethodHandle.class, MethodHandle.class);
    public static final MethodType INITIAL_SETUP_3_TYPE = MethodType.methodType(SephObject.class, SephCallSite.class, MethodHandle.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class, MethodHandle.class, MethodHandle.class);
    public static final MethodHandle INTRINSIC_TRUE_MH = Bootstrap.findStatic(Bootstrap.class, "intrinsic_true", NO_ARGS_SIGNATURE);
    public static final MethodHandle INITIAL_SETUP_INTRINSIC_TRUE_MH = Bootstrap.findStatic(Bootstrap.class, "initialSetup_intrinsic_true", INITIAL_SETUP_TYPE);
    public static final MethodHandle INTRINSIC_FALSE_MH = Bootstrap.findStatic(Bootstrap.class, "intrinsic_false", NO_ARGS_SIGNATURE);
    public static final MethodHandle INITIAL_SETUP_INTRINSIC_FALSE_MH = Bootstrap.findStatic(Bootstrap.class, "initialSetup_intrinsic_false", INITIAL_SETUP_TYPE);
    public static final MethodHandle INTRINSIC_NIL_MH = Bootstrap.findStatic(Bootstrap.class, "intrinsic_nil", NO_ARGS_SIGNATURE);
    public static final MethodHandle INITIAL_SETUP_INTRINSIC_NIL_MH = Bootstrap.findStatic(Bootstrap.class, "initialSetup_intrinsic_nil", INITIAL_SETUP_TYPE);
    public static final MethodHandle INITIAL_SETUP_INTRINSIC_IF_MH = Bootstrap.findStatic(Bootstrap.class, "initialSetup_intrinsic_if", INITIAL_SETUP_3_TYPE);
    public static final MethodHandle ACTIVATE_WITH_ARGS = Bootstrap.findVirtual(SephObject.class, "activateWith", MethodType.methodType(SephObject.class, SephObject.class, SThread.class, LexicalScope.class, IPersistentList.class));
    public static final MethodHandle ACTIVATE_WITH_ARG0 = Bootstrap.findVirtual(SephObject.class, "activateWith", MethodType.methodType(SephObject.class, SephObject.class, SThread.class, LexicalScope.class));
    public static final MethodHandle ACTIVATE_WITH_ARG1 = Bootstrap.findVirtual(SephObject.class, "activateWith", MethodType.methodType(SephObject.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class));
    public static final MethodHandle ACTIVATE_WITH_ARG2 = Bootstrap.findVirtual(SephObject.class, "activateWith", MethodType.methodType(SephObject.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class, MethodHandle.class));
    public static final MethodHandle ACTIVATE_WITH_ARG3 = Bootstrap.findVirtual(SephObject.class, "activateWith", MethodType.methodType(SephObject.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class, MethodHandle.class, MethodHandle.class));
    public static final MethodHandle ACTIVATE_WITH_ARG4 = Bootstrap.findVirtual(SephObject.class, "activateWith", MethodType.methodType(SephObject.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, MethodHandle.class));
    public static final MethodHandle ACTIVATE_WITH_ARG5 = Bootstrap.findVirtual(SephObject.class, "activateWith", MethodType.methodType(SephObject.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, MethodHandle.class));
    public static final MethodHandle INTRINSIC_IF_MH = Bootstrap.findStatic(Bootstrap.class, "intrinsic_if", ARGS_3_SIGNATURE);

    private static CallSite bootstrap(MethodHandles.Lookup lookup, String name, MethodType type, String bootstrapType) {
        SephCallSite site = new SephCallSite(type);
        MethodType fallbackType = type.insertParameterTypes(0, SephCallSite.class, String.class);
        MethodHandle fallback = MethodHandles.insertArguments(Bootstrap.findStatic(Bootstrap.class, bootstrapType, fallbackType), 0, site, CompilationHelpers.decode(name));
        site.setTarget(fallback);
        return site;
    }

    private static MethodHandle dropAllArgumentTypes(MethodHandle mh, MethodType type) {
        if (type.equals((Object)NO_ARGS_SIGNATURE)) {
            return mh;
        }
        Class<?>[] params = type.parameterArray();
        Class[] newParams = new Class[params.length - 3];
        System.arraycopy(params, 2, newParams, 0, params.length - 3);
        return MethodHandles.dropArguments(mh, 2, newParams);
    }

    private static CallSite bootstrap_intrinsic_true(MethodHandles.Lookup lookup, String name, MethodType type, String bootstrapType) {
        SephCallSite site = new SephCallSite(type);
        MethodType fallbackType = type.insertParameterTypes(0, SephCallSite.class, String.class);
        MethodHandle fallback = MethodHandles.insertArguments(Bootstrap.findStatic(Bootstrap.class, bootstrapType, fallbackType), 0, site, CompilationHelpers.decode(name));
        MethodHandle intrinsicMH = Bootstrap.dropAllArgumentTypes(INTRINSIC_TRUE_MH, type);
        MethodHandle initialSetup = Bootstrap.dropAllArgumentTypes(MethodHandles.insertArguments(INITIAL_SETUP_INTRINSIC_TRUE_MH, 0, site, intrinsicMH, fallback), type);
        site.setTarget(initialSetup);
        return site;
    }

    private static CallSite bootstrap_intrinsic_false(MethodHandles.Lookup lookup, String name, MethodType type, String bootstrapType) {
        SephCallSite site = new SephCallSite(type);
        MethodType fallbackType = type.insertParameterTypes(0, SephCallSite.class, String.class);
        MethodHandle fallback = MethodHandles.insertArguments(Bootstrap.findStatic(Bootstrap.class, bootstrapType, fallbackType), 0, site, CompilationHelpers.decode(name));
        MethodHandle intrinsicMH = Bootstrap.dropAllArgumentTypes(INTRINSIC_FALSE_MH, type);
        MethodHandle initialSetup = Bootstrap.dropAllArgumentTypes(MethodHandles.insertArguments(INITIAL_SETUP_INTRINSIC_FALSE_MH, 0, site, intrinsicMH, fallback), type);
        site.setTarget(initialSetup);
        return site;
    }

    private static CallSite bootstrap_intrinsic_nil(MethodHandles.Lookup lookup, String name, MethodType type, String bootstrapType) {
        SephCallSite site = new SephCallSite(type);
        MethodType fallbackType = type.insertParameterTypes(0, SephCallSite.class, String.class);
        MethodHandle fallback = MethodHandles.insertArguments(Bootstrap.findStatic(Bootstrap.class, bootstrapType, fallbackType), 0, site, CompilationHelpers.decode(name));
        MethodHandle intrinsicMH = Bootstrap.dropAllArgumentTypes(INTRINSIC_NIL_MH, type);
        MethodHandle initialSetup = Bootstrap.dropAllArgumentTypes(MethodHandles.insertArguments(INITIAL_SETUP_INTRINSIC_NIL_MH, 0, site, intrinsicMH, fallback), type);
        site.setTarget(initialSetup);
        return site;
    }

    private static CallSite bootstrap_intrinsic_if(MethodHandles.Lookup lookup, String name, MethodType type, String bootstrapType) {
        SephCallSite site = new SephCallSite(type);
        MethodType fallbackType = type.insertParameterTypes(0, SephCallSite.class, String.class);
        MethodHandle fallback = MethodHandles.insertArguments(Bootstrap.findStatic(Bootstrap.class, bootstrapType, fallbackType), 0, site, CompilationHelpers.decode(name));
        MethodHandle initialSetup = MethodHandles.insertArguments(INITIAL_SETUP_INTRINSIC_IF_MH, 0, site, fallback);
        site.setTarget(initialSetup);
        return site;
    }

    public static CallSite basicSephBootstrap(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap(lookup, name, type, "fallback");
    }

    public static CallSite noReceiverSephBootstrap(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap(lookup, name, type, "noReceiverFallback");
    }

    public static CallSite tailCallSephBootstrap(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap(lookup, name, type, "tailCallFallback");
    }

    public static CallSite noReceiverTailCallSephBootstrap(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap(lookup, name, type, "noReceiverTailCallFallback");
    }

    public static CallSite basicSephBootstrap_intrinsic_true(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap_intrinsic_true(lookup, name, type, "fallback");
    }

    public static CallSite noReceiverSephBootstrap_intrinsic_true(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap_intrinsic_true(lookup, name, type, "noReceiverFallback");
    }

    public static CallSite tailCallSephBootstrap_intrinsic_true(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap_intrinsic_true(lookup, name, type, "tailCallFallback");
    }

    public static CallSite noReceiverTailCallSephBootstrap_intrinsic_true(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap_intrinsic_true(lookup, name, type, "noReceiverTailCallFallback");
    }

    public static CallSite basicSephBootstrap_intrinsic_false(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap_intrinsic_false(lookup, name, type, "fallback");
    }

    public static CallSite noReceiverSephBootstrap_intrinsic_false(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap_intrinsic_false(lookup, name, type, "noReceiverFallback");
    }

    public static CallSite tailCallSephBootstrap_intrinsic_false(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap_intrinsic_false(lookup, name, type, "tailCallFallback");
    }

    public static CallSite noReceiverTailCallSephBootstrap_intrinsic_false(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap_intrinsic_false(lookup, name, type, "noReceiverTailCallFallback");
    }

    public static CallSite basicSephBootstrap_intrinsic_nil(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap_intrinsic_nil(lookup, name, type, "fallback");
    }

    public static CallSite noReceiverSephBootstrap_intrinsic_nil(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap_intrinsic_nil(lookup, name, type, "noReceiverFallback");
    }

    public static CallSite tailCallSephBootstrap_intrinsic_nil(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap_intrinsic_nil(lookup, name, type, "tailCallFallback");
    }

    public static CallSite noReceiverTailCallSephBootstrap_intrinsic_nil(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap_intrinsic_nil(lookup, name, type, "noReceiverTailCallFallback");
    }

    public static CallSite basicSephBootstrap_intrinsic_if(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap_intrinsic_if(lookup, name, type, "fallback");
    }

    public static CallSite noReceiverSephBootstrap_intrinsic_if(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap_intrinsic_if(lookup, name, type, "noReceiverFallback");
    }

    public static CallSite tailCallSephBootstrap_intrinsic_if(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap_intrinsic_if(lookup, name, type, "tailCallFallback");
    }

    public static CallSite noReceiverTailCallSephBootstrap_intrinsic_if(MethodHandles.Lookup lookup, String name, MethodType type) {
        return Bootstrap.bootstrap_intrinsic_if(lookup, name, type, "noReceiverTailCallFallback");
    }

    public static SephObject fallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, IPersistentList args) {
        SephObject value = receiver.get(name);
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            site.installActivatableEntry(receiver, null, value, -1);
            return value.activateWith(receiver, thread, scope, args);
        }
        site.installConstantEntry(receiver, null, value, -1);
        return value;
    }

    public static SephObject fallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope) {
        SephObject value = receiver.get(name);
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            site.installActivatableEntry(receiver, null, value, 0);
            return value.activateWith(receiver, thread, scope);
        }
        site.installConstantEntry(receiver, null, value, 0);
        return value;
    }

    public static SephObject fallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0) {
        SephObject value = receiver.get(name);
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            site.installActivatableEntry(receiver, null, value, 1);
            return value.activateWith(receiver, thread, scope, arg0);
        }
        site.installConstantEntry(receiver, null, value, 1);
        return value;
    }

    public static SephObject fallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1) {
        SephObject value = receiver.get(name);
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            site.installActivatableEntry(receiver, null, value, 2);
            return value.activateWith(receiver, thread, scope, arg0, arg1);
        }
        site.installConstantEntry(receiver, null, value, 2);
        return value;
    }

    public static SephObject fallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2) {
        SephObject value = receiver.get(name);
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            site.installActivatableEntry(receiver, null, value, 3);
            return value.activateWith(receiver, thread, scope, arg0, arg1, arg2);
        }
        site.installConstantEntry(receiver, null, value, 3);
        return value;
    }

    public static SephObject fallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3) {
        SephObject value = receiver.get(name);
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            site.installActivatableEntry(receiver, null, value, 4);
            return value.activateWith(receiver, thread, scope, arg0, arg1, arg2, arg3);
        }
        site.installConstantEntry(receiver, null, value, 4);
        return value;
    }

    public static SephObject fallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3, MethodHandle arg4) {
        SephObject value = receiver.get(name);
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            site.installActivatableEntry(receiver, null, value, 5);
            return value.activateWith(receiver, thread, scope, arg0, arg1, arg2, arg3, arg4);
        }
        site.installConstantEntry(receiver, null, value, 5);
        return value;
    }

    public static SephObject noReceiverFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, IPersistentList args) {
        SephObject value = scope.get(name);
        if (null == value) {
            value = receiver.get(name);
        }
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            site.installActivatableEntry(receiver, scope, value, -1);
            return value.activateWith(receiver, thread, scope, args);
        }
        site.installConstantEntry(receiver, scope, value, -1);
        return value;
    }

    public static SephObject noReceiverFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope) {
        SephObject value = scope.get(name);
        if (null == value) {
            value = receiver.get(name);
        }
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            site.installActivatableEntry(receiver, scope, value, 0);
            return value.activateWith(receiver, thread, scope);
        }
        site.installConstantEntry(receiver, scope, value, 0);
        return value;
    }

    public static SephObject noReceiverFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0) {
        SephObject value = scope.get(name);
        if (null == value) {
            value = receiver.get(name);
        }
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            site.installActivatableEntry(receiver, scope, value, 1);
            return value.activateWith(receiver, thread, scope, arg0);
        }
        site.installConstantEntry(receiver, scope, value, 1);
        return value;
    }

    public static SephObject noReceiverFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1) {
        SephObject value = scope.get(name);
        if (null == value) {
            value = receiver.get(name);
        }
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            site.installActivatableEntry(receiver, scope, value, 2);
            return value.activateWith(receiver, thread, scope, arg0, arg1);
        }
        site.installConstantEntry(receiver, scope, value, 2);
        return value;
    }

    public static SephObject noReceiverFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2) {
        SephObject value = scope.get(name);
        if (null == value) {
            value = receiver.get(name);
        }
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            site.installActivatableEntry(receiver, scope, value, 3);
            return value.activateWith(receiver, thread, scope, arg0, arg1, arg2);
        }
        site.installConstantEntry(receiver, scope, value, 3);
        return value;
    }

    public static SephObject noReceiverFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3) {
        SephObject value = scope.get(name);
        if (null == value) {
            value = receiver.get(name);
        }
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            site.installActivatableEntry(receiver, scope, value, 4);
            return value.activateWith(receiver, thread, scope, arg0, arg1, arg2, arg3);
        }
        site.installConstantEntry(receiver, scope, value, 4);
        return value;
    }

    public static SephObject noReceiverFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3, MethodHandle arg4) {
        SephObject value = scope.get(name);
        if (null == value) {
            value = receiver.get(name);
        }
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            site.installActivatableEntry(receiver, scope, value, 5);
            return value.activateWith(receiver, thread, scope, arg0, arg1, arg2, arg3, arg4);
        }
        site.installConstantEntry(receiver, scope, value, 5);
        return value;
    }

    public static SephObject tailCallFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, IPersistentList args) {
        SephObject value = receiver.get(name);
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            MethodHandle h = ACTIVATE_WITH_ARGS.bindTo(value);
            site.installActivatableEntry(receiver, null, h, -1);
            thread.tail = h = MethodHandles.insertArguments(h, 0, receiver, thread, scope, args);
            return SThread.TAIL_MARKER;
        }
        site.installConstantEntry(receiver, null, value, -1);
        return value;
    }

    public static SephObject tailCallFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope) {
        SephObject value = receiver.get(name);
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            MethodHandle h = ACTIVATE_WITH_ARG0.bindTo(value);
            site.installActivatableEntry(receiver, null, h, 0);
            thread.tail = h = MethodHandles.insertArguments(h, 0, receiver, thread, scope);
            return SThread.TAIL_MARKER;
        }
        site.installConstantEntry(receiver, null, value, 0);
        return value;
    }

    public static SephObject tailCallFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0) {
        SephObject value = receiver.get(name);
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            MethodHandle h = ACTIVATE_WITH_ARG1.bindTo(value);
            site.installActivatableEntry(receiver, null, h, 1);
            thread.tail = h = MethodHandles.insertArguments(h, 0, receiver, thread, scope, arg0);
            return SThread.TAIL_MARKER;
        }
        site.installConstantEntry(receiver, null, value, 1);
        return value;
    }

    public static SephObject tailCallFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1) {
        SephObject value = receiver.get(name);
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            MethodHandle h = ACTIVATE_WITH_ARG2.bindTo(value);
            site.installActivatableEntry(receiver, null, h, 2);
            thread.tail = h = MethodHandles.insertArguments(h, 0, receiver, thread, scope, arg0, arg1);
            return SThread.TAIL_MARKER;
        }
        site.installConstantEntry(receiver, null, value, 2);
        return value;
    }

    public static SephObject tailCallFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2) {
        SephObject value = receiver.get(name);
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            MethodHandle h = ACTIVATE_WITH_ARG3.bindTo(value);
            site.installActivatableEntry(receiver, null, h, 3);
            thread.tail = h = MethodHandles.insertArguments(h, 0, receiver, thread, scope, arg0, arg1, arg2);
            return SThread.TAIL_MARKER;
        }
        site.installConstantEntry(receiver, null, value, 3);
        return value;
    }

    public static SephObject tailCallFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3) {
        SephObject value = receiver.get(name);
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            MethodHandle h = ACTIVATE_WITH_ARG4.bindTo(value);
            site.installActivatableEntry(receiver, null, h, 4);
            thread.tail = h = MethodHandles.insertArguments(h, 0, receiver, thread, scope, arg0, arg1, arg2, arg3);
            return SThread.TAIL_MARKER;
        }
        site.installConstantEntry(receiver, null, value, 4);
        return value;
    }

    public static SephObject tailCallFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3, MethodHandle arg4) {
        SephObject value = receiver.get(name);
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            MethodHandle h = ACTIVATE_WITH_ARG5.bindTo(value);
            site.installActivatableEntry(receiver, null, h, 5);
            thread.tail = h = MethodHandles.insertArguments(h, 0, receiver, thread, scope, arg0, arg1, arg2, arg3, arg4);
            return SThread.TAIL_MARKER;
        }
        site.installConstantEntry(receiver, null, value, 5);
        return value;
    }

    public static SephObject noReceiverTailCallFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, IPersistentList args) {
        SephObject value = scope.get(name);
        if (null == value) {
            value = receiver.get(name);
        }
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            MethodHandle h = ACTIVATE_WITH_ARGS.bindTo(value);
            site.installActivatableEntry(receiver, scope, h, -1);
            thread.tail = h = MethodHandles.insertArguments(h, 0, receiver, thread, scope, args);
            return SThread.TAIL_MARKER;
        }
        site.installConstantEntry(receiver, scope, value, -1);
        return value;
    }

    public static SephObject noReceiverTailCallFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope) {
        SephObject value = scope.get(name);
        if (null == value) {
            value = receiver.get(name);
        }
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            MethodHandle h = ACTIVATE_WITH_ARG0.bindTo(value);
            site.installActivatableEntry(receiver, scope, h, 0);
            thread.tail = h = MethodHandles.insertArguments(h, 0, receiver, thread, scope);
            return SThread.TAIL_MARKER;
        }
        site.installConstantEntry(receiver, scope, value, 0);
        return value;
    }

    public static SephObject noReceiverTailCallFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0) {
        SephObject value = scope.get(name);
        if (null == value) {
            value = receiver.get(name);
        }
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            MethodHandle h = ACTIVATE_WITH_ARG1.bindTo(value);
            site.installActivatableEntry(receiver, scope, h, 1);
            thread.tail = h = MethodHandles.insertArguments(h, 0, receiver, thread, scope, arg0);
            return SThread.TAIL_MARKER;
        }
        site.installConstantEntry(receiver, scope, value, 1);
        return value;
    }

    public static SephObject noReceiverTailCallFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1) {
        SephObject value = scope.get(name);
        if (null == value) {
            value = receiver.get(name);
        }
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            MethodHandle h = ACTIVATE_WITH_ARG2.bindTo(value);
            site.installActivatableEntry(receiver, scope, h, 2);
            thread.tail = h = MethodHandles.insertArguments(h, 0, receiver, thread, scope, arg0, arg1);
            return SThread.TAIL_MARKER;
        }
        site.installConstantEntry(receiver, scope, value, 2);
        return value;
    }

    public static SephObject noReceiverTailCallFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2) {
        SephObject value = scope.get(name);
        if (null == value) {
            value = receiver.get(name);
        }
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            MethodHandle h = ACTIVATE_WITH_ARG3.bindTo(value);
            site.installActivatableEntry(receiver, scope, h, 3);
            thread.tail = h = MethodHandles.insertArguments(h, 0, receiver, thread, scope, arg0, arg1, arg2);
            return SThread.TAIL_MARKER;
        }
        site.installConstantEntry(receiver, scope, value, 3);
        return value;
    }

    public static SephObject noReceiverTailCallFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3) {
        SephObject value = scope.get(name);
        if (null == value) {
            value = receiver.get(name);
        }
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            MethodHandle h = ACTIVATE_WITH_ARG4.bindTo(value);
            site.installActivatableEntry(receiver, scope, h, 4);
            thread.tail = h = MethodHandles.insertArguments(h, 0, receiver, thread, scope, arg0, arg1, arg2, arg3);
            return SThread.TAIL_MARKER;
        }
        site.installConstantEntry(receiver, scope, value, 4);
        return value;
    }

    public static SephObject noReceiverTailCallFallback(SephCallSite site, String name, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3, MethodHandle arg4) {
        SephObject value = scope.get(name);
        if (null == value) {
            value = receiver.get(name);
        }
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + name + " on " + receiver);
        }
        if (value.isActivatable()) {
            MethodHandle h = ACTIVATE_WITH_ARG5.bindTo(value);
            site.installActivatableEntry(receiver, scope, h, 5);
            thread.tail = h = MethodHandles.insertArguments(h, 0, receiver, thread, scope, arg0, arg1, arg2, arg3, arg4);
            return SThread.TAIL_MARKER;
        }
        site.installConstantEntry(receiver, scope, value, 5);
        return value;
    }

    public static SephObject replaceCompletelyImpl(MethodHandle mh, SephCallSite site, SephObject receiver, SThread thread, LexicalScope scope) throws Throwable {
        site.setTarget(mh);
        return mh.invokeExact(receiver, thread, scope);
    }

    public static SephObject replaceCompletely3Impl(MethodHandle mh, SephCallSite site, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2) throws Throwable {
        site.setTarget(mh);
        return mh.invokeExact(receiver, thread, scope, arg0, arg1, arg2);
    }

    public static MethodHandle replaceCompletely(MethodHandle mh, SephCallSite site) {
        return MethodHandles.insertArguments(Bootstrap.findStatic(Bootstrap.class, "replaceCompletelyImpl", MethodType.methodType(SephObject.class, MethodHandle.class, SephCallSite.class, SephObject.class, SThread.class, LexicalScope.class)), 0, mh, site);
    }

    public static MethodHandle replaceCompletely3(MethodHandle mh, SephCallSite site) {
        return MethodHandles.insertArguments(Bootstrap.findStatic(Bootstrap.class, "replaceCompletely3Impl", MethodType.methodType(SephObject.class, MethodHandle.class, SephCallSite.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class, MethodHandle.class, MethodHandle.class)), 0, mh, site);
    }

    public static SephObject initialSetup_intrinsic_true(SephCallSite site, MethodHandle fast, MethodHandle slow, SephObject receiver, SThread thread, LexicalScope scope) throws Throwable {
        MethodHandle guarded = thread.runtime.INTRINSIC_TRUE_SP.guardWithTest(fast, Bootstrap.replaceCompletely(slow, site));
        site.setTarget(guarded);
        return guarded.invokeExact(receiver, thread, scope);
    }

    public static SephObject intrinsic_true(SephObject receiver, SThread thread, LexicalScope scope) {
        return Runtime.TRUE;
    }

    public static SephObject initialSetup_intrinsic_false(SephCallSite site, MethodHandle fast, MethodHandle slow, SephObject receiver, SThread thread, LexicalScope scope) throws Throwable {
        MethodHandle guarded = thread.runtime.INTRINSIC_FALSE_SP.guardWithTest(fast, Bootstrap.replaceCompletely(slow, site));
        site.setTarget(guarded);
        return guarded.invokeExact(receiver, thread, scope);
    }

    public static SephObject intrinsic_false(SephObject receiver, SThread thread, LexicalScope scope) {
        return Runtime.FALSE;
    }

    public static SephObject initialSetup_intrinsic_nil(SephCallSite site, MethodHandle fast, MethodHandle slow, SephObject receiver, SThread thread, LexicalScope scope) throws Throwable {
        MethodHandle guarded = thread.runtime.INTRINSIC_NIL_SP.guardWithTest(fast, Bootstrap.replaceCompletely(slow, site));
        site.setTarget(guarded);
        return guarded.invokeExact(receiver, thread, scope);
    }

    public static SephObject intrinsic_nil(SephObject receiver, SThread thread, LexicalScope scope) {
        return Runtime.NIL;
    }

    public static SephObject intrinsic_if(SephObject receiver, SThread thread, LexicalScope scope, MethodHandle test, MethodHandle then, MethodHandle _else) throws Throwable {
        if (test.invokeExact(thread, scope, true, true).isTrue()) {
            return then.invokeExact(thread, scope, true, false);
        }
        return _else.invokeExact(thread, scope, true, false);
    }

    public static SephObject initialSetup_intrinsic_if(SephCallSite site, MethodHandle slow, SephObject receiver, SThread thread, LexicalScope scope, MethodHandle test, MethodHandle then, MethodHandle _else) throws Throwable {
        MethodHandle guarded = thread.runtime.INTRINSIC_IF_SP.guardWithTest(INTRINSIC_IF_MH, Bootstrap.replaceCompletely3(slow, site));
        site.setTarget(guarded);
        return guarded.invokeExact(receiver, thread, scope, test, then, _else);
    }

    public static MethodHandle findStatic(Class target, String name, MethodType type) {
        try {
            return MethodHandles.lookup().findStatic(target, name, type);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static MethodHandle findVirtual(Class target, String name, MethodType type) {
        try {
            return MethodHandles.lookup().findVirtual(target, name, type);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

