/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.ast;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import seph.lang.LexicalScope;
import seph.lang.SThread;
import seph.lang.SephObject;
import seph.lang.ast.Abstraction;
import seph.lang.ast.Assignment;
import seph.lang.ast.Message;
import seph.lang.ast.Terminator;
import seph.lang.compiler.Bootstrap;
import seph.lang.parser.Parser;
import seph.lang.persistent.IPersistentList;
import seph.lang.persistent.ISeq;
import seph.lang.persistent.PersistentList;

public class NamedMessage
implements Message,
SephObject {
    private final String name;
    private final IPersistentList arguments;
    private final Message next;
    private final String filename;
    private final int line;
    private final int position;
    static final IPersistentList NO_ARGUMENTS = PersistentList.EMPTY;
    private static MethodHandle GO = Bootstrap.findVirtual(NamedMessage.class, "go", MethodType.methodType(SephObject.class, SThread.class, LexicalScope.class, SephObject.class, Boolean.TYPE));

    public static final NamedMessage create(String name, IPersistentList arguments, Message next, String filename, int line, int position) {
        if (name == null) {
            return new NamedMessage(null, arguments, next, filename, line, position);
        }
        if (name.equals(".")) {
            return new Terminator(name, arguments, next, filename, line, position);
        }
        if (Parser.DEFAULT_ASSIGNMENT_OPERATORS.containsKey(name)) {
            return new Assignment(name, arguments, next, filename, line, position);
        }
        if (name.equals("#")) {
            return new Abstraction(name, arguments, next, filename, line, position);
        }
        return new NamedMessage(name, arguments, next, filename, line, position);
    }

    NamedMessage(String name, IPersistentList arguments, Message next, String filename, int line, int position) {
        this.name = name == null ? null : name.intern();
        this.arguments = arguments == null ? NO_ARGUMENTS : arguments;
        this.next = next;
        this.filename = filename;
        this.line = line;
        this.position = position;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public IPersistentList arguments() {
        return this.arguments;
    }

    @Override
    public Message next() {
        return this.next;
    }

    @Override
    public Message withNext(Message newNext) {
        return NamedMessage.create(this.name, this.arguments, newNext, this.filename, this.line, this.position);
    }

    @Override
    public Message withArguments(IPersistentList args) {
        return NamedMessage.create(this.name, args, this.next, this.filename, this.line, this.position);
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public SephObject literal() {
        return null;
    }

    @Override
    public String filename() {
        return this.filename;
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public int position() {
        return this.position;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.arguments.seq() != null) {
            sb.append("(");
            String sep = "";
            for (ISeq seq = this.arguments.seq(); seq != null; seq = seq.next()) {
                sb.append(sep).append(seq.first());
                sep = ", ";
            }
            sb.append(")");
        }
        if (this.next != null) {
            sb.append(" ").append(this.next);
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        boolean ret;
        boolean bl = ret = this == other;
        if (!ret && other != null && other instanceof NamedMessage) {
            NamedMessage lm = (NamedMessage)other;
            ret = (this.name == null ? lm.name == null : this.name.equals(lm.name)) && (this.arguments == null ? lm.arguments == null : this.arguments.equals(lm.arguments)) && (this.next == null ? lm.next == null : this.next.equals(lm.next));
        }
        return ret;
    }

    @Override
    public SephObject sendTo(SThread thread, LexicalScope scope, SephObject receiver, boolean first) {
        if (this.next == null) {
            thread.tail = MethodHandles.insertArguments(GO, 0, this, thread, scope, receiver, first);
            return SThread.TAIL_MARKER;
        }
        return this.go(thread, scope, receiver, first);
    }

    @Override
    public SephObject go(SThread thread, LexicalScope scope, SephObject receiver, boolean first) {
        SephObject value = null;
        if (first) {
            value = scope.get(this.name);
        }
        if (null == value) {
            value = receiver.get(this.name);
        }
        if (null == value) {
            throw new RuntimeException(" *** couldn't find: " + this.name + " on " + receiver);
        }
        if (value.isActivatable()) {
            return value.activateWith(receiver, thread, scope, this.arguments);
        }
        return value;
    }

    @Override
    public SephObject get(String cellName) {
        return null;
    }

    @Override
    public boolean isActivatable() {
        return false;
    }

    @Override
    public boolean isTrue() {
        return true;
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, IPersistentList arguments) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, SephObject arg0) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, SephObject arg0, SephObject arg1) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, SephObject arg0, SephObject arg1, SephObject arg2) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, SephObject arg0, SephObject arg1, SephObject arg2, SephObject arg3) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, SephObject arg0, SephObject arg1, SephObject arg2, SephObject arg3, SephObject arg4) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3, MethodHandle arg4) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public Object identity() {
        return this;
    }
}

