/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.ast;

import seph.lang.LexicalScope;
import seph.lang.SThread;
import seph.lang.SephObject;
import seph.lang.ast.Message;
import seph.lang.ast.NamedMessage;
import seph.lang.persistent.IPersistentList;
import seph.lang.persistent.PersistentList;

public final class Assignment
extends NamedMessage {
    private ActualAssignment assgn;

    public Assignment(String name, IPersistentList arguments, Message next, String filename, int line, int position) {
        super(name, arguments, next, filename, line, position);
        this.assgn = name.equals("=") ? ActualAssignment.EQ : (name.equals("+=") ? ActualAssignment.PLUS_EQ : null);
    }

    @Override
    public SephObject sendTo(SThread thread, LexicalScope scope, SephObject receiver, boolean first) {
        Message left = (Message)this.arguments().seq().first();
        Message right = (Message)this.arguments().seq().next().first();
        return this.assgn.assignOp(thread, left, right, scope);
    }

    private static enum ActualAssignment {
        EQ{

            @Override
            public SephObject assignOp(SThread thread, Message left, Message right, LexicalScope scope) {
                SephObject value = scope.evaluateFully(thread, right);
                scope.assign(left.name(), value);
                return value;
            }
        }
        ,
        PLUS_EQ{

            @Override
            public SephObject assignOp(SThread thread, Message left, Message right, LexicalScope scope) {
                SephObject leftValue = scope.evaluateFully(thread, left);
                SephObject value = NamedMessage.create("+", new PersistentList(right), null, left.filename(), left.line(), left.position()).go(thread, scope, leftValue, false);
                scope.assign(left.name(), value);
                return value;
            }
        };


        public abstract SephObject assignOp(SThread var1, Message var2, Message var3, LexicalScope var4);
    }
}

