/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.anno;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.DeclarationVisitors;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import seph.lang.SephCell;
import seph.lang.SephKind;
import seph.lang.SephMethod;
import seph.lang.SephSingleton;

public class AnnotationBimCreator
implements AnnotationProcessorFactory {
    private static final Collection<String> supportedAnnotations = Collections.unmodifiableCollection(Arrays.asList("seph.lang.SephMethod", "seph.lang.SephCell", "seph.lang.SephSingleton", "seph.lang.SephKind"));
    private static final Collection<String> supportedOptions = Collections.emptySet();

    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotations;
    }

    public Collection<String> supportedOptions() {
        return supportedOptions;
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        return new AnnotationBimCreatorProcessor(env);
    }

    private static class AnnotationBimCreatorProcessor
    implements AnnotationProcessor {
        private final AnnotationProcessorEnvironment env;

        AnnotationBimCreatorProcessor(AnnotationProcessorEnvironment env) {
            this.env = env;
        }

        public void process() {
            for (TypeDeclaration typeDecl : this.env.getSpecifiedTypeDeclarations()) {
                typeDecl.accept(DeclarationVisitors.getDeclarationScanner((DeclarationVisitor)new SephClassVisitor(), (DeclarationVisitor)DeclarationVisitors.NO_OP));
            }
        }

        private class SephClassVisitor
        extends SimpleDeclarationVisitor {
            private PrintStream out;
            private static final boolean DEBUG = false;

            private SephClassVisitor() {
            }

            public void visitClassDeclaration(ClassDeclaration cd) {
                try {
                    SephSingleton ss = (SephSingleton)cd.getAnnotation(SephSingleton.class);
                    SephKind sk = (SephKind)cd.getAnnotation(SephKind.class);
                    if (ss == null && sk == null) {
                        return;
                    }
                    boolean kind = sk != null;
                    String[] parents = ss != null ? ss.parents() : sk.parents();
                    LinkedHashMap<String, MethodDeclaration> methods = new LinkedHashMap<String, MethodDeclaration>();
                    for (MethodDeclaration md : cd.getMethods()) {
                        SephMethod anno = (SephMethod)md.getAnnotation(SephMethod.class);
                        if (anno == null) continue;
                        String string = md.getSimpleName();
                        methods.put(string, md);
                    }
                    LinkedHashMap<String, FieldDeclaration> fields = new LinkedHashMap<String, FieldDeclaration>();
                    for (FieldDeclaration fd : cd.getFields()) {
                        SephCell sephCell = (SephCell)fd.getAnnotation(SephCell.class);
                        if (sephCell == null) continue;
                        String name = fd.getSimpleName();
                        fields.put(name, fd);
                    }
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream(1024);
                    this.out = new PrintStream(bytes);
                    this.out.println("/* THIS FILE IS GENERATED. DO NOT EDIT */");
                    this.out.println("package seph.lang.bim;");
                    this.out.println();
                    this.out.println("import java.lang.invoke.*;");
                    this.out.println("import seph.lang.*;");
                    this.out.println("import seph.lang.persistent.*;");
                    this.out.println();
                    this.out.println("public class " + cd.getSimpleName() + "Base {");
                    this.out.println("    private final static MethodType ACTIVATE_METHOD_TYPE    = MethodType.methodType(SephObject.class, SThread.class, LexicalScope.class, SephObject.class, IPersistentList.class);");
                    this.out.println("    private final static MethodType ACTIVATE_METHOD_TYPE_0  = MethodType.methodType(SephObject.class, SThread.class, LexicalScope.class, SephObject.class);");
                    this.out.println("    private final static MethodType ACTIVATE_METHOD_TYPE_1S = MethodType.methodType(SephObject.class, SThread.class, LexicalScope.class, SephObject.class, SephObject.class);");
                    this.out.println("    private final static MethodType ACTIVATE_METHOD_TYPE_2S = MethodType.methodType(SephObject.class, SThread.class, LexicalScope.class, SephObject.class, SephObject.class, SephObject.class);");
                    this.out.println("    private final static MethodType ACTIVATE_METHOD_TYPE_3S = MethodType.methodType(SephObject.class, SThread.class, LexicalScope.class, SephObject.class, SephObject.class, SephObject.class, SephObject.class);");
                    this.out.println("    private final static MethodType ACTIVATE_METHOD_TYPE_4S = MethodType.methodType(SephObject.class, SThread.class, LexicalScope.class, SephObject.class, SephObject.class, SephObject.class, SephObject.class, SephObject.class);");
                    this.out.println("    private final static MethodType ACTIVATE_METHOD_TYPE_5S = MethodType.methodType(SephObject.class, SThread.class, LexicalScope.class, SephObject.class, SephObject.class, SephObject.class, SephObject.class, SephObject.class, SephObject.class);");
                    this.out.println("    private final static MethodType ACTIVATE_METHOD_TYPE_1M = MethodType.methodType(SephObject.class, SThread.class, LexicalScope.class, SephObject.class, MethodHandle.class);");
                    this.out.println("    private final static MethodType ACTIVATE_METHOD_TYPE_2M = MethodType.methodType(SephObject.class, SThread.class, LexicalScope.class, SephObject.class, MethodHandle.class, MethodHandle.class);");
                    this.out.println("    private final static MethodType ACTIVATE_METHOD_TYPE_3M = MethodType.methodType(SephObject.class, SThread.class, LexicalScope.class, SephObject.class, MethodHandle.class, MethodHandle.class, MethodHandle.class);");
                    this.out.println("    private final static MethodType ACTIVATE_METHOD_TYPE_4M = MethodType.methodType(SephObject.class, SThread.class, LexicalScope.class, SephObject.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, MethodHandle.class);");
                    this.out.println("    private final static MethodType ACTIVATE_METHOD_TYPE_5M = MethodType.methodType(SephObject.class, SThread.class, LexicalScope.class, SephObject.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, MethodHandle.class);");
                    this.out.println("    private static SephMethodHandleObject getSephMethodHandleObject(String name) {");
                    this.out.println("        try {");
                    this.out.println("            MethodHandles.Lookup l = MethodHandles.lookup();");
                    this.out.println("            return new SephMethodHandleObject(");
                    this.out.println("                             l.findStatic(" + cd.getSimpleName() + "Base.class, name, ACTIVATE_METHOD_TYPE),");
                    this.out.println("                             l.findStatic(" + cd.getSimpleName() + "Base.class, name, ACTIVATE_METHOD_TYPE_0),");
                    this.out.println("                             l.findStatic(" + cd.getSimpleName() + "Base.class, name, ACTIVATE_METHOD_TYPE_1S),");
                    this.out.println("                             l.findStatic(" + cd.getSimpleName() + "Base.class, name, ACTIVATE_METHOD_TYPE_2S),");
                    this.out.println("                             l.findStatic(" + cd.getSimpleName() + "Base.class, name, ACTIVATE_METHOD_TYPE_3S),");
                    this.out.println("                             l.findStatic(" + cd.getSimpleName() + "Base.class, name, ACTIVATE_METHOD_TYPE_4S),");
                    this.out.println("                             l.findStatic(" + cd.getSimpleName() + "Base.class, name, ACTIVATE_METHOD_TYPE_5S),");
                    this.out.println("                             l.findStatic(" + cd.getSimpleName() + "Base.class, name, ACTIVATE_METHOD_TYPE_1M),");
                    this.out.println("                             l.findStatic(" + cd.getSimpleName() + "Base.class, name, ACTIVATE_METHOD_TYPE_2M),");
                    this.out.println("                             l.findStatic(" + cd.getSimpleName() + "Base.class, name, ACTIVATE_METHOD_TYPE_3M),");
                    this.out.println("                             l.findStatic(" + cd.getSimpleName() + "Base.class, name, ACTIVATE_METHOD_TYPE_4M),");
                    this.out.println("                             l.findStatic(" + cd.getSimpleName() + "Base.class, name, ACTIVATE_METHOD_TYPE_5M));");
                    this.out.println("        } catch(Throwable e) {");
                    this.out.println("            e.printStackTrace();");
                    this.out.println("            throw new RuntimeException(e);");
                    this.out.println("        }");
                    this.out.println("    }");
                    this.out.println("    private static SephObject invoke(MethodHandle mh, SThread thread, LexicalScope scope) {");
                    this.out.println("        try {");
                    this.out.println("            return (SephObject)mh.invokeExact(thread, scope, true, true);");
                    this.out.println("        } catch(Throwable e) {");
                    this.out.println("            e.printStackTrace();");
                    this.out.println("            throw new RuntimeException(e);");
                    this.out.println("        }");
                    this.out.println("    }");
                    this.out.println();
                    for (String parent : parents) {
                        this.out.println("    public final static SephObject parent_" + parent + " = " + parent + ".instance;");
                    }
                    this.out.println();
                    for (String string : methods.keySet()) {
                        this.out.println("    public final static SephObject cell_" + string + " = getSephMethodHandleObject(\"" + string + "\");");
                    }
                    this.out.println();
                    for (String string : fields.keySet()) {
                        this.out.println("    public final static SephObject cell_" + string + " = " + string + ".instance;");
                    }
                    this.out.println();
                    this.out.println("    public final static Object IDENTITY = new Object();");
                    this.out.println();
                    this.out.println("    public static SephObject get(String name) {");
                    this.out.println("        name = name.intern();");
                    for (Map.Entry entry : methods.entrySet()) {
                        String name = (String)entry.getKey();
                        SephMethod anno = (SephMethod)((MethodDeclaration)entry.getValue()).getAnnotation(SephMethod.class);
                        if (anno.name().length > 0) {
                            name = anno.name()[0];
                        }
                        this.out.println("        if(name == \"" + name + "\") return cell_" + (String)entry.getKey() + ";");
                    }
                    for (Map.Entry entry : fields.entrySet()) {
                        SephCell c = (SephCell)((FieldDeclaration)entry.getValue()).getAnnotation(SephCell.class);
                        String realName = (String)entry.getKey();
                        String cell = c.name().length > 0 ? c.name()[0] : realName;
                        this.out.println("        if(name == \"" + cell + "\") return cell_" + realName + ";");
                    }
                    this.out.println();
                    this.out.println("        SephObject result;");
                    for (String parent : parents) {
                        this.out.println("        if((result = parent_" + parent + ".get(name)) != null) return result;");
                    }
                    this.out.println("        return null;");
                    this.out.println("    }");
                    this.out.println();
                    for (Map.Entry entry : methods.entrySet()) {
                        this.generateMethod(cd, (String)entry.getKey(), (MethodDeclaration)entry.getValue());
                    }
                    this.out.println();
                    this.out.println("}");
                    this.out.close();
                    this.out = null;
                    FileOutputStream fos = new FileOutputStream("src/gen/seph/lang/bim/" + cd.getSimpleName() + "Base.java");
                    fos.write(bytes.toByteArray());
                    fos.close();
                }
                catch (IOException ioe) {
                    System.err.println("Failed to generate:");
                    ioe.printStackTrace();
                    System.exit(1);
                }
            }

            private int generateRegularArgumentEvaluation(MethodDeclaration md, StringBuilder sb) throws IOException {
                boolean hasRestKeywords = false;
                boolean hasRestPositional = false;
                int positionalArity = 0;
                boolean hasReceiver = false;
                String sep = "";
                for (ParameterDeclaration pd : md.getParameters()) {
                    sb.append(sep);
                    String tname = pd.getType().toString();
                    if (tname.equals("seph.lang.LexicalScope")) {
                        sb.append("scope");
                    } else if (tname.equals("seph.lang.SephObject")) {
                        if (!hasReceiver) {
                            sb.append("receiver");
                            hasReceiver = true;
                        } else {
                            sb.append("args.arg" + positionalArity);
                            ++positionalArity;
                        }
                    } else if (tname.equals("seph.lang.SThread")) {
                        sb.append("thread");
                    } else if (tname.equals("seph.lang.persistent.IPersistentMap")) {
                        sb.append("args.restKeywords");
                        hasRestKeywords = true;
                    } else if (tname.equals("seph.lang.persistent.IPersistentList")) {
                        sb.append("args.restPositional");
                        hasRestPositional = true;
                    }
                    sep = ", ";
                }
                if (positionalArity > 5) {
                    throw new RuntimeException("Built in functions can't take more than five positional arguments. Use a rest argument instead (for " + md + ")");
                }
                this.out.println("        SephMethodObject.ArgumentResult args = SephMethodObject.parseAndEvaluateArguments(thread, scope, arguments, " + positionalArity + ", " + hasRestPositional + ", " + hasRestKeywords + ");");
                return positionalArity;
            }

            private int generateUnevaluatedArguments(MethodDeclaration md, StringBuilder sb) throws IOException {
                boolean hasReceiver = false;
                int positionalArity = 0;
                String sep = "";
                for (ParameterDeclaration pd : md.getParameters()) {
                    sb.append(sep);
                    String tname = pd.getType().toString();
                    if (tname.equals("seph.lang.LexicalScope")) {
                        sb.append("scope");
                    } else if (tname.equals("seph.lang.SephObject")) {
                        sb.append("receiver");
                    } else if (tname.equals("seph.lang.SThread")) {
                        sb.append("thread");
                    } else if (tname.equals("seph.lang.persistent.IPersistentList")) {
                        sb.append("arguments");
                    } else if (tname.equals("java.lang.invoke.MethodHandle")) {
                        sb.append("args.argMH" + positionalArity);
                        ++positionalArity;
                    }
                    sep = ", ";
                }
                if (positionalArity > 5) {
                    throw new RuntimeException("Built in functions can't take more than five positional arguments. Use a rest argument instead (for " + md + ")");
                }
                this.out.println("        SephMethodObject.ArgumentResult args = SephMethodObject.parseAndEvaluateArgumentsUneval(thread, scope, arguments, " + positionalArity + ");");
                return positionalArity;
            }

            private void generateForArity(int arity, int currentArity, MethodDeclaration md, ClassDeclaration cd, boolean eval) throws IOException {
                if (!eval) {
                    this.out.println("        throw new RuntimeException(\"Expected unevaluated arguments but got evaluated arguments. This is most likely a compiler bug\");");
                } else if (arity == currentArity) {
                    int args = 0;
                    StringBuilder sb = new StringBuilder();
                    String sep = "";
                    boolean haveReceiver = false;
                    for (ParameterDeclaration pd : md.getParameters()) {
                        sb.append(sep);
                        String tname = pd.getType().toString();
                        if (tname.equals("seph.lang.LexicalScope")) {
                            sb.append("scope");
                        } else if (tname.equals("seph.lang.SephObject")) {
                            if (haveReceiver) {
                                sb.append("arg" + args++);
                            } else {
                                haveReceiver = true;
                                sb.append("receiver");
                            }
                        } else if (tname.equals("seph.lang.SThread")) {
                            sb.append("thread");
                        } else {
                            this.out.println("        throw new RuntimeException(\"Unexpected argument type: " + tname + ". This is most likely a compiler bug\");");
                            return;
                        }
                        sep = ", ";
                    }
                    this.out.println("        return " + cd.getQualifiedName() + "." + md.getSimpleName() + "(" + sb + ");");
                } else {
                    this.out.println("        throw new RuntimeException(\"Expected " + arity + " arguments, got " + currentArity + "\");");
                }
            }

            private void generateForArityMH(int arity, int currentArity, MethodDeclaration md, ClassDeclaration cd, boolean eval) throws IOException {
                if (arity == currentArity) {
                    int args = 0;
                    StringBuilder sb = new StringBuilder();
                    String sep = "";
                    boolean haveReceiver = false;
                    for (ParameterDeclaration pd : md.getParameters()) {
                        sb.append(sep);
                        String tname = pd.getType().toString();
                        if (tname.equals("seph.lang.LexicalScope")) {
                            sb.append("scope");
                        } else if (tname.equals("seph.lang.SephObject")) {
                            if (haveReceiver) {
                                sb.append("invoke(arg" + args++).append(", thread, scope)");
                            } else {
                                haveReceiver = true;
                                sb.append("receiver");
                            }
                        } else if (tname.equals("java.lang.invoke.MethodHandle")) {
                            sb.append("arg" + args++);
                        } else if (tname.equals("seph.lang.SThread")) {
                            sb.append("thread");
                        } else {
                            this.out.println("        throw new RuntimeException(\"Unexpected argument type: " + tname + ". This is most likely a compiler bug\");");
                            return;
                        }
                        sep = ", ";
                    }
                    this.out.println("        return " + cd.getQualifiedName() + "." + md.getSimpleName() + "(" + sb + ");");
                } else {
                    this.out.println("        throw new RuntimeException(\"Expected " + arity + " arguments, got " + currentArity + "\");");
                }
            }

            private void generateMethod(ClassDeclaration cd, String name, MethodDeclaration md) throws IOException {
                this.out.println("    public static SephObject " + name + "(SThread thread, LexicalScope scope, SephObject receiver, IPersistentList arguments) {");
                SephMethod sm = (SephMethod)md.getAnnotation(SephMethod.class);
                StringBuilder sb = new StringBuilder();
                boolean eval = true;
                int arity = -1;
                if (sm.evaluateArguments()) {
                    arity = this.generateRegularArgumentEvaluation(md, sb);
                } else {
                    arity = this.generateUnevaluatedArguments(md, sb);
                    eval = false;
                }
                this.out.println("        return " + cd.getQualifiedName() + "." + md.getSimpleName() + "(" + sb + ");");
                this.out.println("    }");
                this.out.println();
                this.out.println("    public static SephObject " + name + "(SThread thread, LexicalScope scope, SephObject receiver) {");
                this.generateForArity(arity, 0, md, cd, eval);
                this.out.println("    }");
                this.out.println("    public static SephObject " + name + "(SThread thread, LexicalScope scope, SephObject receiver, SephObject arg0) {");
                this.generateForArity(arity, 1, md, cd, eval);
                this.out.println("    }");
                this.out.println("    public static SephObject " + name + "(SThread thread, LexicalScope scope, SephObject receiver, SephObject arg0, SephObject arg1) {");
                this.generateForArity(arity, 2, md, cd, eval);
                this.out.println("    }");
                this.out.println("    public static SephObject " + name + "(SThread thread, LexicalScope scope, SephObject receiver, SephObject arg0, SephObject arg1, SephObject arg2) {");
                this.generateForArity(arity, 3, md, cd, eval);
                this.out.println("    }");
                this.out.println("    public static SephObject " + name + "(SThread thread, LexicalScope scope, SephObject receiver, SephObject arg0, SephObject arg1, SephObject arg2, SephObject arg3) {");
                this.generateForArity(arity, 4, md, cd, eval);
                this.out.println("    }");
                this.out.println("    public static SephObject " + name + "(SThread thread, LexicalScope scope, SephObject receiver, SephObject arg0, SephObject arg1, SephObject arg2, SephObject arg3, SephObject arg4) {");
                this.generateForArity(arity, 5, md, cd, eval);
                this.out.println("    }");
                this.out.println("    public static SephObject " + name + "(SThread thread, LexicalScope scope, SephObject receiver, MethodHandle arg0) {");
                this.generateForArityMH(arity, 1, md, cd, eval);
                this.out.println("    }");
                this.out.println("    public static SephObject " + name + "(SThread thread, LexicalScope scope, SephObject receiver, MethodHandle arg0, MethodHandle arg1) {");
                this.generateForArityMH(arity, 2, md, cd, eval);
                this.out.println("    }");
                this.out.println("    public static SephObject " + name + "(SThread thread, LexicalScope scope, SephObject receiver, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2) {");
                this.generateForArityMH(arity, 3, md, cd, eval);
                this.out.println("    }");
                this.out.println("    public static SephObject " + name + "(SThread thread, LexicalScope scope, SephObject receiver, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3) {");
                this.generateForArityMH(arity, 4, md, cd, eval);
                this.out.println("    }");
                this.out.println("    public static SephObject " + name + "(SThread thread, LexicalScope scope, SephObject receiver, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3, MethodHandle arg4) {");
                this.generateForArityMH(arity, 5, md, cd, eval);
                this.out.println("    }");
            }
        }
    }
}

