/*
 * Decompiled with CFR 0.152.
 */
package seph.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.SwitchPoint;
import seph.lang.ControlFlow;
import seph.lang.Ground;
import seph.lang.Regexp;
import seph.lang.SThread;
import seph.lang.SephClassLoader;
import seph.lang.SephObject;
import seph.lang.SimpleSephObject;
import seph.lang.Something;
import seph.lang.Text;
import seph.lang.ast.Message;
import seph.lang.compiler.Bootstrap;
import seph.lang.interpreter.MessageInterpreter;
import seph.lang.parser.Parser;
import seph.lang.parser.StringUtils;

public class Runtime {
    public static final SephClassLoader LOADER = new SephClassLoader(Runtime.class.getClassLoader());
    public static final SephObject TRUE = new SimpleSephObject(){

        public String toString() {
            return "true";
        }

        @Override
        public SephObject get(String cellName) {
            return Something.instance.get(cellName);
        }
    };
    public static final SephObject FALSE = new SimpleSephObject(){

        public String toString() {
            return "false";
        }

        @Override
        public boolean isTrue() {
            return false;
        }

        @Override
        public SephObject get(String cellName) {
            return Something.instance.get(cellName);
        }
    };
    public static final SephObject NIL = new SimpleSephObject(){

        public String toString() {
            return "nil";
        }

        @Override
        public boolean isTrue() {
            return false;
        }

        @Override
        public SephObject get(String cellName) {
            return Something.instance.get(cellName);
        }
    };
    public static final MethodHandle INVALIDATE_MH = Bootstrap.findStatic(Runtime.class, "invalidate", MethodType.methodType(Void.TYPE, SwitchPoint.class));
    public static final MethodHandle EMPTY_MH = Bootstrap.findStatic(Runtime.class, "empty", MethodType.methodType(Void.TYPE));
    public final SwitchPoint INTRINSIC_TRUE_SP = new SwitchPoint();
    public final SwitchPoint INTRINSIC_FALSE_SP = new SwitchPoint();
    public final SwitchPoint INTRINSIC_NIL_SP = new SwitchPoint();
    public final SwitchPoint INTRINSIC_IF_SP = new SwitchPoint();
    public final MethodHandle INVALIDATE_TRUE = this.INTRINSIC_TRUE_SP.guardWithTest(INVALIDATE_MH.bindTo(this.INTRINSIC_TRUE_SP), EMPTY_MH);
    public final MethodHandle INVALIDATE_FALSE = this.INTRINSIC_FALSE_SP.guardWithTest(INVALIDATE_MH.bindTo(this.INTRINSIC_FALSE_SP), EMPTY_MH);
    public final MethodHandle INVALIDATE_NIL = this.INTRINSIC_NIL_SP.guardWithTest(INVALIDATE_MH.bindTo(this.INTRINSIC_NIL_SP), EMPTY_MH);
    public final MethodHandle INVALIDATE_IF = this.INTRINSIC_IF_SP.guardWithTest(INVALIDATE_MH.bindTo(this.INTRINSIC_IF_SP), EMPTY_MH);

    public static void empty() {
    }

    public static void invalidate(SwitchPoint sp) {
        SwitchPoint.invalidateAll(new SwitchPoint[]{sp});
    }

    public void checkIntrinsicAssignment(String name) {
        name = name.intern();
        try {
            if (name == "true") {
                this.INVALIDATE_TRUE.invokeExact();
            } else if (name == "false") {
                this.INVALIDATE_FALSE.invokeExact();
            } else if (name == "nil") {
                this.INVALIDATE_NIL.invokeExact();
            } else if (name == "if") {
                this.INVALIDATE_IF.invokeExact();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Text newText(String stringBeforeEscapeMangling) {
        return new Text(new StringUtils().replaceEscapes(stringBeforeEscapeMangling));
    }

    public Text newUnescapedText(String text) {
        return new Text(text);
    }

    public Regexp newRegexp(String pattern, String flags) {
        return Regexp.create(new StringUtils().replaceRegexpEscapes(pattern), flags);
    }

    public Object evaluateStream(String name, Reader reader) throws ControlFlow, IOException {
        Message msg = (Message)new Parser(this, reader, name).parseFully().seq().first();
        return new MessageInterpreter(Ground.instance, this).evaluateFully(new SThread(this), msg);
    }

    public Object evaluateFile(File f) throws ControlFlow, IOException {
        return this.evaluateStream(f.getCanonicalPath(), new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
    }

    public Object evaluateFile(String filename) throws ControlFlow, IOException {
        return this.evaluateStream(filename, new InputStreamReader((InputStream)new FileInputStream(new File(filename)), "UTF-8"));
    }

    public Object evaluateString(String string) throws ControlFlow, IOException {
        return this.evaluateStream("<eval>", new StringReader(string));
    }
}

