/*
 * Decompiled with CFR 0.152.
 */
package seph.lang;

import java.util.Properties;
import seph.lang.Runtime;

public class Main {
    private static final String HELP = "Usage: seph [switches] -- [programfile] [arguments]\n -h, --help      help, this message\n --copyright     print the copyright\n --version       print current version\n";
    private static final String COPYRIGHT = "Copyright (c) 2010-2011 Ola Bini, ola.bini@gmail.com\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the \"Software\"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in\nall copies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\nTHE SOFTWARE.\n";

    public static void main(String[] args) throws Throwable {
        int start;
        boolean done = false;
        boolean printedSomething = false;
        for (start = 0; !done && start < args.length; ++start) {
            String arg = args[start];
            if (arg.length() <= 0) continue;
            if (arg.charAt(0) != '-') {
                done = true;
                break;
            }
            if (arg.equals("--")) {
                done = true;
                continue;
            }
            if (arg.equals("-h") || arg.equals("--help")) {
                System.err.print(HELP);
                return;
            }
            if (arg.equals("--version")) {
                System.err.println(Main.getVersion());
                printedSomething = true;
                continue;
            }
            if (!arg.equals("--copyright")) continue;
            System.err.print(COPYRIGHT);
            printedSomething = true;
        }
        if (args.length > start) {
            String file = args[start];
            if (file.startsWith("\"")) {
                file = file.substring(1, file.length());
            }
            if (file.length() > 1 && file.charAt(file.length() - 1) == '\"') {
                file = file.substring(0, file.length() - 1);
            }
            Runtime r = new Runtime();
            r.evaluateFile(file);
        }
    }

    public static String getVersion() {
        try {
            Properties props = new Properties();
            props.load(Main.class.getResourceAsStream("/seph/lang/version.properties"));
            String version = props.getProperty("seph.build.versionString");
            String date = props.getProperty("seph.build.date");
            String commit = props.getProperty("seph.build.commit");
            return version + " [" + date + " -- " + commit + "]";
        }
        catch (Exception exception) {
            return "";
        }
    }
}

