/*
 * Decompiled with CFR 0.152.
 */
package seph.lang;

import java.util.ArrayList;
import seph.lang.ControlDefaultBehavior;
import seph.lang.LexicalScope;
import seph.lang.Runtime;
import seph.lang.SThread;
import seph.lang.SephObject;
import seph.lang.SimpleSephObject;
import seph.lang.ast.Abstraction;
import seph.lang.ast.Message;
import seph.lang.compiler.AbstractionCompiler;
import seph.lang.compiler.CompilationAborted;
import seph.lang.persistent.IPersistentList;
import seph.lang.persistent.ISeq;
import seph.lang.persistent.PersistentArrayMap;
import seph.lang.persistent.PersistentList;
import seph.lang.persistent.RT;

public class DefaultAbstraction
extends SimpleSephObject {
    private Message code;
    private LexicalScope capture;
    private IPersistentList argumentNames;

    private DefaultAbstraction(IPersistentList argNames, Message code, LexicalScope capture) {
        super(PersistentArrayMap.EMPTY.associate(activatable, Runtime.TRUE));
        this.argumentNames = argNames;
        this.code = code;
        this.capture = capture;
    }

    public static final SephObject createFrom(Abstraction message, LexicalScope scope) {
        ISeq seq = RT.seq(message.arguments());
        try {
            return AbstractionCompiler.compile(seq, scope);
        }
        catch (CompilationAborted e) {
            System.err.println("BAILED OUT ON COMPILE (" + e.getMessage() + "): " + message);
            ArrayList<String> argNames = new ArrayList<String>();
            if (seq != null) {
                while (RT.next(seq) != null) {
                    argNames.add(((Message)RT.first(seq)).name());
                    seq = RT.next(seq);
                }
            }
            Message code = (Message)RT.first(seq);
            return new DefaultAbstraction(PersistentList.create(argNames), code, scope);
        }
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, IPersistentList arguments) {
        LexicalScope methodScope = this.capture.newScopeWith(receiver);
        ISeq argNames = this.argumentNames.seq();
        for (ISeq args = arguments.seq(); argNames != null && args != null; argNames = argNames.next(), args = args.next()) {
            String name = (String)argNames.first();
            SephObject val = ControlDefaultBehavior.evaluateArgument(args.first(), scope, thread, true);
            methodScope.directlyAssign(name, val);
        }
        return methodScope.evaluate(thread, this.code);
    }
}

