/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.objectweb.asm.Type;

public final class MethodType {
    final String desc;

    public MethodType(String string) {
        this.desc = string;
    }

    public MethodType(Type type, Type[] typeArray) {
        this.desc = Type.getMethodDescriptor(type, typeArray);
    }

    public MethodType(Constructor constructor) {
        this.desc = Type.getConstructorDescriptor(constructor);
    }

    public MethodType(Method method) {
        this.desc = Type.getMethodDescriptor(method);
    }

    public String getDescriptor() {
        return this.desc;
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.desc);
    }

    public Type getReturnType() {
        return Type.getReturnType(this.desc);
    }

    public int getArgumentsAndReturnSizes() {
        return Type.getArgumentsAndReturnSizes(this.desc);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MethodType)) {
            return false;
        }
        return this.desc.equals(((MethodType)object).desc);
    }

    public int hashCode() {
        return ~this.desc.hashCode();
    }

    public String toString() {
        return this.desc;
    }
}

