/*
 * Decompiled with CFR 0.152.
 */
package org.jregex;

import org.jregex.Pattern;
import org.jregex.PatternSyntaxException;

public class WildcardPattern
extends Pattern {
    public static final String WORD_CHAR = "\\w";
    public static final String ANY_CHAR = ".";
    private static final String defaultSpecials = "[]().{}+|^$\\";
    private static final String defaultWcClass = ".";
    private String str;

    protected static String convertSpecials(String s, String wcClass, String specials) {
        int len = s.length();
        StringBuffer sb = new StringBuffer();
        block4: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '*': {
                    sb.append("(");
                    sb.append(wcClass);
                    sb.append("*)");
                    continue block4;
                }
                case '?': {
                    sb.append("(");
                    sb.append(wcClass);
                    sb.append(")");
                    continue block4;
                }
                default: {
                    if (specials.indexOf(c) >= 0) {
                        sb.append('\\');
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public WildcardPattern(String wc) {
        this(wc, true);
    }

    public WildcardPattern(String wc, boolean icase) {
        this(wc, icase ? 1 : 0);
    }

    public WildcardPattern(String wc, int flags) {
        this.compile(wc, ".", defaultSpecials, flags);
    }

    public WildcardPattern(String wc, String wcClass, int flags) {
        this.compile(wc, wcClass, defaultSpecials, flags);
    }

    protected WildcardPattern() {
    }

    protected void compile(String wc, String wcClass, String specials, int flags) {
        String converted = WildcardPattern.convertSpecials(wc, wcClass, specials);
        try {
            this.compile(converted, flags);
        }
        catch (PatternSyntaxException e) {
            throw new Error(e.getMessage() + "; original expr: " + wc + ", converted: " + converted);
        }
        this.str = wc;
    }

    @Override
    public String toString() {
        return this.str;
    }
}

