/*
 * Decompiled with CFR 0.152.
 */
package org.jregex;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jregex.BackReference;
import org.jregex.Branch;
import org.jregex.CharacterClass;
import org.jregex.ConditionalExpr;
import org.jregex.Group;
import org.jregex.IndependentGroup;
import org.jregex.Iterator;
import org.jregex.Lookahead;
import org.jregex.Lookbehind;
import org.jregex.Optimizer;
import org.jregex.Pattern;
import org.jregex.PatternSyntaxException;
import org.jregex.Pretokenizer;
import org.jregex.REFlags;

class Term
implements REFlags {
    static final int VARS_LENGTH = 4;
    private static final int MEMREG_COUNT = 0;
    private static final int CNTREG_COUNT = 1;
    private static final int DEPTH = 2;
    private static final int LOOKAHEAD_COUNT = 3;
    private static final int LIMITS_LENGTH = 3;
    private static final int LIMITS_PARSE_RESULT_INDEX = 2;
    private static final int LIMITS_OK = 1;
    private static final int LIMITS_FAILURE = 2;
    Term next;
    Term failNext;
    TermType type = TermType.VOID;
    boolean inverse;
    char c;
    int distance;
    boolean eat;
    boolean[] bitset;
    boolean[][] bitset2;
    boolean[] categoryBitset;
    char[] brackets;
    int weight;
    int memreg = -1;
    int minCount;
    int maxCount;
    Term target;
    int cntreg = 0;
    int lookaheadId;
    protected Term prev;
    protected Term in;
    protected Term out;
    protected Term out1;
    protected Term first;
    protected Term current;
    protected Term branchOut;
    static int instances;
    int instanceNum = instances++;

    Term() {
        this.in = this.out = this;
    }

    Term(TermType type) {
        this();
        this.type = type;
    }

    static void makeTree(String s, int flags, Pattern re) throws PatternSyntaxException {
        char[] data = s.toCharArray();
        Term.makeTree(data, 0, data.length, flags, re);
    }

    static void makeTree(char[] data, int offset, int end, int flags, Pattern re) throws PatternSyntaxException {
        Term first;
        int[] vars = new int[]{1, 0, 0, 0};
        ArrayList iterators = new ArrayList();
        LinkedHashMap groupNames = new LinkedHashMap();
        Pretokenizer t = new Pretokenizer(data, offset, end);
        Term term = Term.makeTree(t, data, vars, flags, new Group(), iterators, groupNames);
        term.out.type = TermType.SUCCESS;
        Term optimized = first = term.next;
        Optimizer opt = Optimizer.find(first);
        if (opt != null) {
            optimized = opt.makeFirst(first);
        }
        for (Iterator i : iterators) {
            i.optimize();
        }
        re.root = optimized;
        re.root0 = first;
        re.memregs = vars[0];
        re.counters = vars[1];
        re.lookaheads = vars[3];
        re.namedGroupMap = groupNames;
    }

    /*
     * Unable to fully structure code
     */
    private static Term makeTree(Pretokenizer t, char[] data, int[] vars, int flags, Term term, List iterators, Map groupNames) throws PatternSyntaxException {
        if (vars.length != 4) {
            throw new IllegalArgumentException("vars.length should be 4, not " + vars.length);
        }
        block26: while (true) {
            t.next();
            term.append(t.tOffset, t.tOutside, data, vars, flags, iterators, groupNames);
            switch (t.ttype) {
                case 11: {
                    flags = t.flags(flags);
                    continue block26;
                }
                case 12: {
                    t.next();
                    clg = new Term();
                    CharacterClass.parseGroup(data, t.tOffset, t.tOutside, clg, (flags & 1) > 0, (flags & 8) > 0, (flags & 16) > 0, (flags & 32) > 0);
                    term.append(clg);
                    continue block26;
                }
                case 3: {
                    vars[2] = vars[2] + 1;
                    term.append(Term.makeTree(t, data, vars, t.flags(flags), new Group(), iterators, groupNames));
                    continue block26;
                }
                case 13: {
                    gname = t.groupName;
                    if (Character.isDigit(gname.charAt(0))) {
                        try {
                            id = Integer.parseInt(gname);
                        }
                        catch (NumberFormatException e) {
                            throw new PatternSyntaxException("group name starts with digit but is not a number");
                        }
                        if (groupNames.containsValue(new Integer(id)) && t.groupDeclared) {
                            throw new PatternSyntaxException("group redeclaration: " + gname + "; use ({=id}...) for multiple group assignments");
                        }
                        if (vars[0] <= id) {
                            vars[0] = id + 1;
                        }
                    } else {
                        no = (Integer)groupNames.get(gname);
                        if (no == null) {
                            vars[0] = vars[0] + 1;
                            groupNames.put(t.groupName, new Integer(id));
                        } else {
                            if (t.groupDeclared) {
                                throw new PatternSyntaxException("group redeclaration " + gname + "; use ({=name}...) for group reassignments");
                            }
                            id = no;
                        }
                    }
                    vars[2] = vars[2] + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Group(id), iterators, groupNames));
                    continue block26;
                }
                case 40: {
                    vars[2] = vars[2] + 1;
                    v0 = vars[0];
                    vars[0] = v0 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Group(v0), iterators, groupNames));
                    continue block26;
                }
                case 4: {
                    vars[2] = vars[2] + 1;
                    v1 = vars[3];
                    vars[3] = v1 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Lookahead(v1, true), iterators, groupNames));
                    continue block26;
                }
                case 5: {
                    vars[2] = vars[2] + 1;
                    v2 = vars[3];
                    vars[3] = v2 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Lookahead(v2, false), iterators, groupNames));
                    continue block26;
                }
                case 6: {
                    vars[2] = vars[2] + 1;
                    v3 = vars[3];
                    vars[3] = v3 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Lookbehind(v3, true), iterators, groupNames));
                    continue block26;
                }
                case 7: {
                    vars[2] = vars[2] + 1;
                    v4 = vars[3];
                    vars[3] = v4 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new Lookbehind(v4, false), iterators, groupNames));
                    continue block26;
                }
                case 8: {
                    vars[2] = vars[2] + 1;
                    v5 = vars[3];
                    vars[3] = v5 + 1;
                    term.append(Term.makeTree(t, data, vars, flags, new IndependentGroup(v5), iterators, groupNames));
                    continue block26;
                }
                case 10: {
                    vars[2] = vars[2] + 1;
                    t.next();
                    fork = null;
                    positive = true;
                    switch (t.ttype) {
                        case 5: {
                            positive = false;
                        }
                        case 4: {
                            vars[2] = vars[2] + 1;
                            v6 = vars[3];
                            vars[3] = v6 + 1;
                            la = new Lookahead(v6, positive);
                            Term.makeTree(t, data, vars, flags, la, iterators, groupNames);
                            fork = new ConditionalExpr(la);
                            break;
                        }
                        case 7: {
                            positive = false;
                        }
                        case 6: {
                            vars[2] = vars[2] + 1;
                            v7 = vars[3];
                            vars[3] = v7 + 1;
                            lb = new Lookbehind(v7, positive);
                            Term.makeTree(t, data, vars, flags, lb, iterators, groupNames);
                            fork = new ConditionalExpr(lb);
                            break;
                        }
                        case 40: {
                            t.next();
                            if (t.ttype != 41) {
                                throw new PatternSyntaxException("malformed condition");
                            }
                            if (Character.isDigit(data[t.tOffset])) {
                                memregNo = Term.makeNumber(t.tOffset, t.tOutside, data);
                            } else {
                                gn = new String(data, t.tOffset, t.tOutside - t.tOffset);
                                gno = (Integer)groupNames.get(gn);
                                if (gno == null) {
                                    throw new PatternSyntaxException("unknown group name in conditional expr.: " + gn);
                                }
                                memregNo = gno;
                            }
                            fork = new ConditionalExpr(memregNo);
                            break;
                        }
                        default: {
                            throw new PatternSyntaxException("malformed conditional expression: " + t.ttype + " '" + (char)t.ttype + "'");
                        }
                    }
                    term.append(Term.makeTree(t, data, vars, flags, fork, iterators, groupNames));
                    continue block26;
                }
                case 124: {
                    term.newBranch();
                    continue block26;
                }
                case 2: {
                    if (vars[2] > 0) {
                        throw new PatternSyntaxException("unbalanced parenthesis");
                    }
                    term.close();
                    return term;
                }
                case 41: {
                    if (vars[2] <= 0) {
                        throw new PatternSyntaxException("unbalanced parenthesis");
                    }
                    term.close();
                    vars[2] = vars[2] - 1;
                    return term;
                }
                case 9: {
                    while (true) {
                        if (t.ttype != 41) ** break;
                        continue block26;
                        t.next();
                    }
                }
            }
            break;
        }
        throw new PatternSyntaxException("unknown token type: " + t.ttype);
    }

    static int makeNumber(int off, int out, char[] data) {
        int n = 0;
        for (int i = off; i < out; ++i) {
            int d = data[i] - 48;
            if (d < 0 || d > 9) {
                return -1;
            }
            n *= 10;
            n += d;
        }
        return n;
    }

    protected void append(int offset, int end, char[] data, int[] vars, int flags, List iterators, Map gmap) throws PatternSyntaxException {
        int[] limits = new int[3];
        int i = offset;
        Term current = this.current;
        block22: while (i < end) {
            Term tmp;
            char c = data[i];
            boolean greedy = true;
            switch (c) {
                case '*': {
                    if (current == null) {
                        throw new PatternSyntaxException("missing term before *");
                    }
                    if (++i < end) {
                        switch (data[i]) {
                            case '?': {
                                greedy ^= true;
                                ++i;
                                break;
                            }
                            case '*': 
                            case '+': {
                                throw new PatternSyntaxException("nested *?+ in regexp");
                            }
                        }
                    }
                    tmp = greedy ? Term.makeGreedyStar(vars, current, iterators) : Term.makeLazyStar(vars, current);
                    current = this.replaceCurrent(tmp);
                    continue block22;
                }
                case '+': {
                    if (current == null) {
                        throw new PatternSyntaxException("missing term before +");
                    }
                    if (++i < end) {
                        switch (data[i]) {
                            case '?': {
                                greedy ^= true;
                                ++i;
                                break;
                            }
                            case '*': 
                            case '+': {
                                throw new PatternSyntaxException("nested *?+ in regexp");
                            }
                        }
                    }
                    tmp = greedy ? Term.makeGreedyPlus(vars, current, iterators) : Term.makeLazyPlus(vars, current);
                    current = this.replaceCurrent(tmp);
                    continue block22;
                }
                case '?': {
                    if (current == null) {
                        throw new PatternSyntaxException("missing term before ?");
                    }
                    if (++i < end) {
                        switch (data[i]) {
                            case '?': {
                                greedy ^= true;
                                ++i;
                                break;
                            }
                            case '*': 
                            case '+': {
                                throw new PatternSyntaxException("nested *?+ in regexp");
                            }
                        }
                    }
                    tmp = greedy ? Term.makeGreedyQMark(vars, current) : Term.makeLazyQMark(vars, current);
                    current = this.replaceCurrent(tmp);
                    continue block22;
                }
                case '{': {
                    limits[0] = 0;
                    limits[1] = -1;
                    int le = Term.parseLimits(i + 1, end, data, limits);
                    if (limits[2] == 1) {
                        if (current == null) {
                            throw new PatternSyntaxException("missing term before {}");
                        }
                        i = le;
                        if (i < end && data[i] == '?') {
                            greedy ^= true;
                            ++i;
                        }
                        tmp = greedy ? Term.makeGreedyLimits(vars, current, limits, iterators) : Term.makeLazyLimits(vars, current, limits);
                        current = this.replaceCurrent(tmp);
                        continue block22;
                    }
                    if (data[i + 1] == '\\') {
                        int p = i + 2;
                        if (p == end) {
                            throw new PatternSyntaxException("'group_id' expected");
                        }
                        while (Character.isWhitespace(data[p])) {
                            if (++p != end) continue;
                            throw new PatternSyntaxException("'group_id' expected");
                        }
                        BackReference br = new BackReference(-1, (flags & 1) > 0);
                        i = Term.parseGroupId(data, p, end, br, gmap);
                        current = this.append(br);
                        continue block22;
                    }
                    Term t = new Term();
                    i = CharacterClass.parseName(data, i, end, t, false, (flags & 8) > 0);
                    current = this.append(t);
                    continue block22;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if ((flags & 8) <= 0) break;
                    ++i;
                    continue block22;
                }
            }
            tmp = new Term();
            i = this.parseTerm(data, i, end, tmp, flags);
            if (tmp.type == TermType.END && i < end) {
                if ((flags & 8) > 0) {
                    ++i;
                    block24: while (i < end) {
                        c = data[i];
                        switch (c) {
                            case '\t': 
                            case '\n': 
                            case '\r': 
                            case ' ': {
                                ++i;
                                continue block24;
                            }
                        }
                        throw new PatternSyntaxException("'$' is not a last term in the group: <" + new String(data, offset, end - offset) + ">");
                    }
                } else {
                    throw new PatternSyntaxException("'$' is not a last term in the group: <" + new String(data, offset, end - offset) + ">");
                }
            }
            current = this.append(tmp);
        }
    }

    private static int parseGroupId(char[] data, int i, int end, Term term, Map gmap) throws PatternSyntaxException {
        char c;
        int id;
        int nstart = i;
        if (Character.isDigit(data[i])) {
            while (Character.isDigit(data[i])) {
                if (++i != end) continue;
                throw new PatternSyntaxException("group_id expected");
            }
            id = Term.makeNumber(nstart, i, data);
        } else {
            while (Character.isJavaIdentifierPart(data[i])) {
                if (++i != end) continue;
                throw new PatternSyntaxException("group_id expected");
            }
            String s = new String(data, nstart, i - nstart);
            Integer no = (Integer)gmap.get(s);
            if (no == null) {
                throw new PatternSyntaxException("backreference to unknown group: " + s);
            }
            id = no;
        }
        while (Character.isWhitespace(data[i])) {
            if (++i != end) continue;
            throw new PatternSyntaxException("'}' expected");
        }
        if ((c = data[i++]) != '}') {
            throw new PatternSyntaxException("'}' expected");
        }
        term.memreg = id;
        return i;
    }

    protected Term append(Term term) throws PatternSyntaxException {
        Term current = this.current;
        if (current == null) {
            this.in.next = term;
            term.prev = this.in;
            this.current = term;
            return term;
        }
        Term.link(current, term);
        this.current = term;
        return term;
    }

    protected Term replaceCurrent(Term term) throws PatternSyntaxException {
        Term prev = this.current.prev;
        if (prev != null) {
            Term in = this.in;
            if (prev == in) {
                in.next = term.in;
                term.in.prev = in;
            } else {
                Term.link(prev, term);
            }
        }
        this.current = term;
        return term;
    }

    protected void newBranch() throws PatternSyntaxException {
        this.close();
        this.startNewBranch();
    }

    protected void close() throws PatternSyntaxException {
        Term current = this.current;
        if (current != null) {
            Term.linkd(current, this.out);
        } else {
            this.in.next = this.out;
        }
    }

    private static final void link(Term term, Term next) {
        Term.linkd(term, next.in);
        next.prev = term;
    }

    private static final void linkd(Term term, Term next) {
        Term prev_branch;
        Term prev_out1;
        Term prev_out = term.out;
        if (prev_out != null) {
            prev_out.next = next;
        }
        if ((prev_out1 = term.out1) != null) {
            prev_out1.next = next;
        }
        if ((prev_branch = term.branchOut) != null) {
            prev_branch.failNext = next;
        }
    }

    protected void startNewBranch() throws PatternSyntaxException {
        Term tmp = this.in.next;
        Branch b = new Branch();
        this.in.next = b;
        b.next = tmp;
        b.in = null;
        b.out = null;
        b.out1 = null;
        b.branchOut = b;
        this.current = b;
    }

    private static final Term makeGreedyStar(int[] vars, Term term, List iterators) throws PatternSyntaxException {
        switch (term.type) {
            case REPEAT_0_INF: 
            case REPEAT_MIN_INF: 
            case REPEAT_MIN_MAX: 
            case REPEAT_REG_MIN_INF: 
            case REPEAT_REG_MIN_MAX: 
            case INDEPENDENT_IN: 
            case GROUP_IN: {
                Branch b = new Branch();
                b.next = term.in;
                term.out.next = b;
                b.in = b;
                b.out = null;
                b.out1 = null;
                b.branchOut = b;
                return b;
            }
        }
        Iterator i = new Iterator(term, 0, -1, iterators);
        return i;
    }

    private static final Term makeLazyStar(int[] vars, Term term) {
        switch (term.type) {
            case REPEAT_0_INF: 
            case REPEAT_MIN_INF: 
            case REPEAT_MIN_MAX: 
            case REPEAT_REG_MIN_INF: 
            case REPEAT_REG_MIN_MAX: 
            case GROUP_IN: {
                Branch b = new Branch();
                b.failNext = term.in;
                term.out.next = b;
                b.in = b;
                b.out = b;
                b.out1 = null;
                b.branchOut = null;
                return b;
            }
        }
        Branch b = new Branch();
        b.failNext = term;
        term.next = b;
        b.in = b;
        b.out = b;
        b.out1 = null;
        b.branchOut = null;
        return b;
    }

    private static final Term makeGreedyPlus(int[] vars, Term term, List iterators) throws PatternSyntaxException {
        switch (term.type) {
            case REPEAT_0_INF: 
            case REPEAT_MIN_INF: 
            case REPEAT_MIN_MAX: 
            case REPEAT_REG_MIN_INF: 
            case REPEAT_REG_MIN_MAX: 
            case INDEPENDENT_IN: 
            case GROUP_IN: {
                Branch b = new Branch();
                b.next = term.in;
                term.out.next = b;
                b.in = term.in;
                b.out = null;
                b.out1 = null;
                b.branchOut = b;
                return b;
            }
        }
        return new Iterator(term, 1, -1, iterators);
    }

    private static final Term makeLazyPlus(int[] vars, Term term) {
        switch (term.type) {
            case REPEAT_0_INF: 
            case REPEAT_MIN_INF: 
            case REPEAT_MIN_MAX: 
            case REPEAT_REG_MIN_INF: 
            case REPEAT_REG_MIN_MAX: 
            case GROUP_IN: {
                Branch b = new Branch();
                term.out.next = b;
                b.failNext = term.in;
                b.in = term.in;
                b.out = b;
                b.out1 = null;
                b.branchOut = null;
                return b;
            }
        }
        Branch b = new Branch();
        term.next = b;
        b.failNext = term;
        b.in = term;
        b.out = b;
        b.out1 = null;
        b.branchOut = null;
        return b;
    }

    private static final Term makeGreedyQMark(int[] vars, Term term) {
        switch (term.type) {
            case REPEAT_0_INF: 
            case REPEAT_MIN_INF: 
            case REPEAT_MIN_MAX: 
            case REPEAT_REG_MIN_INF: 
            case REPEAT_REG_MIN_MAX: 
            case GROUP_IN: {
                Branch b = new Branch();
                b.next = term.in;
                b.in = b;
                b.out = term.out;
                b.out1 = null;
                b.branchOut = b;
                return b;
            }
        }
        Branch b = new Branch();
        b.next = term;
        b.in = b;
        b.out = term;
        b.out1 = null;
        b.branchOut = b;
        return b;
    }

    private static final Term makeLazyQMark(int[] vars, Term term) {
        switch (term.type) {
            case REPEAT_0_INF: 
            case REPEAT_MIN_INF: 
            case REPEAT_MIN_MAX: 
            case REPEAT_REG_MIN_INF: 
            case REPEAT_REG_MIN_MAX: 
            case GROUP_IN: {
                Branch b = new Branch();
                b.failNext = term.in;
                b.in = b;
                b.out = b;
                b.out1 = term.out;
                b.branchOut = null;
                return b;
            }
        }
        Branch b = new Branch();
        b.failNext = term;
        b.in = b;
        b.out = b;
        b.out1 = term;
        b.branchOut = null;
        return b;
    }

    private static final Term makeGreedyLimits(int[] vars, Term term, int[] limits, List iterators) throws PatternSyntaxException {
        int m = limits[0];
        int n = limits[1];
        switch (term.type) {
            case REPEAT_0_INF: 
            case REPEAT_MIN_INF: 
            case REPEAT_MIN_MAX: 
            case REPEAT_REG_MIN_INF: 
            case REPEAT_REG_MIN_MAX: 
            case GROUP_IN: {
                int n2 = vars[1];
                vars[1] = n2 + 1;
                int cntreg = n2;
                Term reset = new Term(TermType.CR_SET_0);
                reset.cntreg = cntreg;
                Term b = new Term(TermType.BRANCH);
                Term inc = new Term(TermType.CRSTORE_CRINC);
                inc.cntreg = cntreg;
                reset.next = b;
                if (n >= 0) {
                    Term lt = new Term(TermType.CR_LT);
                    lt.cntreg = cntreg;
                    lt.maxCount = n;
                    b.next = lt;
                    lt.next = term.in;
                } else {
                    b.next = term.in;
                }
                term.out.next = inc;
                inc.next = b;
                if (m >= 0) {
                    Term gt = new Term(TermType.CR_GT_EQ);
                    gt.cntreg = cntreg;
                    gt.maxCount = m;
                    b.failNext = gt;
                    reset.in = reset;
                    reset.out = gt;
                    reset.out1 = null;
                    reset.branchOut = null;
                } else {
                    reset.in = reset;
                    reset.out = null;
                    reset.out1 = null;
                    reset.branchOut = b;
                }
                return reset;
            }
        }
        return new Iterator(term, limits[0], limits[1], iterators);
    }

    private static final Term makeLazyLimits(int[] vars, Term term, int[] limits) {
        int m = limits[0];
        int n = limits[1];
        switch (term.type) {
            case REPEAT_0_INF: 
            case REPEAT_MIN_INF: 
            case REPEAT_MIN_MAX: 
            case REPEAT_REG_MIN_INF: 
            case REPEAT_REG_MIN_MAX: 
            case GROUP_IN: {
                int n2 = vars[1];
                vars[1] = n2 + 1;
                int cntreg = n2;
                Term reset = new Term(TermType.CR_SET_0);
                reset.cntreg = cntreg;
                Term b = new Term(TermType.BRANCH);
                Term inc = new Term(TermType.CRSTORE_CRINC);
                inc.cntreg = cntreg;
                reset.next = b;
                if (n >= 0) {
                    Term lt = new Term(TermType.CR_LT);
                    lt.cntreg = cntreg;
                    lt.maxCount = n;
                    b.failNext = lt;
                    lt.next = term.in;
                } else {
                    b.failNext = term.in;
                }
                term.out.next = inc;
                inc.next = b;
                if (m >= 0) {
                    Term gt = new Term(TermType.CR_GT_EQ);
                    gt.cntreg = cntreg;
                    gt.maxCount = m;
                    b.next = gt;
                    reset.in = reset;
                    reset.out = gt;
                    reset.out1 = null;
                    reset.branchOut = null;
                    return reset;
                }
                reset.in = reset;
                reset.out = b;
                reset.out1 = null;
                reset.branchOut = null;
                return reset;
            }
        }
        Term reset = new Term(TermType.CNT_SET_0);
        Branch b = new Branch(TermType.BRANCH_STORE_CNT);
        Term inc = new Term(TermType.CNT_INC);
        reset.next = b;
        if (n >= 0) {
            Term lt = new Term(TermType.READ_CNT_LT);
            lt.maxCount = n;
            b.failNext = lt;
            lt.next = term;
            term.next = inc;
            inc.next = b;
        } else {
            b.next = term;
            term.next = inc;
            inc.next = term;
        }
        if (m >= 0) {
            Term gt = new Term(TermType.CNT_GT_EQ);
            gt.maxCount = m;
            b.next = gt;
            reset.in = reset;
            reset.out = gt;
            reset.out1 = null;
            reset.branchOut = null;
            return reset;
        }
        reset.in = reset;
        reset.out = b;
        reset.out1 = null;
        reset.branchOut = null;
        return reset;
    }

    private final int parseTerm(char[] data, int i, int out, Term term, int flags) throws PatternSyntaxException {
        int c = data[i++];
        boolean inv = false;
        switch (c) {
            case 91: {
                return CharacterClass.parseClass(data, i, out, term, (flags & 1) > 0, (flags & 8) > 0, (flags & 0x10) > 0, (flags & 0x20) > 0);
            }
            case 46: {
                term.type = (flags & 4) > 0 ? TermType.ANY_CHAR : TermType.ANY_CHAR_NE;
                break;
            }
            case 36: {
                term.type = (flags & 2) > 0 ? TermType.LINE_END : TermType.END_EOL;
                break;
            }
            case 94: {
                term.type = (flags & 2) > 0 ? TermType.LINE_START : TermType.START;
                break;
            }
            case 92: {
                if (i >= out) {
                    throw new PatternSyntaxException("Escape without a character");
                }
                c = data[i++];
                switch (c) {
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 92: {
                        c = 92;
                        break;
                    }
                    case 117: {
                        if (i + 4 >= out) {
                            throw new PatternSyntaxException("To few characters for u-escape");
                        }
                        c = (char)((CharacterClass.toHexDigit(data[i++]) << 12) + (CharacterClass.toHexDigit(data[i++]) << 8) + (CharacterClass.toHexDigit(data[i++]) << 4) + CharacterClass.toHexDigit(data[i++]));
                        break;
                    }
                    case 118: {
                        if (i + 6 >= out) {
                            throw new PatternSyntaxException("To few characters for u-escape");
                        }
                        c = (char)((CharacterClass.toHexDigit(data[i++]) << 24) + (CharacterClass.toHexDigit(data[i++]) << 16) + (CharacterClass.toHexDigit(data[i++]) << 12) + (CharacterClass.toHexDigit(data[i++]) << 8) + (CharacterClass.toHexDigit(data[i++]) << 4) + CharacterClass.toHexDigit(data[i++]));
                        break;
                    }
                    case 120: {
                        char d;
                        if (i >= out) {
                            throw new PatternSyntaxException("To few characters for x-escape");
                        }
                        int hex = 0;
                        if ((d = data[i++]) == '{') {
                            while (i < out && (d = data[i++]) != '}') {
                                if ((hex = (hex << 4) + CharacterClass.toHexDigit(d)) <= 65535) continue;
                                throw new PatternSyntaxException("\\x{<out of range>}");
                            }
                        } else {
                            if (i >= out) {
                                throw new PatternSyntaxException("To few characters for x-escape");
                            }
                            hex = (CharacterClass.toHexDigit(d) << 4) + CharacterClass.toHexDigit(data[i++]);
                        }
                        c = (char)hex;
                        break;
                    }
                    case 48: 
                    case 111: {
                        char d;
                        int oct = 0;
                        while ((d = data[i]) >= '0' && d <= '7') {
                            oct *= 8;
                            if ((oct += d - 48) <= 65535 && ++i < out) continue;
                            break;
                        }
                        c = (char)oct;
                        break;
                    }
                    case 109: {
                        char d;
                        int dec = 0;
                        while ((d = data[i++]) >= '0' && d <= '9') {
                            dec *= 10;
                            if ((dec += d - 48) <= 65535 && i < out) continue;
                            break;
                        }
                        --i;
                        c = (char)dec;
                        break;
                    }
                    case 99: {
                        c = (char)(data[i++] & 0x1F);
                        break;
                    }
                    case 68: {
                        inv = true;
                    }
                    case 100: {
                        CharacterClass.makeDigit(term, inv, (flags & 0x10) > 0);
                        return i;
                    }
                    case 83: {
                        inv = true;
                    }
                    case 115: {
                        CharacterClass.makeSpace(term, inv, (flags & 0x10) > 0);
                        return i;
                    }
                    case 87: {
                        inv = true;
                    }
                    case 119: {
                        CharacterClass.makeWordChar(term, inv, (flags & 0x10) > 0);
                        return i;
                    }
                    case 66: {
                        inv = true;
                    }
                    case 98: {
                        CharacterClass.makeWordBoundary(term, inv, (flags & 0x10) > 0);
                        return i;
                    }
                    case 60: {
                        CharacterClass.makeWordStart(term, (flags & 0x10) > 0);
                        return i;
                    }
                    case 62: {
                        CharacterClass.makeWordEnd(term, (flags & 0x10) > 0);
                        return i;
                    }
                    case 65: {
                        term.type = TermType.START;
                        return i;
                    }
                    case 90: {
                        term.type = TermType.END_EOL;
                        return i;
                    }
                    case 122: {
                        term.type = TermType.END;
                        return i;
                    }
                    case 71: {
                        term.type = TermType.LAST_MATCH_END;
                        return i;
                    }
                    case 80: {
                        inv = true;
                    }
                    case 112: {
                        i = CharacterClass.parseName(data, i, out, term, inv, (flags & 8) > 0);
                        return i;
                    }
                    default: {
                        if (c < 49 || c > 57) break;
                        int n = c - 48;
                        while (i < out && (c = data[i]) >= 48 && c <= 57) {
                            n = n * 10 + c - 48;
                            ++i;
                        }
                        term.type = (flags & 1) > 0 ? TermType.REG_I : TermType.REG;
                        term.memreg = n;
                        return i;
                    }
                }
                term.type = TermType.CHAR;
                term.c = (char)c;
                break;
            }
            default: {
                if ((flags & 1) == 0) {
                    term.type = TermType.CHAR;
                    term.c = c;
                    break;
                }
                CharacterClass.makeICase(term, (char)c);
            }
        }
        return i;
    }

    protected static final int parseLimits(int i, int end, char[] data, int[] limits) throws PatternSyntaxException {
        if (limits.length != 3) {
            throw new IllegalArgumentException("maxTimess.length=" + limits.length + ", should be 2");
        }
        limits[2] = 1;
        int ind = 0;
        int v = 0;
        block5: while (i < end) {
            char c = data[i++];
            switch (c) {
                case ' ': {
                    continue block5;
                }
                case ',': {
                    if (ind > 0) {
                        throw new PatternSyntaxException("illegal construction: {.. , , ..}");
                    }
                    limits[ind++] = v;
                    v = -1;
                    continue block5;
                }
                case '}': {
                    limits[ind] = v;
                    if (ind == 0) {
                        limits[1] = v;
                    }
                    return i;
                }
            }
            if (c > '9' || c < '0') {
                limits[2] = 2;
                return i;
            }
            if (v < 0) {
                v = 0;
            }
            v = v * 10 + (c - 48);
        }
        throw new PatternSyntaxException("malformed quantifier");
    }

    public String toString() {
        StringBuffer b = new StringBuffer(100);
        b.append(this.instanceNum);
        b.append(": ");
        if (this.inverse) {
            b.append('^');
        }
        switch (this.type) {
            case VOID: {
                b.append("[]");
                b.append(" , ");
                break;
            }
            case CHAR: {
                b.append(CharacterClass.stringValue(this.c));
                b.append(" , ");
                break;
            }
            case ANY_CHAR: {
                b.append("dotall, ");
                break;
            }
            case ANY_CHAR_NE: {
                b.append("dot-eols, ");
                break;
            }
            case BITSET: {
                b.append('[');
                b.append(CharacterClass.stringValue0(this.bitset));
                b.append(']');
                b.append(" , weight=");
                b.append(this.weight);
                b.append(" , ");
                break;
            }
            case BITSET2: {
                b.append('[');
                b.append(CharacterClass.stringValue2(this.bitset2));
                b.append(']');
                b.append(" , weight=");
                b.append(this.weight);
                b.append(" , ");
                break;
            }
            case START: {
                b.append("abs.start");
                break;
            }
            case END: {
                b.append("abs.end");
                break;
            }
            case END_EOL: {
                b.append("abs.end-eol");
                break;
            }
            case LINE_START: {
                b.append("line start");
                break;
            }
            case LINE_END: {
                b.append("line end");
                break;
            }
            case LAST_MATCH_END: {
                if (this.inverse) {
                    b.append("non-");
                }
                b.append("BOUNDARY");
                break;
            }
            case BOUNDARY: {
                if (this.inverse) {
                    b.append("non-");
                }
                b.append("BOUNDARY");
                break;
            }
            case UBOUNDARY: {
                if (this.inverse) {
                    b.append("non-");
                }
                b.append("UBOUNDARY");
                break;
            }
            case DIRECTION: {
                b.append("DIRECTION");
                break;
            }
            case UDIRECTION: {
                b.append("UDIRECTION");
                break;
            }
            case FIND: {
                b.append(">>>{");
                b.append(this.target);
                b.append("}, <<");
                b.append(this.distance);
                if (this.eat) {
                    b.append(",eat");
                }
                b.append(", ");
                break;
            }
            case REPEAT_0_INF: {
                b.append("rpt{");
                b.append(this.target);
                b.append(",0,inf}");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case REPEAT_MIN_INF: {
                b.append("rpt{");
                b.append(this.target);
                b.append(",");
                b.append(this.minCount);
                b.append(",inf}");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case REPEAT_MIN_MAX: {
                b.append("rpt{");
                b.append(this.target);
                b.append(",");
                b.append(this.minCount);
                b.append(",");
                b.append(this.maxCount);
                b.append("}");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case REPEAT_REG_MIN_INF: {
                b.append("rpt{$");
                b.append(this.memreg);
                b.append(',');
                b.append(this.minCount);
                b.append(",inf}");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case REPEAT_REG_MIN_MAX: {
                b.append("rpt{$");
                b.append(this.memreg);
                b.append(',');
                b.append(this.minCount);
                b.append(',');
                b.append(this.maxCount);
                b.append("}");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case BACKTRACK_0: {
                b.append("back(0)");
                break;
            }
            case BACKTRACK_MIN: {
                b.append("back(");
                b.append(this.minCount);
                b.append(")");
                break;
            }
            case BACKTRACK_REG_MIN: {
                b.append("back");
                b.append("_$");
                b.append(this.memreg);
                b.append("(");
                b.append(this.minCount);
                b.append(")");
                break;
            }
            case GROUP_IN: {
                b.append('(');
                if (this.memreg > 0) {
                    b.append(this.memreg);
                }
                b.append('-');
                b.append(" , ");
                break;
            }
            case GROUP_OUT: {
                b.append('-');
                if (this.memreg > 0) {
                    b.append(this.memreg);
                }
                b.append(')');
                b.append(" , ");
                break;
            }
            case PLOOKAHEAD_IN: {
                b.append('(');
                b.append("=");
                b.append(this.lookaheadId);
                b.append(" , ");
                break;
            }
            case PLOOKAHEAD_OUT: {
                b.append('=');
                b.append(this.lookaheadId);
                b.append(')');
                b.append(" , ");
                break;
            }
            case NLOOKAHEAD_IN: {
                b.append("(!");
                b.append(this.lookaheadId);
                b.append(" , ");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case NLOOKAHEAD_OUT: {
                b.append('!');
                b.append(this.lookaheadId);
                b.append(')');
                b.append(" , ");
                break;
            }
            case PLOOKBEHIND_IN: {
                b.append('(');
                b.append("<=");
                b.append(this.lookaheadId);
                b.append(" , dist=");
                b.append(this.distance);
                b.append(" , ");
                break;
            }
            case PLOOKBEHIND_OUT: {
                b.append("<=");
                b.append(this.lookaheadId);
                b.append(')');
                b.append(" , ");
                break;
            }
            case NLOOKBEHIND_IN: {
                b.append("(<!");
                b.append(this.lookaheadId);
                b.append(" , dist=");
                b.append(this.distance);
                b.append(" , ");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case NLOOKBEHIND_OUT: {
                b.append("<!");
                b.append(this.lookaheadId);
                b.append(')');
                b.append(" , ");
                break;
            }
            case MEMREG_CONDITION: {
                b.append("(reg");
                b.append(this.memreg);
                b.append("?)");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case LOOKAHEAD_CONDITION_IN: {
                b.append("(cond");
                b.append(this.lookaheadId);
                b.append(((Lookahead)this).isPositive ? (char)'=' : '!');
                b.append(" , ");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case LOOKAHEAD_CONDITION_OUT: {
                b.append("cond");
                b.append(this.lookaheadId);
                b.append(")");
                if (this.failNext == null) break;
                b.append(", =>");
                b.append(this.failNext.instanceNum);
                b.append(", ");
                break;
            }
            case REG: {
                b.append("$");
                b.append(this.memreg);
                b.append(", ");
                break;
            }
            case SUCCESS: {
                b.append("END");
                break;
            }
            case BRANCH_STORE_CNT_AUX1: {
                b.append("(aux1)");
            }
            case BRANCH_STORE_CNT: {
                b.append("(cnt)");
            }
            case BRANCH: {
                b.append("=>");
                if (this.failNext != null) {
                    b.append(this.failNext.instanceNum);
                } else {
                    b.append("null");
                }
                b.append(" , ");
                break;
            }
            default: {
                b.append('[');
                switch (this.type) {
                    case CNT_SET_0: {
                        b.append("cnt=0");
                        break;
                    }
                    case CNT_INC: {
                        b.append("cnt++");
                        break;
                    }
                    case CNT_GT_EQ: {
                        b.append("cnt>=" + this.maxCount);
                        break;
                    }
                    case READ_CNT_LT: {
                        b.append("->cnt<" + this.maxCount);
                        break;
                    }
                    case CRSTORE_CRINC: {
                        b.append("M(" + this.memreg + ")->,Cr(" + this.cntreg + ")->,Cr(" + this.cntreg + ")++");
                        break;
                    }
                    case CR_SET_0: {
                        b.append("Cr(" + this.cntreg + ")=0");
                        break;
                    }
                    case CR_LT: {
                        b.append("Cr(" + this.cntreg + ")<" + this.maxCount);
                        break;
                    }
                    case CR_GT_EQ: {
                        b.append("Cr(" + this.cntreg + ")>=" + this.maxCount);
                        break;
                    }
                    default: {
                        b.append("unknown type: " + (Object)((Object)this.type));
                    }
                }
                b.append("] , ");
            }
        }
        if (this.next != null) {
            b.append("->");
            b.append(this.next.instanceNum);
            b.append(", ");
        }
        return b.toString();
    }

    public String toStringAll() {
        return this.toStringAll(new Vector());
    }

    public String toStringAll(Vector v) {
        v.addElement(new Integer(this.instanceNum));
        String s = this.toString();
        if (this.next != null && !v.contains(new Integer(this.next.instanceNum))) {
            s = s + "\r\n";
            s = s + this.next.toStringAll(v);
        }
        if (this.failNext != null && !v.contains(new Integer(this.failNext.instanceNum))) {
            s = s + "\r\n";
            s = s + this.failNext.toStringAll(v);
        }
        return s;
    }

    public static enum TermType {
        CHAR,
        BITSET,
        BITSET2,
        ANY_CHAR,
        ANY_CHAR_NE,
        REG,
        REG_I,
        FIND,
        FINDREG,
        SUCCESS,
        BOUNDARY,
        DIRECTION,
        UBOUNDARY,
        UDIRECTION,
        GROUP_IN,
        GROUP_OUT,
        VOID,
        START,
        END,
        END_EOL,
        LINE_START,
        LINE_END,
        LAST_MATCH_END,
        CNT_SET_0,
        CNT_INC,
        CNT_GT_EQ,
        READ_CNT_LT,
        CRSTORE_CRINC,
        CR_SET_0,
        CR_LT,
        CR_GT_EQ,
        BRANCH,
        BRANCH_STORE_CNT,
        BRANCH_STORE_CNT_AUX1,
        PLOOKAHEAD_IN,
        PLOOKAHEAD_OUT,
        NLOOKAHEAD_IN,
        NLOOKAHEAD_OUT,
        PLOOKBEHIND_IN,
        PLOOKBEHIND_OUT,
        NLOOKBEHIND_IN,
        NLOOKBEHIND_OUT,
        INDEPENDENT_IN,
        INDEPENDENT_OUT,
        REPEAT_0_INF,
        REPEAT_MIN_INF,
        REPEAT_MIN_MAX,
        REPEAT_REG_MIN_INF,
        REPEAT_REG_MIN_MAX,
        BACKTRACK_0,
        BACKTRACK_MIN,
        BACKTRACK_FIND_MIN,
        BACKTRACK_FINDREG_MIN,
        BACKTRACK_REG_MIN,
        MEMREG_CONDITION,
        LOOKAHEAD_CONDITION_IN,
        LOOKAHEAD_CONDITION_OUT,
        LOOKBEHIND_CONDITION_IN,
        LOOKBEHIND_CONDITION_OUT;

    }
}

