/*
 * Decompiled with CFR 0.152.
 */
package org.jregex;

import org.jregex.PatternSyntaxException;
import org.jregex.Term;

class Lookbehind
extends Term {
    final boolean isPositive;
    private int prevDistance = -1;

    Lookbehind(int id, boolean isPositive) {
        this.distance = 0;
        this.isPositive = isPositive;
        this.in = this;
        this.out = new Term();
        if (isPositive) {
            this.type = Term.TermType.PLOOKBEHIND_IN;
            this.out.type = Term.TermType.PLOOKBEHIND_OUT;
        } else {
            this.type = Term.TermType.NLOOKBEHIND_IN;
            this.out.type = Term.TermType.NLOOKBEHIND_OUT;
            this.branchOut = this;
        }
        this.lookaheadId = id;
        this.out.lookaheadId = id;
    }

    @Override
    protected Term append(Term t) throws PatternSyntaxException {
        this.distance += Lookbehind.length(t);
        return super.append(t);
    }

    @Override
    protected Term replaceCurrent(Term t) throws PatternSyntaxException {
        this.distance += Lookbehind.length(t) - Lookbehind.length(this.current);
        return super.replaceCurrent(t);
    }

    private static int length(Term t) throws PatternSyntaxException {
        Term.TermType type = t.type;
        switch (type) {
            case CHAR: 
            case BITSET: 
            case BITSET2: 
            case ANY_CHAR: 
            case ANY_CHAR_NE: {
                return 1;
            }
            case BOUNDARY: 
            case DIRECTION: 
            case UBOUNDARY: 
            case UDIRECTION: 
            case GROUP_IN: 
            case GROUP_OUT: 
            case VOID: 
            case START: 
            case END: 
            case END_EOL: 
            case LINE_START: 
            case LINE_END: 
            case LAST_MATCH_END: 
            case CNT_SET_0: 
            case CNT_INC: 
            case CNT_GT_EQ: 
            case READ_CNT_LT: 
            case CRSTORE_CRINC: 
            case CR_SET_0: 
            case CR_LT: 
            case CR_GT_EQ: {
                return 0;
            }
        }
        throw new PatternSyntaxException("variable length element within a lookbehind assertion");
    }

    @Override
    protected void startNewBranch() throws PatternSyntaxException {
        this.prevDistance = this.distance;
        this.distance = 0;
        super.startNewBranch();
    }

    @Override
    protected void close() throws PatternSyntaxException {
        int pd = this.prevDistance;
        if (pd >= 0 && this.distance != pd) {
            throw new PatternSyntaxException("non-equal branch lengths within a lookbehind assertion");
        }
        super.close();
    }
}

