/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import java.math.BigDecimal;
import java.math.BigInteger;

public class BigSquareRoot {
    private static BigDecimal ZERO = new BigDecimal("0");
    private static BigDecimal ONE = new BigDecimal("1");
    private static BigDecimal TWO = new BigDecimal("2");
    public static final int DEFAULT_MAX_ITERATIONS = 50;
    public static final int DEFAULT_SCALE = 10;
    private BigDecimal error;
    private final int scale;
    private final int maxIterations;

    public BigSquareRoot() {
        this(50, 10);
    }

    public BigSquareRoot(int maxIterations, int scale) {
        this.maxIterations = maxIterations;
        this.scale = scale;
    }

    public BigDecimal get(BigInteger n) {
        return this.get(new BigDecimal(n));
    }

    public BigDecimal get(BigDecimal n) {
        if (n.compareTo(ZERO) <= 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal initialGuess = BigSquareRoot.getInitialApproximation(n);
        BigDecimal lastGuess = ZERO;
        BigDecimal guess = new BigDecimal(initialGuess.toString());
        int iterations = 0;
        boolean more = true;
        while (more) {
            lastGuess = guess;
            guess = n.divide(guess, this.scale, 4);
            guess = guess.add(lastGuess);
            guess = guess.divide(TWO, this.scale, 4);
            this.error = n.subtract(guess.multiply(guess));
            if (++iterations >= this.maxIterations) {
                more = false;
                continue;
            }
            if (!lastGuess.equals(guess)) continue;
            more = this.error.abs().compareTo(ONE) >= 0;
        }
        return guess;
    }

    private static BigDecimal getInitialApproximation(BigDecimal n) {
        BigInteger integerPart = n.toBigInteger();
        int length = integerPart.toString().length();
        if (length % 2 == 0) {
            --length;
        }
        BigDecimal guess = ONE.movePointRight(length /= 2);
        return guess;
    }
}

