/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.persistent;

import java.util.Map;
import seph.lang.persistent.IPersistentMap;
import seph.lang.persistent.IPersistentVector;
import seph.lang.persistent.ISeq;
import seph.lang.persistent.ITransientMap;
import seph.lang.persistent.RT;

abstract class ATransientMap
implements ITransientMap {
    ATransientMap() {
    }

    abstract void ensureEditable();

    abstract ITransientMap doAssoc(Object var1, Object var2);

    abstract ITransientMap doWithout(Object var1);

    abstract Object doValAt(Object var1, Object var2);

    abstract int doCount();

    abstract IPersistentMap doPersistent();

    @Override
    public ITransientMap conj(Object o) {
        this.ensureEditable();
        if (o instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)o;
            return this.associate(e.getKey(), e.getValue());
        }
        if (o instanceof IPersistentVector) {
            IPersistentVector v = (IPersistentVector)o;
            if (v.count() != 2) {
                throw new IllegalArgumentException("Vector arg to map conj must be a pair");
            }
            return this.associate(v.at(0), v.at(1));
        }
        ITransientMap ret = this;
        for (ISeq es = RT.seq(o); es != null; es = es.next()) {
            Map.Entry e = (Map.Entry)es.first();
            ret = ret.associate(e.getKey(), e.getValue());
        }
        return ret;
    }

    @Override
    public final Object valueAt(Object key) {
        return this.valueAt(key, null);
    }

    @Override
    public final ITransientMap associate(Object key, Object val) {
        this.ensureEditable();
        return this.doAssoc(key, val);
    }

    @Override
    public final ITransientMap without(Object key) {
        this.ensureEditable();
        return this.doWithout(key);
    }

    @Override
    public final IPersistentMap persistent() {
        this.ensureEditable();
        return this.doPersistent();
    }

    @Override
    public final Object valueAt(Object key, Object notFound) {
        this.ensureEditable();
        return this.doValAt(key, notFound);
    }

    @Override
    public final int count() {
        this.ensureEditable();
        return this.doCount();
    }
}

