/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.persistent;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import seph.lang.SephObject;
import seph.lang.SimpleSephObject;
import seph.lang.persistent.ASeq;
import seph.lang.persistent.Counted;
import seph.lang.persistent.IMapEntry;
import seph.lang.persistent.IPersistentCollection;
import seph.lang.persistent.IPersistentMap;
import seph.lang.persistent.IPersistentVector;
import seph.lang.persistent.ISeq;
import seph.lang.persistent.IndexedSeq;
import seph.lang.persistent.MapEntry;
import seph.lang.persistent.PersistentList;
import seph.lang.persistent.RT;
import seph.lang.persistent.Sequential;
import seph.lang.persistent.Util;

public abstract class APersistentVector
extends SimpleSephObject
implements IPersistentVector,
Iterable,
List,
RandomAccess,
Comparable,
Serializable {
    int _hash = -1;

    protected APersistentVector(IPersistentMap meta) {
        super(meta);
    }

    protected APersistentVector() {
    }

    @Override
    public ISeq seq() {
        if (this.count() > 0) {
            return new Seq(this, 0);
        }
        return null;
    }

    public ISeq rseq() {
        if (this.count() > 0) {
            return new RSeq(this, this.count() - 1);
        }
        return null;
    }

    static boolean doEquals(IPersistentVector v, Object obj) {
        if (v == obj) {
            return true;
        }
        if (obj instanceof List || obj instanceof IPersistentVector) {
            Collection ma = (Collection)obj;
            if (ma.size() != v.count() || ma.hashCode() != v.hashCode()) {
                return false;
            }
            Iterator i1 = ((List)((Object)v)).iterator();
            Iterator i2 = ma.iterator();
            while (i1.hasNext()) {
                if (Util.equals(i1.next(), i2.next())) continue;
                return false;
            }
            return true;
        }
        if (!(obj instanceof Sequential)) {
            return false;
        }
        ISeq ms = RT.seq(obj);
        int i = 0;
        while (i < v.count()) {
            if (ms == null || !Util.equals(v.at(i), ms.first())) {
                return false;
            }
            ++i;
            ms = ms.next();
        }
        return ms == null;
    }

    static boolean doEquiv(IPersistentVector v, Object obj) {
        if (obj instanceof List || obj instanceof IPersistentVector) {
            Collection ma = (Collection)obj;
            if (ma.size() != v.count()) {
                return false;
            }
            Iterator i1 = ((List)((Object)v)).iterator();
            Iterator i2 = ma.iterator();
            while (i1.hasNext()) {
                if (Util.equiv(i1.next(), i2.next())) continue;
                return false;
            }
            return true;
        }
        if (!(obj instanceof Sequential)) {
            return false;
        }
        ISeq ms = RT.seq(obj);
        int i = 0;
        while (i < v.count()) {
            if (ms == null || !Util.equiv(v.at(i), ms.first())) {
                return false;
            }
            ++i;
            ms = ms.next();
        }
        return ms == null;
    }

    @Override
    public boolean equals(Object obj) {
        return APersistentVector.doEquals(this, obj);
    }

    @Override
    public boolean equiv(Object obj) {
        return APersistentVector.doEquiv(this, obj);
    }

    @Override
    public int hashCode() {
        if (this._hash == -1) {
            int hash = 1;
            for (Object obj : this) {
                hash = 31 * hash + (obj == null ? 0 : obj.hashCode());
            }
            this._hash = hash;
        }
        return this._hash;
    }

    public Object get(int index) {
        return this.at(index);
    }

    @Override
    public Object at(int i, Object notFound) {
        if (i >= 0 && i < this.count()) {
            return this.at(i);
        }
        return notFound;
    }

    public Object remove(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.count(); ++i) {
            if (!Util.equiv(this.at(i), o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.count() - 1; i >= 0; --i) {
            if (!Util.equiv(this.at(i), o)) continue;
            return i;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            int nexti;
            {
                this.nexti = index;
            }

            @Override
            public boolean hasNext() {
                return this.nexti < APersistentVector.this.count();
            }

            @Override
            public Object next() {
                return APersistentVector.this.at(this.nexti++);
            }

            @Override
            public boolean hasPrevious() {
                return this.nexti > 0;
            }

            public Object previous() {
                return APersistentVector.this.at(--this.nexti);
            }

            @Override
            public int nextIndex() {
                return this.nexti;
            }

            @Override
            public int previousIndex() {
                return this.nexti - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                throw new UnsupportedOperationException();
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List subList(int fromIndex, int toIndex) {
        return (List)((Object)RT.subvec(this, fromIndex, toIndex));
    }

    public Object set(int i, Object o) {
        throw new UnsupportedOperationException();
    }

    public void add(int i, Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int i, Collection c) {
        throw new UnsupportedOperationException();
    }

    public Object invoke(Object arg1) throws Exception {
        if (Util.isInteger(arg1)) {
            return this.at(((Number)arg1).intValue());
        }
        throw new IllegalArgumentException("Key must be integer");
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < APersistentVector.this.count();
            }

            public Object next() {
                return APersistentVector.this.at(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Object peek() {
        if (this.count() > 0) {
            return this.at(this.count() - 1);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!Util.isInteger(key)) {
            return false;
        }
        int i = ((Number)key).intValue();
        return i >= 0 && i < this.count();
    }

    @Override
    public IMapEntry entryAt(Object key) {
        int i;
        if (Util.isInteger(key) && (i = ((Number)key).intValue()) >= 0 && i < this.count()) {
            return new MapEntry(key, this.at(i));
        }
        return null;
    }

    @Override
    public IPersistentVector associate(Object key, Object val) {
        if (Util.isInteger(key)) {
            int i = ((Number)key).intValue();
            return this.assocN(i, val);
        }
        throw new IllegalArgumentException("Key must be integer");
    }

    @Override
    public Object valueAt(Object key, Object notFound) {
        int i;
        if (Util.isInteger(key) && (i = ((Number)key).intValue()) >= 0 && i < this.count()) {
            return this.at(i);
        }
        return notFound;
    }

    @Override
    public Object valueAt(Object key) {
        return this.valueAt(key, null);
    }

    @Override
    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length >= this.count()) {
            int i = 0;
            for (ISeq s = this.seq(); s != null; s = s.next()) {
                a[i] = s.first();
                ++i;
            }
            if (a.length > this.count()) {
                a[this.count()] = null;
            }
            return a;
        }
        return this.toArray();
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            if (!Util.equiv(s.first(), o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int length() {
        return this.count();
    }

    public int compareTo(Object o) {
        IPersistentVector v = (IPersistentVector)o;
        if (this.count() < v.count()) {
            return -1;
        }
        if (this.count() > v.count()) {
            return 1;
        }
        for (int i = 0; i < this.count(); ++i) {
            int c = Util.compare(this.at(i), v.at(i));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    static class SubVector
    extends APersistentVector
    implements SephObject {
        final IPersistentVector v;
        final int start;
        final int end;

        public SubVector(IPersistentMap meta, IPersistentVector v, int start, int end) {
            super(meta);
            if (v instanceof SubVector) {
                SubVector sv = (SubVector)v;
                start += sv.start;
                end += sv.start;
                v = sv.v;
            }
            this.v = v;
            this.start = start;
            this.end = end;
        }

        @Override
        public Object at(int i) {
            if (this.start + i >= this.end) {
                throw new IndexOutOfBoundsException();
            }
            return this.v.at(this.start + i);
        }

        @Override
        public IPersistentVector assocN(int i, Object val) {
            if (this.start + i > this.end) {
                throw new IndexOutOfBoundsException();
            }
            if (this.start + i == this.end) {
                return this.cons(val);
            }
            return new SubVector(this.meta(), this.v.assocN(this.start + i, val), this.start, this.end);
        }

        @Override
        public int count() {
            return this.end - this.start;
        }

        @Override
        public IPersistentVector cons(Object o) {
            return new SubVector(this.meta(), this.v.assocN(this.end, o), this.start, this.end + 1);
        }

        @Override
        public IPersistentCollection empty() {
            return PersistentList.EMPTY.withMeta(this.meta());
        }

        public SubVector withMeta(IPersistentMap meta) {
            if (meta == this.meta()) {
                return this;
            }
            return new SubVector(meta, this.v, this.start, this.end);
        }
    }

    public static class RSeq
    extends ASeq
    implements IndexedSeq,
    Counted {
        final IPersistentVector v;
        final int i;

        public RSeq(IPersistentVector vector, int i) {
            this.v = vector;
            this.i = i;
        }

        RSeq(IPersistentMap meta, IPersistentVector v, int i) {
            super(meta);
            this.v = v;
            this.i = i;
        }

        @Override
        public Object first() {
            return this.v.at(this.i);
        }

        @Override
        public ISeq next() {
            if (this.i > 0) {
                return new RSeq(this.v, this.i - 1);
            }
            return null;
        }

        @Override
        public int index() {
            return this.i;
        }

        @Override
        public int count() {
            return this.i + 1;
        }

        public RSeq withMeta(IPersistentMap meta) {
            return new RSeq(meta, this.v, this.i);
        }
    }

    static class Seq
    extends ASeq
    implements IndexedSeq {
        final IPersistentVector v;
        final int i;

        public Seq(IPersistentVector v, int i) {
            this.v = v;
            this.i = i;
        }

        Seq(IPersistentMap meta, IPersistentVector v, int i) {
            super(meta);
            this.v = v;
            this.i = i;
        }

        @Override
        public Object first() {
            return this.v.at(this.i);
        }

        @Override
        public ISeq next() {
            if (this.i + 1 < this.v.count()) {
                return new Seq(this.v, this.i + 1);
            }
            return null;
        }

        @Override
        public int index() {
            return this.i;
        }

        @Override
        public int count() {
            return this.v.count() - this.i;
        }

        public Seq withMeta(IPersistentMap meta) {
            return new Seq(meta, this.v, this.i);
        }
    }
}

