/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.persistent;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import seph.lang.SimpleSephObject;
import seph.lang.persistent.ASeq;
import seph.lang.persistent.IMapEntry;
import seph.lang.persistent.IPersistentCollection;
import seph.lang.persistent.IPersistentMap;
import seph.lang.persistent.IPersistentVector;
import seph.lang.persistent.ISeq;
import seph.lang.persistent.RT;
import seph.lang.persistent.Util;

public abstract class APersistentMap
extends SimpleSephObject
implements IPersistentMap,
Map,
Iterable,
Serializable {
    int _hash = -1;

    protected APersistentMap(IPersistentMap meta) {
        super(meta);
    }

    protected APersistentMap() {
    }

    @Override
    public IPersistentCollection cons(Object o) {
        if (o instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)o;
            return this.associate(e.getKey(), e.getValue());
        }
        if (o instanceof IPersistentVector) {
            IPersistentVector v = (IPersistentVector)o;
            if (v.count() != 2) {
                throw new IllegalArgumentException("Vector arg to map conj must be a pair");
            }
            return this.associate(v.at(0), v.at(1));
        }
        IPersistentMap ret = this;
        for (ISeq es = RT.seq(o); es != null; es = es.next()) {
            Map.Entry e = (Map.Entry)es.first();
            ret = ret.associate(e.getKey(), e.getValue());
        }
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map m = (Map)obj;
        if (m.size() != this.size() || m.hashCode() != this.hashCode()) {
            return false;
        }
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            Map.Entry e = (Map.Entry)s.first();
            boolean found = m.containsKey(e.getKey());
            if (found && Util.equals(e.getValue(), m.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equiv(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map m = (Map)obj;
        if (m.size() != this.size()) {
            return false;
        }
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            Map.Entry e = (Map.Entry)s.first();
            boolean found = m.containsKey(e.getKey());
            if (found && Util.equiv(e.getValue(), m.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this._hash == -1) {
            int hash = 0;
            for (ISeq s = this.seq(); s != null; s = s.next()) {
                Map.Entry e = (Map.Entry)s.first();
                hash += (e.getKey() == null ? 0 : e.getKey().hashCode()) ^ (e.getValue() == null ? 0 : e.getValue().hashCode());
            }
            this._hash = hash;
        }
        return this._hash;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public Set entrySet() {
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                return APersistentMap.this.iterator();
            }

            @Override
            public int size() {
                return APersistentMap.this.count();
            }

            @Override
            public int hashCode() {
                return APersistentMap.this.hashCode();
            }

            @Override
            public boolean contains(Object o) {
                Map.Entry e;
                IMapEntry found;
                return o instanceof Map.Entry && (found = APersistentMap.this.entryAt((e = (Map.Entry)o).getKey())) != null && Util.equals(found.getValue(), e.getValue());
            }
        };
    }

    public Object get(Object key) {
        return this.valueAt(key);
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    public Set keySet() {
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                final Iterator mi = APersistentMap.this.iterator();
                return new Iterator(){

                    @Override
                    public boolean hasNext() {
                        return mi.hasNext();
                    }

                    public Object next() {
                        Map.Entry e = (Map.Entry)mi.next();
                        return e.getKey();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return APersistentMap.this.count();
            }

            @Override
            public boolean contains(Object o) {
                return APersistentMap.this.containsKey(o);
            }
        };
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.count();
    }

    public Collection values() {
        return new AbstractCollection(){

            @Override
            public Iterator iterator() {
                final Iterator mi = APersistentMap.this.iterator();
                return new Iterator(){

                    @Override
                    public boolean hasNext() {
                        return mi.hasNext();
                    }

                    public Object next() {
                        Map.Entry e = (Map.Entry)mi.next();
                        return e.getValue();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return APersistentMap.this.count();
            }
        };
    }

    public static class ValSeq
    extends ASeq {
        ISeq seq;

        public static ValSeq create(ISeq seq) {
            if (seq == null) {
                return null;
            }
            return new ValSeq(seq);
        }

        private ValSeq(ISeq seq) {
            this.seq = seq;
        }

        private ValSeq(IPersistentMap meta, ISeq seq) {
            super(meta);
            this.seq = seq;
        }

        @Override
        public Object first() {
            return ((Map.Entry)this.seq.first()).getValue();
        }

        @Override
        public ISeq next() {
            return ValSeq.create(this.seq.next());
        }

        public ValSeq withMeta(IPersistentMap meta) {
            return new ValSeq(meta, this.seq);
        }
    }

    public static class KeySeq
    extends ASeq {
        ISeq seq;

        public static KeySeq create(ISeq seq) {
            if (seq == null) {
                return null;
            }
            return new KeySeq(seq);
        }

        private KeySeq(ISeq seq) {
            this.seq = seq;
        }

        private KeySeq(IPersistentMap meta, ISeq seq) {
            super(meta);
            this.seq = seq;
        }

        @Override
        public Object first() {
            return ((Map.Entry)this.seq.first()).getKey();
        }

        @Override
        public ISeq next() {
            return KeySeq.create(this.seq.next());
        }

        public KeySeq withMeta(IPersistentMap meta) {
            return new KeySeq(meta, this.seq);
        }
    }
}

