/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.compiler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class StringNames {
    static char ESCAPE_C = (char)92;
    static char NULL_ESCAPE_C = (char)61;
    static String NULL_ESCAPE = ESCAPE_C + "" + NULL_ESCAPE_C;
    static String DANGEROUS_CHARS = ".;:$[]<>/\\";
    static String REPLACEMENT_CHARS = ",?!%{}^_|-";
    static char[] DANGEROUS_CHARS_A = DANGEROUS_CHARS.toCharArray();
    static char[] REPLACEMENT_CHARS_A = REPLACEMENT_CHARS.toCharArray();
    static final long[] SPECIAL_BITMAP = new long[2];

    private StringNames() {
    }

    public static String toBytecodeName(String s) {
        String bn = StringNames.mangle(s);
        assert (bn == s || StringNames.looksMangled(bn)) : bn;
        assert (s.equals(StringNames.toSourceName(bn))) : s;
        return bn;
    }

    public static String toSourceName(String s) {
        assert (StringNames.isSafeBytecodeName(s)) : s;
        String sn = s;
        if (StringNames.looksMangled(s)) {
            sn = StringNames.demangle(s);
            assert (s.equals(StringNames.mangle(sn))) : s + " => " + sn + " => " + StringNames.mangle(sn);
        }
        return sn;
    }

    public static String toDisplayName(String s) {
        String ps;
        String p;
        int dci;
        if (StringNames.isSafeBytecodeName(s)) {
            boolean isuid = Character.isUnicodeIdentifierStart(s.charAt(0));
            int slen = s.length();
            for (int i = 1; i < slen; ++i) {
                if (Character.isUnicodeIdentifierPart(s.charAt(0))) continue;
                isuid = false;
                break;
            }
            if (isuid) {
                return s;
            }
            String ss = StringNames.toSourceName(s);
            if (s.equals(StringNames.toBytecodeName(ss))) {
                return StringNames.quoteDisplay(ss);
            }
        }
        if ((dci = StringNames.indexOfDangerousChar(s, 0)) > 0 && (p = s.substring(0, dci)).equals(StringNames.toBytecodeName(ps = StringNames.toSourceName(p)))) {
            String t = s.substring(dci + 1);
            return StringNames.quoteDisplay(StringNames.toSourceName(p)) + s.charAt(dci) + (t.equals("") ? "" : StringNames.toDisplayName(t));
        }
        return "?" + StringNames.quoteDisplay(s);
    }

    private static String quoteDisplay(String s) {
        return "'" + s.replaceAll("['\\\\]", "\\\\$0") + "'";
    }

    private static boolean isSafeBytecodeName(String s) {
        if (s.length() == 0) {
            return false;
        }
        for (char xc : DANGEROUS_CHARS_A) {
            if (xc == ESCAPE_C || s.indexOf(xc) < 0) continue;
            return false;
        }
        return true;
    }

    private static boolean looksMangled(String s) {
        return s.charAt(0) == ESCAPE_C;
    }

    private static String mangle(String s) {
        if (s.length() == 0) {
            return NULL_ESCAPE;
        }
        StringBuilder sb = null;
        int slen = s.length();
        for (int i = 0; i < slen; ++i) {
            char c = s.charAt(i);
            boolean needEscape = false;
            if (c == ESCAPE_C) {
                if (i + 1 < slen) {
                    char c1 = s.charAt(i + 1);
                    if (i == 0 && c1 == NULL_ESCAPE_C || c1 != StringNames.originalOfReplacement(c1)) {
                        needEscape = true;
                    }
                }
            } else {
                needEscape = StringNames.isDangerous(c);
            }
            if (!needEscape) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(s.length() + 10);
                if (s.charAt(0) != ESCAPE_C && i > 0) {
                    sb.append(NULL_ESCAPE);
                }
                sb.append(s.substring(0, i));
            }
            sb.append(ESCAPE_C);
            sb.append(StringNames.replacementOf(c));
        }
        if (sb != null) {
            return sb.toString();
        }
        return s;
    }

    private static String demangle(String s) {
        StringBuilder sb = null;
        int stringStart = 0;
        if (s.startsWith(NULL_ESCAPE)) {
            stringStart = 2;
        }
        int slen = s.length();
        for (int i = stringStart; i < slen; ++i) {
            char rc;
            char oc;
            char c = s.charAt(i);
            if (c == ESCAPE_C && i + 1 < slen && (oc = StringNames.originalOfReplacement(rc = s.charAt(i + 1))) != rc) {
                if (sb == null) {
                    sb = new StringBuilder(s.length());
                    sb.append(s.substring(stringStart, i));
                }
                ++i;
                c = oc;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb != null) {
            return sb.toString();
        }
        return s.substring(stringStart);
    }

    static boolean isSpecial(char c) {
        if (c >>> 6 < SPECIAL_BITMAP.length) {
            return (SPECIAL_BITMAP[c >>> 6] >> c & 1L) != 0L;
        }
        return false;
    }

    static char replacementOf(char c) {
        if (!StringNames.isSpecial(c)) {
            return c;
        }
        int i = DANGEROUS_CHARS.indexOf(c);
        if (i < 0) {
            return c;
        }
        return REPLACEMENT_CHARS.charAt(i);
    }

    static char originalOfReplacement(char c) {
        if (!StringNames.isSpecial(c)) {
            return c;
        }
        int i = REPLACEMENT_CHARS.indexOf(c);
        if (i < 0) {
            return c;
        }
        return DANGEROUS_CHARS.charAt(i);
    }

    static boolean isDangerous(char c) {
        if (!StringNames.isSpecial(c)) {
            return false;
        }
        if (c == ESCAPE_C) {
            return false;
        }
        return DANGEROUS_CHARS.indexOf(c) >= 0;
    }

    static int indexOfDangerousChar(String s, int from) {
        int slen = s.length();
        for (int i = from; i < slen; ++i) {
            if (!StringNames.isDangerous(s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static void main(String[] av) {
        boolean verbose = false;
        int maxlen = 0;
        while (av.length > 0 && av[0].startsWith("-")) {
            String flag = av[0].intern();
            av = Arrays.copyOfRange(av, 1, av.length);
            if (flag == "-" || flag == "--") break;
            if (flag == "-q") {
                verbose = false;
                continue;
            }
            if (flag == "-v") {
                verbose = true;
                continue;
            }
            if (flag.startsWith("-l")) {
                maxlen = Integer.valueOf(flag.substring(2));
                continue;
            }
            throw new Error("Illegal flag argument: " + flag);
        }
        if (maxlen == 0) {
            int n = maxlen = verbose ? 2 : 4;
        }
        if (verbose) {
            System.out.println("Note: maxlen = " + maxlen);
        }
        switch (av.length) {
            case 0: {
                av = new String[]{DANGEROUS_CHARS.substring(0) + REPLACEMENT_CHARS.substring(0, 1) + NULL_ESCAPE + "x"};
            }
            case 1: {
                char[] cv = av[0].toCharArray();
                av = new String[cv.length];
                int avp = 0;
                for (char c : cv) {
                    String s = String.valueOf(c);
                    if (c == 'x') {
                        s = "foo";
                    }
                    av[avp++] = s;
                }
                break;
            }
        }
        if (verbose) {
            System.out.println("Note: Verbose output mode enabled.  Use '-q' to suppress.");
        }
        Tester t = new Tester();
        t.maxlen = maxlen;
        t.verbose = verbose;
        t.tokens = av;
        t.test("", 0);
    }

    static {
        String SPECIAL = DANGEROUS_CHARS + REPLACEMENT_CHARS + ESCAPE_C;
        for (char c : SPECIAL.toCharArray()) {
            int n = c >>> 6;
            SPECIAL_BITMAP[n] = SPECIAL_BITMAP[n] | 1L << c;
        }
    }

    static class Tester {
        boolean verbose;
        int maxlen;
        Map<String, String> map = new HashMap<String, String>();
        String[] tokens;

        Tester() {
        }

        void test(String stringSoFar, int tokensSoFar) {
            this.test(stringSoFar);
            if (tokensSoFar <= this.maxlen) {
                for (String token : this.tokens) {
                    if (token.length() == 0 || stringSoFar.indexOf(token) != stringSoFar.lastIndexOf(token)) continue;
                    if (token.charAt(0) == ESCAPE_C && token.length() == 1 && this.maxlen < 4) {
                        this.test(stringSoFar + token, tokensSoFar);
                        continue;
                    }
                    if (tokensSoFar >= this.maxlen) continue;
                    this.test(stringSoFar + token, tokensSoFar + 1);
                }
            }
        }

        void test(String s) {
            if (s.length() == 0 && this.maxlen >= 1 && this.maxlen <= 2) {
                return;
            }
            String bn = this.testSourceName(s);
            if (bn == null) {
                return;
            }
            if (bn != s) {
                String bnbn;
                if (this.verbose) {
                    System.out.println(s + " => " + bn + " " + StringNames.toDisplayName(bn));
                }
                if ((bnbn = this.testSourceName(bn)) == null) {
                    return;
                }
                if (this.verbose) {
                    System.out.println(bn + " => " + bnbn + " " + StringNames.toDisplayName(bnbn));
                }
            }
        }

        String testSourceName(String s) {
            if (this.map.containsKey(s)) {
                return null;
            }
            String bn = StringNames.toBytecodeName(s);
            this.map.put(s, bn);
            String sn = StringNames.toSourceName(bn);
            if (!sn.equals(s)) {
                String bad = s + " => " + bn + " != " + sn;
                if (!this.verbose) {
                    throw new Error("Bad mangling: " + bad);
                }
                System.out.println("*** " + bad);
                return null;
            }
            return bn;
        }
    }
}

