/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.compiler;

import java.io.PrintStream;
import org.objectweb.asm.MethodVisitor;
import seph.lang.compiler.StringNames;

public class CompilationHelpers {
    public static String p(String name) {
        return name.replaceAll("\\.", "/");
    }

    public static String p(Class<?> type) {
        return type.getName().replaceAll("\\.", "/");
    }

    public static String c(Class<?> type) {
        if (type.isArray()) {
            if ((type = type.getComponentType()).isPrimitive()) {
                if (type == Byte.TYPE) {
                    return "[B";
                }
                if (type == Boolean.TYPE) {
                    return "[Z";
                }
                if (type == Short.TYPE) {
                    return "[S";
                }
                if (type == Character.TYPE) {
                    return "[C";
                }
                if (type == Integer.TYPE) {
                    return "[I";
                }
                if (type == Float.TYPE) {
                    return "[F";
                }
                if (type == Double.TYPE) {
                    return "[D";
                }
                if (type == Long.TYPE) {
                    return "[J";
                }
                throw new RuntimeException("Unrecognized type in compiler: " + type.getName());
            }
            return "[" + CompilationHelpers.c(type);
        }
        if (type == Void.TYPE) {
            return "V";
        }
        if (type == Boolean.TYPE) {
            return "Z";
        }
        if (type == Integer.TYPE) {
            return "I";
        }
        if (type.isPrimitive()) {
            throw new RuntimeException("Can't handle " + type + " in c yet. Please update me");
        }
        return "L" + CompilationHelpers.p(type) + ";";
    }

    public static String sig(Class<?> ret, Class<?> ... args) {
        StringBuilder result = new StringBuilder("(");
        for (Class<?> clz : args) {
            result.append(CompilationHelpers.c(clz));
        }
        result.append(")");
        result.append(CompilationHelpers.c(ret));
        return result.toString();
    }

    public static void printMessage(String outp, MethodVisitor mv) {
        mv.visitFieldInsn(178, CompilationHelpers.p(System.class), "out", CompilationHelpers.c(PrintStream.class));
        mv.visitLdcInsn(outp);
        mv.visitMethodInsn(182, CompilationHelpers.p(PrintStream.class), "println", CompilationHelpers.sig(Void.TYPE, String.class));
    }

    public static String encode(String name) {
        return StringNames.toBytecodeName(name);
    }

    public static String decode(String name) {
        return StringNames.toSourceName(name);
    }
}

