/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.compiler;

import java.io.PrintWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.util.TraceClassVisitor;
import seph.lang.ControlDefaultBehavior;
import seph.lang.LexicalScope;
import seph.lang.Runtime;
import seph.lang.SThread;
import seph.lang.SephMethodObject;
import seph.lang.SephObject;
import seph.lang.SimpleSephObject;
import seph.lang.Symbol;
import seph.lang.ast.Abstraction;
import seph.lang.ast.Assignment;
import seph.lang.ast.Message;
import seph.lang.ast.Terminator;
import seph.lang.compiler.Bootstrap;
import seph.lang.compiler.CompilationAborted;
import seph.lang.compiler.CompilationHelpers;
import seph.lang.compiler.MethodAdapter;
import seph.lang.persistent.IPersistentCollection;
import seph.lang.persistent.IPersistentList;
import seph.lang.persistent.IPersistentMap;
import seph.lang.persistent.ISeq;
import seph.lang.persistent.PersistentArrayMap;
import seph.lang.persistent.PersistentList;
import seph.lang.persistent.RT;
import seph.lang.persistent.Seqable;

public class AbstractionCompiler {
    public static boolean DO_COMPILE = true;
    public static boolean PRINT_COMPILE = false;
    private static final AtomicInteger compiledCount = new AtomicInteger(0);
    private final Message code;
    private final LexicalScope capture;
    private List<LiteralEntry> literals = new LinkedList<LiteralEntry>();
    private List<ArgumentEntry> arguments = new LinkedList<ArgumentEntry>();
    private Class<?> abstractionClass;
    private final ClassWriter cw;
    public final String className;
    private final List<String> argNames;
    private int messageIndex = 0;
    private boolean printThisClass = false;
    private static final MethodType ARGUMENT_METHOD_TYPE = MethodType.methodType(SephObject.class, LexicalScope.class, SephObject.class, SThread.class, LexicalScope.class, Boolean.TYPE, Boolean.TYPE);
    private static final int METHOD_SCOPE_ARG = 0;
    private static final int RECEIVER = 1;
    private static final int THREAD = 2;
    private static final int SCOPE = 3;
    private static final int ARGUMENTS = 4;
    private static final int SHOULD_EVALUATE = 4;
    private static final int METHOD_SCOPE = 5;
    private static final int SHOULD_EVALUATE_FULLY = 5;

    private static org.objectweb.asm.MethodHandle bootstrapNamed(String name) {
        return new org.objectweb.asm.MethodHandle(6, "seph/lang/compiler/Bootstrap", name, Bootstrap.BOOTSTRAP_SIGNATURE_DESC);
    }

    private AbstractionCompiler(Message code, List<String> argNames, LexicalScope capture) {
        this.code = code;
        this.argNames = argNames;
        this.capture = capture;
        this.className = "seph$gen$abstraction$" + compiledCount.getAndIncrement();
        this.cw = new ClassWriter(2);
    }

    private void generateAbstractionClass() {
        this.cw.visit(51, 1, CompilationHelpers.p(this.className), null, CompilationHelpers.p(SimpleSephObject.class), new String[0]);
        this.activateWithMethod();
        this.abstractionFields();
        this.constructor(SimpleSephObject.class);
        this.cw.visitEnd();
        byte[] classBytes = this.cw.toByteArray();
        if (this.printThisClass || PRINT_COMPILE) {
            new ClassReader(classBytes).accept(new TraceClassVisitor(new PrintWriter(System.err)), 0);
        }
        try {
            this.abstractionClass = Runtime.LOADER.defineClass(this.className, classBytes);
        }
        catch (Throwable e) {
            new ClassReader(classBytes).accept(new TraceClassVisitor(new PrintWriter(System.err)), 0);
            throw new RuntimeException(e);
        }
    }

    private SephObject instantiateAbstraction() {
        try {
            return (SephObject)this.abstractionClass.getConstructor(LexicalScope.class).newInstance(this.capture);
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            throw new CompilationAborted("An error was encountered during compilation");
        }
    }

    private void setStaticValues() {
        try {
            Field f = this.abstractionClass.getDeclaredField("fullMsg");
            f.setAccessible(true);
            f.set(null, this.code);
            for (LiteralEntry le : this.literals) {
                f = this.abstractionClass.getDeclaredField(le.name);
                f.setAccessible(true);
                f.set(null, le.code.literal());
            }
            for (ArgumentEntry ae : this.arguments) {
                f = this.abstractionClass.getDeclaredField(ae.codeName);
                f.setAccessible(true);
                f.set(null, ae.argumentCode);
                MethodHandle h = Bootstrap.findStatic(this.abstractionClass, ae.methodName, ARGUMENT_METHOD_TYPE);
                f = this.abstractionClass.getDeclaredField(ae.handleName);
                f.setAccessible(true);
                f.set(null, h);
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            throw new CompilationAborted("An error was encountered during compilation");
        }
    }

    private void abstractionFields() {
        this.cw.visitField(10, "fullMsg", CompilationHelpers.c(Message.class), null, null);
        this.cw.visitField(18, "capture", CompilationHelpers.c(LexicalScope.class), null, null);
    }

    private void constructor(Class<?> superClass) {
        MethodAdapter ma = new MethodAdapter(this.cw.visitMethod(1, "<init>", CompilationHelpers.sig(Void.TYPE, LexicalScope.class), null, null));
        ma.loadThis();
        ma.dup();
        ma.dup();
        ma.getStatic(PersistentArrayMap.class, "EMPTY", PersistentArrayMap.class);
        ma.getStatic(SimpleSephObject.class, "activatable", Symbol.class);
        ma.getStatic(Runtime.class, "TRUE", SephObject.class);
        ma.virtualCall(PersistentArrayMap.class, "associate", IPersistentMap.class, Object.class, Object.class);
        ma.init(superClass, Void.TYPE, IPersistentMap.class);
        ma.loadLocal(1);
        ma.putField(this.className, "capture", LexicalScope.class);
        ma.ret();
        ma.end();
    }

    public static SephObject compile(Message code, List<String> argNames, LexicalScope capture) {
        if (!DO_COMPILE) {
            throw new CompilationAborted("Compilation disabled...");
        }
        AbstractionCompiler c = new AbstractionCompiler(code, argNames, capture);
        c.generateAbstractionClass();
        c.setStaticValues();
        return c.instantiateAbstraction();
    }

    public static String compile(Message code, List<String> argNames) {
        if (!DO_COMPILE) {
            throw new CompilationAborted("Compilation disabled...");
        }
        AbstractionCompiler c = new AbstractionCompiler(code, argNames, null);
        c.generateAbstractionClass();
        c.setStaticValues();
        return c.className;
    }

    public static SephObject compile(ISeq argumentsAndCode, LexicalScope capture) {
        ArrayList<String> argNames = new ArrayList<String>();
        if (argumentsAndCode != null) {
            while (RT.next(argumentsAndCode) != null) {
                argNames.add(((Message)RT.first(argumentsAndCode)).name());
                argumentsAndCode = RT.next(argumentsAndCode);
            }
        }
        return AbstractionCompiler.compile((Message)RT.first(argumentsAndCode), argNames, capture);
    }

    public static String compile(ISeq argumentsAndCode) {
        ArrayList<String> argNames = new ArrayList<String>();
        if (argumentsAndCode != null) {
            while (RT.next(argumentsAndCode) != null) {
                argNames.add(((Message)RT.first(argumentsAndCode)).name());
                argumentsAndCode = RT.next(argumentsAndCode);
            }
        }
        return AbstractionCompiler.compile((Message)RT.first(argumentsAndCode), argNames);
    }

    private void compileLiteral(MethodAdapter ma, Message current) {
        int position = this.literals.size();
        LiteralEntry le = new LiteralEntry("literal" + position, current, position);
        this.literals.add(le);
        this.cw.visitField(10, le.name, CompilationHelpers.c(SephObject.class), null, null);
        ma.pop();
        ma.getStatic(this.className, le.name, SephObject.class);
    }

    private void compileTerminator(MethodAdapter ma, Message current) {
        if (current.next() != null && !(current.next() instanceof Terminator)) {
            ma.pop();
            ma.loadLocal(1);
        }
    }

    private void compileArgument(Message argument, int currentMessageIndex, int argIndex, List<ArgumentEntry> currentArguments) {
        Message current;
        String codeName = "code_arg_" + currentMessageIndex + "_" + argIndex;
        String handleName = "handle_arg_" + currentMessageIndex + "_" + argIndex;
        String methodName = "argument_" + currentMessageIndex + "_" + argIndex;
        ArgumentEntry ae = new ArgumentEntry(codeName, handleName, methodName, argument);
        this.arguments.add(ae);
        currentArguments.add(ae);
        this.cw.visitField(10, codeName, CompilationHelpers.c(SephObject.class), null, null);
        this.cw.visitField(10, handleName, CompilationHelpers.c(MethodHandle.class), null, null);
        MethodAdapter ma = new MethodAdapter(this.cw.visitMethod(9, methodName, CompilationHelpers.sig(SephObject.class, LexicalScope.class, SephObject.class, SThread.class, LexicalScope.class, Boolean.TYPE, Boolean.TYPE), null, null));
        ma.loadLocalInt(4);
        ma.zero();
        Label els = new Label();
        ma.ifNotEqual(els);
        ma.getStatic(this.className, codeName, SephObject.class);
        ma.retValue();
        ma.label(els);
        Message last = this.findLast(current);
        ma.loadLocal(1);
        boolean first = true;
        for (current = argument; current != null; current = current.next()) {
            if (current.isLiteral()) {
                this.compileLiteral(ma, current);
                first = false;
                continue;
            }
            if (current instanceof Terminator) {
                this.compileTerminator(ma, current);
                first = true;
                continue;
            }
            if (current instanceof Abstraction) {
                ma.pop();
                String newName = AbstractionCompiler.compile(RT.seq(current.arguments()));
                ma.create(newName);
                ma.dup();
                ma.loadLocal(0);
                ma.init(newName, Void.TYPE, LexicalScope.class);
                first = false;
                continue;
            }
            if (current instanceof Assignment) {
                first = false;
                throw new CompilationAborted("No support for compiling assignment");
            }
            this.compileMessageSend(ma, current, false, -1, first, last);
            first = false;
        }
        ma.retValue();
        ma.end();
    }

    private int compileArguments(MethodAdapter ma, IPersistentList arguments, boolean activateWith, int plusArity) {
        int num = 0;
        int currentMessageIndex = this.messageIndex++;
        int arity = RT.count(arguments);
        LinkedList<ArgumentEntry> currentArguments = new LinkedList<ArgumentEntry>();
        for (ISeq seq = arguments.seq(); seq != null; seq = seq.next()) {
            this.compileArgument((Message)seq.first(), currentMessageIndex, num++, currentArguments);
        }
        if (arity > 5) {
            ma.getStatic(PersistentList.class, "EMPTY", "Lseph/lang/persistent/PersistentList$EmptyList;");
            Iterator<ArgumentEntry> iter = currentArguments.descendingIterator();
            while (iter.hasNext()) {
                ArgumentEntry ae = iter.next();
                ma.getStatic(this.className, ae.handleName, MethodHandle.class);
                if (activateWith) {
                    ma.loadLocal(5 + plusArity);
                } else {
                    ma.loadLocal(0);
                }
                ma.virtualCall(MethodHandle.class, "bindTo", MethodHandle.class, Object.class);
                ma.loadLocal(1);
                ma.virtualCall(MethodHandle.class, "bindTo", MethodHandle.class, Object.class);
                ma.interfaceCall(IPersistentCollection.class, "cons", IPersistentCollection.class, Object.class);
            }
        } else {
            for (ArgumentEntry ae : currentArguments) {
                ma.getStatic(this.className, ae.handleName, MethodHandle.class);
                if (activateWith) {
                    ma.loadLocal(5 + plusArity);
                } else {
                    ma.loadLocal(0);
                }
                ma.virtualCall(MethodHandle.class, "bindTo", MethodHandle.class, Object.class);
                ma.loadLocal(1);
                ma.virtualCall(MethodHandle.class, "bindTo", MethodHandle.class, Object.class);
            }
        }
        return arity;
    }

    private void pumpTailCall(MethodAdapter ma) {
        Label done = new Label();
        Label loop = new Label();
        ma.label(loop);
        ma.dup();
        if (SThread.TAIL_MARKER == null) {
            ma.ifNonNull(done);
        } else {
            ma.getStatic(SThread.class, "TAIL_MARKER", SephObject.class);
            ma.ifRefNotEqual(done);
        }
        ma.pop();
        ma.loadLocal(2);
        ma.dup();
        ma.getField(SThread.class, "tail", MethodHandle.class);
        ma.swap();
        ma.nul();
        ma.putField(SThread.class, "tail", MethodHandle.class);
        ma.virtualCall(MethodHandle.class, "invokeExact", SephObject.class, new Class[0]);
        ma.jump(loop);
        ma.label(done);
    }

    private String sigFor(int arity) {
        switch (arity) {
            case 0: {
                return CompilationHelpers.sig(SephObject.class, SephObject.class, SThread.class, LexicalScope.class);
            }
            case 1: {
                return CompilationHelpers.sig(SephObject.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class);
            }
            case 2: {
                return CompilationHelpers.sig(SephObject.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class, MethodHandle.class);
            }
            case 3: {
                return CompilationHelpers.sig(SephObject.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class, MethodHandle.class, MethodHandle.class);
            }
            case 4: {
                return CompilationHelpers.sig(SephObject.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, MethodHandle.class);
            }
            case 5: {
                return CompilationHelpers.sig(SephObject.class, SephObject.class, SThread.class, LexicalScope.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, MethodHandle.class);
            }
        }
        return CompilationHelpers.sig(SephObject.class, SephObject.class, SThread.class, LexicalScope.class, IPersistentList.class);
    }

    private void compileMessageSend(MethodAdapter ma, Message current, boolean activateWith, int plusArity, boolean first, Message last) {
        ma.loadLocal(2);
        if (activateWith) {
            ma.loadLocal(5 + plusArity);
        } else {
            ma.loadLocal(0);
        }
        int arity = this.compileArguments(ma, current.arguments(), activateWith, plusArity);
        String possibleIntrinsic = "";
        if (current.name().equals("true")) {
            possibleIntrinsic = "_intrinsic_true";
        } else if (current.name().equals("false")) {
            possibleIntrinsic = "_intrinsic_false";
        } else if (current.name().equals("nil")) {
            possibleIntrinsic = "_intrinsic_nil";
        } else if (current.name().equals("if")) {
            possibleIntrinsic = "_intrinsic_if";
        }
        String bootstrapName = "basicSephBootstrap";
        boolean fullPumping = false;
        if (first) {
            if (current == last) {
                bootstrapName = "noReceiverTailCallSephBootstrap";
                fullPumping = true;
            } else {
                bootstrapName = "noReceiverSephBootstrap";
                fullPumping = false;
            }
        } else if (current == last) {
            bootstrapName = "tailCallSephBootstrap";
            fullPumping = true;
        }
        ma.dynamicCall(CompilationHelpers.encode(current.name()), this.sigFor(arity), AbstractionCompiler.bootstrapNamed(bootstrapName + possibleIntrinsic));
        if (fullPumping) {
            if (!activateWith) {
                Label noPump = new Label();
                ma.loadLocalInt(5);
                ma.zero();
                ma.ifEqual(noPump);
                this.pumpTailCall(ma);
                ma.label(noPump);
            }
        } else {
            this.pumpTailCall(ma);
        }
    }

    private Message findLast(Message code) {
        Message lastReal = null;
        for (Message current = code; current != null; current = current.next()) {
            if (current instanceof Terminator) continue;
            lastReal = current;
        }
        return lastReal;
    }

    private void activateWithBody(MethodAdapter ma, int plusArity) {
        Message current;
        boolean first = true;
        Message last = this.findLast(current);
        ma.loadLocal(1);
        for (current = this.code; current != null; current = current.next()) {
            if (current.isLiteral()) {
                this.compileLiteral(ma, current);
                first = false;
                continue;
            }
            if (current instanceof Terminator) {
                this.compileTerminator(ma, current);
                first = true;
                continue;
            }
            if (current instanceof Abstraction) {
                ma.pop();
                String newName = AbstractionCompiler.compile(RT.seq(current.arguments()));
                ma.create(newName);
                ma.dup();
                ma.loadLocal(5 + plusArity);
                ma.init(newName, Void.TYPE, LexicalScope.class);
                first = false;
                continue;
            }
            if (current instanceof Assignment) {
                first = false;
                throw new CompilationAborted("No support for compiling assignment");
            }
            this.compileMessageSend(ma, current, true, plusArity, first, last);
            first = false;
        }
        ma.retValue();
        ma.end();
    }

    private void activateWithMethodRealArity(int arity) {
        MethodAdapter ma = new MethodAdapter(this.cw.visitMethod(1, "activateWith", this.sigFor(arity), null, null));
        ma.loadThis();
        ma.getField(this.className, "capture", LexicalScope.class);
        ma.loadLocal(1);
        ma.virtualCall(LexicalScope.class, "newScopeWith", LexicalScope.class, SephObject.class);
        ma.storeLocal(4 + arity);
        for (int i = 0; i < arity; ++i) {
            String name = this.argNames.get(i);
            ma.loadLocal(4 + arity);
            ma.load(name);
            ma.loadLocal(4 + i);
            ma.loadLocal(3);
            ma.loadLocal(2);
            ma.one();
            ma.staticCall(ControlDefaultBehavior.class, "evaluateArgument", SephObject.class, Object.class, LexicalScope.class, SThread.class, Boolean.TYPE);
            ma.virtualCall(LexicalScope.class, "directlyAssign", Void.TYPE, String.class, SephObject.class);
        }
        this.activateWithBody(ma, arity - 1);
    }

    private void activateWithMethodCollectedArgs() {
        MethodAdapter ma = new MethodAdapter(this.cw.visitMethod(1, "activateWith", CompilationHelpers.sig(SephObject.class, SephObject.class, SThread.class, LexicalScope.class, IPersistentList.class), null, null));
        ma.loadThis();
        ma.getField(this.className, "capture", LexicalScope.class);
        ma.loadLocal(1);
        ma.virtualCall(LexicalScope.class, "newScopeWith", LexicalScope.class, SephObject.class);
        ma.loadLocal(5);
        ma.loadLocal(4);
        ma.interfaceCall(Seqable.class, "seq", ISeq.class, new Class[0]);
        for (String arg : this.argNames) {
            ma.dup();
            ma.loadLocal(5);
            ma.swap();
            ma.interfaceCall(ISeq.class, "first", Object.class, new Class[0]);
            ma.loadLocal(3);
            ma.loadLocal(2);
            ma.one();
            ma.staticCall(ControlDefaultBehavior.class, "evaluateArgument", SephObject.class, Object.class, LexicalScope.class, SThread.class, Boolean.TYPE);
            ma.load(arg);
            ma.swap();
            ma.virtualCall(LexicalScope.class, "directlyAssign", Void.TYPE, String.class, SephObject.class);
            ma.interfaceCall(ISeq.class, "next", ISeq.class, new Class[0]);
        }
        ma.pop();
        this.activateWithBody(ma, 0);
    }

    private void activateWithMethodPassArgs(int arity) {
        MethodAdapter ma = new MethodAdapter(this.cw.visitMethod(1, "activateWith", CompilationHelpers.sig(SephObject.class, SephObject.class, SThread.class, LexicalScope.class, IPersistentList.class), null, null));
        ma.loadThis();
        ma.loadLocal(1);
        ma.loadLocal(2);
        ma.loadLocal(3);
        if (arity > 0) {
            ma.loadLocal(4);
            ma.interfaceCall(Seqable.class, "seq", ISeq.class, new Class[0]);
            for (int i = 0; i < arity; ++i) {
                ma.dup();
                ma.interfaceCall(ISeq.class, "first", Object.class, new Class[0]);
                ma.staticCall(SephMethodObject.class, "ensureMH", MethodHandle.class, Object.class);
                ma.swap();
                ma.interfaceCall(ISeq.class, "next", ISeq.class, new Class[0]);
            }
            ma.pop();
        }
        ma.virtualCall(this.className, "activateWith", this.sigFor(arity));
        ma.retValue();
        ma.end();
    }

    private void activateWithMethod() {
        int arity = this.argNames.size();
        if (arity <= 5) {
            this.activateWithMethodRealArity(arity);
            this.activateWithMethodPassArgs(arity);
        } else {
            this.activateWithMethodCollectedArgs();
        }
    }

    private static class ArgumentEntry {
        public final String codeName;
        public final String handleName;
        public final String methodName;
        public final Message argumentCode;

        public ArgumentEntry(String codeName, String handleName, String methodName, Message argumentCode) {
            this.codeName = codeName;
            this.handleName = handleName;
            this.methodName = methodName;
            this.argumentCode = argumentCode;
        }
    }

    private static class LiteralEntry {
        public final String name;
        public final Message code;
        public final int position;

        public LiteralEntry(String name, Message code, int position) {
            this.name = name;
            this.code = code;
            this.position = position;
        }
    }
}

