/*
 * Decompiled with CFR 0.152.
 */
package seph.lang.ast;

import java.lang.invoke.MethodHandle;
import seph.lang.LexicalScope;
import seph.lang.SThread;
import seph.lang.SephObject;
import seph.lang.ast.Message;
import seph.lang.ast.NamedMessage;
import seph.lang.persistent.IPersistentList;

public final class LiteralMessage
implements Message,
SephObject {
    private final SephObject literal;
    private final Message next;
    private final String filename;
    private final int line;
    private final int position;

    public LiteralMessage(SephObject literal, Message next, String filename, int line, int position) {
        this.literal = literal;
        this.next = next;
        this.filename = filename;
        this.line = line;
        this.position = position;
    }

    @Override
    public String name() {
        return "<literal:" + this.literal.getClass().getName() + ">";
    }

    @Override
    public IPersistentList arguments() {
        return NamedMessage.NO_ARGUMENTS;
    }

    @Override
    public Message next() {
        return this.next;
    }

    @Override
    public Message withNext(Message newNext) {
        return new LiteralMessage(this.literal, newNext, this.filename, this.line, this.position);
    }

    @Override
    public Message withArguments(IPersistentList args) {
        return this;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public SephObject literal() {
        return this.literal;
    }

    @Override
    public String filename() {
        return this.filename;
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public int position() {
        return this.position;
    }

    public String toString() {
        return this.literal + (this.next == null ? "" : " " + this.next.toString());
    }

    public boolean equals(Object other) {
        boolean ret;
        boolean bl = ret = this == other;
        if (!ret && other != null && other instanceof LiteralMessage) {
            LiteralMessage lm = (LiteralMessage)other;
            ret = (this.literal == null ? lm.literal == null : this.literal.equals(lm.literal)) && (this.next == null ? lm.next == null : this.next.equals(lm.next));
        }
        return ret;
    }

    @Override
    public SephObject sendTo(SThread thread, LexicalScope scope, SephObject receiver, boolean first) {
        return this.literal;
    }

    @Override
    public SephObject go(SThread thread, LexicalScope scope, SephObject receiver, boolean first) {
        return this.literal;
    }

    @Override
    public SephObject get(String cellName) {
        return null;
    }

    @Override
    public boolean isActivatable() {
        return false;
    }

    @Override
    public boolean isTrue() {
        return true;
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, IPersistentList arguments) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, SephObject arg0) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, SephObject arg0, SephObject arg1) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, SephObject arg0, SephObject arg1, SephObject arg2) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, SephObject arg0, SephObject arg1, SephObject arg2, SephObject arg3) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, SephObject arg0, SephObject arg1, SephObject arg2, SephObject arg3, SephObject arg4) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3, MethodHandle arg4) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public Object identity() {
        return this;
    }
}

