/*
 * Decompiled with CFR 0.152.
 */
package seph.lang;

import gnu.math.Numeric;
import seph.lang.Runtime;
import seph.lang.SephKind;
import seph.lang.SephMethod;
import seph.lang.SephObject;

@SephKind(parents={"Something"})
public class Number {
    @SephMethod(name={"+"})
    public static final SephObject plus(SephObject receiver, SephObject addend) {
        return ((Numeric)receiver).add(addend);
    }

    @SephMethod(name={"-"})
    public static final SephObject minus(SephObject receiver, SephObject subtrahend) {
        return ((Numeric)receiver).sub(subtrahend);
    }

    @SephMethod(name={"*"})
    public static final SephObject times(SephObject receiver, SephObject multiplicand) {
        return ((Numeric)receiver).mul(multiplicand);
    }

    @SephMethod(name={"<"})
    public static final SephObject lt(SephObject receiver, SephObject other) {
        switch (((Numeric)receiver).compare(other)) {
            case -3: 
            case -2: {
                return Runtime.NIL;
            }
            case -1: {
                return Runtime.TRUE;
            }
        }
        return Runtime.FALSE;
    }
}

