/*
 * Decompiled with CFR 0.152.
 */
package seph.lang;

import java.util.Map;
import seph.lang.Runtime;
import seph.lang.SThread;
import seph.lang.SephObject;
import seph.lang.ast.Message;
import seph.lang.interpreter.MessageInterpreter;
import seph.lang.persistent.IPersistentMap;
import seph.lang.persistent.ISeq;
import seph.lang.persistent.PersistentArrayMap;
import seph.lang.persistent.RT;

public class LexicalScope {
    public static final LexicalScope ROOT = new LexicalScope(null, null){

        @Override
        public LexicalScope find(String name, LexicalScope def) {
            return def;
        }

        @Override
        public SephObject get(String name) {
            return null;
        }

        @Override
        public int version() {
            return 13;
        }
    };
    private final MessageInterpreter currentInterpreter;
    private final LexicalScope parent;
    public final Runtime runtime;
    private int version = 1;
    private IPersistentMap values = PersistentArrayMap.EMPTY;

    public int version() {
        return this.version + 3 * this.parent.version();
    }

    public LexicalScope(MessageInterpreter currentInterpreter, Runtime runtime) {
        this(currentInterpreter, ROOT, runtime);
    }

    public LexicalScope(MessageInterpreter currentInterpreter, LexicalScope parent, Runtime runtime) {
        this.runtime = runtime;
        this.currentInterpreter = currentInterpreter;
        this.parent = parent;
    }

    public LexicalScope newScopeWith(SephObject ground) {
        return this.currentInterpreter.newScope(ground);
    }

    public SephObject evaluate(SThread thread, Message message) {
        return (SephObject)this.currentInterpreter.evaluate(thread, message);
    }

    public SephObject evaluateFully(SThread thread, Message message) {
        return (SephObject)this.currentInterpreter.evaluateFully(thread, message);
    }

    public LexicalScope find(String name, LexicalScope def) {
        if (this.values.containsKey(name)) {
            return this;
        }
        return this.parent.find(name, def);
    }

    public void directlyAssign(String name, SephObject value) {
        ++this.version;
        this.runtime.checkIntrinsicAssignment(name);
        this.values = this.values.associate(name, value);
    }

    public void assign(String name, SephObject value) {
        LexicalScope place = this.find(name, this);
        place.directlyAssign(name, value);
    }

    public SephObject get(String name) {
        SephObject result = (SephObject)this.values.valueAt(name);
        if (null == result) {
            result = this.parent.get(name);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        ISeq seq = RT.seq(this.values);
        String sep = "";
        while (RT.next(seq) != null) {
            Map.Entry me = (Map.Entry)RT.first(seq);
            sb.append(me.getKey()).append(" => ").append(me.getValue()).append(sep);
            sep = ", ";
            seq = RT.next(seq);
        }
        sb.append("}");
        if (this.parent != ROOT) {
            sb.append("(").append(this.parent).append(")");
        }
        return sb.toString();
    }
}

