/*
 * Decompiled with CFR 0.152.
 */
package org.jregex;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.jregex.MatchResult;
import org.jregex.Matcher;
import org.jregex.Pattern;
import org.jregex.PerlSubstitution;
import org.jregex.Substitution;
import org.jregex.TextBuffer;

public class Replacer {
    private Pattern pattern;
    private Substitution substitution;

    public Replacer(Pattern pattern, Substitution substitution) {
        this.pattern = pattern;
        this.substitution = substitution;
    }

    public Replacer(Pattern pattern, String substitution) {
        this(pattern, substitution, true);
    }

    public Replacer(Pattern pattern, String substitution, boolean isPerlExpr) {
        this.pattern = pattern;
        this.substitution = isPerlExpr ? new PerlSubstitution(substitution) : new DummySubstitution(substitution);
    }

    public void setSubstitution(String s, boolean isPerlExpr) {
        this.substitution = isPerlExpr ? new PerlSubstitution(s) : new DummySubstitution(s);
    }

    public String replace(String text) {
        TextBuffer tb = Replacer.wrap(new StringBuffer(text.length()));
        Replacer.replace(this.pattern.matcher(text), this.substitution, tb);
        return tb.toString();
    }

    public String replaceFirst(String text) {
        TextBuffer tb = Replacer.wrap(new StringBuffer(text.length()));
        Replacer.replaceFirst(this.pattern.matcher(text), this.substitution, tb);
        return tb.toString();
    }

    public String replace(char[] chars, int off, int len) {
        TextBuffer tb = Replacer.wrap(new StringBuffer(len));
        Replacer.replace(this.pattern.matcher(chars, off, len), this.substitution, tb);
        return tb.toString();
    }

    public String replaceFirst(char[] chars, int off, int len) {
        TextBuffer tb = Replacer.wrap(new StringBuffer(len));
        Replacer.replaceFirst(this.pattern.matcher(chars, off, len), this.substitution, tb);
        return tb.toString();
    }

    public String replace(MatchResult res, int group) {
        TextBuffer tb = Replacer.wrap(new StringBuffer());
        Replacer.replace(this.pattern.matcher(res, group), this.substitution, tb);
        return tb.toString();
    }

    public String replaceFirst(MatchResult res, int group) {
        TextBuffer tb = Replacer.wrap(new StringBuffer());
        Replacer.replaceFirst(this.pattern.matcher(res, group), this.substitution, tb);
        return tb.toString();
    }

    public String replace(Reader text, int length) throws IOException {
        TextBuffer tb = Replacer.wrap(new StringBuffer(length >= 0 ? length : 0));
        Replacer.replace(this.pattern.matcher(text, length), this.substitution, tb);
        return tb.toString();
    }

    public String replaceFirst(Reader text, int length) throws IOException {
        TextBuffer tb = Replacer.wrap(new StringBuffer(length >= 0 ? length : 0));
        Replacer.replaceFirst(this.pattern.matcher(text, length), this.substitution, tb);
        return tb.toString();
    }

    public int replace(String text, StringBuffer sb) {
        return Replacer.replace(this.pattern.matcher(text), this.substitution, Replacer.wrap(sb));
    }

    public int replaceFirst(String text, StringBuffer sb) {
        return Replacer.replaceFirst(this.pattern.matcher(text), this.substitution, Replacer.wrap(sb));
    }

    public int replace(char[] chars, int off, int len, StringBuffer sb) {
        return this.replace(chars, off, len, Replacer.wrap(sb));
    }

    public int replaceFirst(char[] chars, int off, int len, StringBuffer sb) {
        return this.replaceFirst(chars, off, len, Replacer.wrap(sb));
    }

    public int replace(MatchResult res, int group, StringBuffer sb) {
        return this.replace(res, group, Replacer.wrap(sb));
    }

    public int replaceFirst(MatchResult res, int group, StringBuffer sb) {
        return this.replaceFirst(res, group, Replacer.wrap(sb));
    }

    public int replace(MatchResult res, String groupName, StringBuffer sb) {
        return this.replace(res, groupName, Replacer.wrap(sb));
    }

    public int replaceFirst(MatchResult res, String groupName, StringBuffer sb) {
        return this.replaceFirst(res, groupName, Replacer.wrap(sb));
    }

    public int replace(Reader text, int length, StringBuffer sb) throws IOException {
        return this.replace(text, length, Replacer.wrap(sb));
    }

    public int replaceFirst(Reader text, int length, StringBuffer sb) throws IOException {
        return this.replaceFirst(text, length, Replacer.wrap(sb));
    }

    public int replace(String text, TextBuffer dest) {
        return Replacer.replace(this.pattern.matcher(text), this.substitution, dest);
    }

    public int replaceFirst(String text, TextBuffer dest) {
        return Replacer.replaceFirst(this.pattern.matcher(text), this.substitution, dest);
    }

    public int replace(char[] chars, int off, int len, TextBuffer dest) {
        return Replacer.replace(this.pattern.matcher(chars, off, len), this.substitution, dest);
    }

    public int replaceFirst(char[] chars, int off, int len, TextBuffer dest) {
        return Replacer.replaceFirst(this.pattern.matcher(chars, off, len), this.substitution, dest);
    }

    public int replace(MatchResult res, int group, TextBuffer dest) {
        return Replacer.replace(this.pattern.matcher(res, group), this.substitution, dest);
    }

    public int replaceFirst(MatchResult res, int group, TextBuffer dest) {
        return Replacer.replaceFirst(this.pattern.matcher(res, group), this.substitution, dest);
    }

    public int replace(MatchResult res, String groupName, TextBuffer dest) {
        return Replacer.replace(this.pattern.matcher(res, groupName), this.substitution, dest);
    }

    public int replaceFirst(MatchResult res, String groupName, TextBuffer dest) {
        return Replacer.replaceFirst(this.pattern.matcher(res, groupName), this.substitution, dest);
    }

    public int replace(Reader text, int length, TextBuffer dest) throws IOException {
        return Replacer.replace(this.pattern.matcher(text, length), this.substitution, dest);
    }

    public int replaceFirst(Reader text, int length, TextBuffer dest) throws IOException {
        return Replacer.replaceFirst(this.pattern.matcher(text, length), this.substitution, dest);
    }

    public static int replace(Matcher m, Substitution substitution, TextBuffer dest) {
        boolean firstPass = true;
        int c = 0;
        while (m.find()) {
            if (m.end() == 0 && !firstPass) continue;
            if (m.start() > 0) {
                m.getGroup(-1, dest);
            }
            substitution.appendSubstitution(m, dest);
            ++c;
            m.setTarget(m, -2);
            firstPass = false;
        }
        m.getGroup(-3, dest);
        return c;
    }

    public static int replaceFirst(Matcher m, Substitution substitution, TextBuffer dest) {
        int c = 0;
        if (m.find()) {
            if (m.start() > 0) {
                m.getGroup(-1, dest);
            }
            substitution.appendSubstitution(m, dest);
            ++c;
            m.setTarget(m, -2);
        }
        m.getGroup(-3, dest);
        return c;
    }

    public static int replace(Matcher m, Substitution substitution, Writer out) throws IOException {
        try {
            return Replacer.replace(m, substitution, Replacer.wrap(out));
        }
        catch (WriteException e) {
            throw e.reason;
        }
    }

    public static int replaceFirst(Matcher m, Substitution substitution, Writer out) throws IOException {
        try {
            return Replacer.replaceFirst(m, substitution, Replacer.wrap(out));
        }
        catch (WriteException e) {
            throw e.reason;
        }
    }

    public void replace(String text, Writer out) throws IOException {
        Replacer.replace(this.pattern.matcher(text), this.substitution, out);
    }

    public void replaceFirst(String text, Writer out) throws IOException {
        Replacer.replaceFirst(this.pattern.matcher(text), this.substitution, out);
    }

    public void replace(char[] chars, int off, int len, Writer out) throws IOException {
        Replacer.replace(this.pattern.matcher(chars, off, len), this.substitution, out);
    }

    public void replaceFirst(char[] chars, int off, int len, Writer out) throws IOException {
        Replacer.replaceFirst(this.pattern.matcher(chars, off, len), this.substitution, out);
    }

    public void replace(MatchResult res, int group, Writer out) throws IOException {
        Replacer.replace(this.pattern.matcher(res, group), this.substitution, out);
    }

    public void replaceFirst(MatchResult res, int group, Writer out) throws IOException {
        Replacer.replaceFirst(this.pattern.matcher(res, group), this.substitution, out);
    }

    public void replace(MatchResult res, String groupName, Writer out) throws IOException {
        Replacer.replace(this.pattern.matcher(res, groupName), this.substitution, out);
    }

    public void replaceFirst(MatchResult res, String groupName, Writer out) throws IOException {
        Replacer.replaceFirst(this.pattern.matcher(res, groupName), this.substitution, out);
    }

    public void replace(Reader in, int length, Writer out) throws IOException {
        Replacer.replace(this.pattern.matcher(in, length), this.substitution, out);
    }

    public void replaceFirst(Reader in, int length, Writer out) throws IOException {
        Replacer.replaceFirst(this.pattern.matcher(in, length), this.substitution, out);
    }

    public static TextBuffer wrap(final StringBuffer sb) {
        return new TextBuffer(){

            @Override
            public void append(char c) {
                sb.append(c);
            }

            @Override
            public void append(char[] chars, int start, int len) {
                sb.append(chars, start, len);
            }

            @Override
            public void append(String s) {
                sb.append(s);
            }

            public String toString() {
                return sb.toString();
            }
        };
    }

    public static TextBuffer wrap(final Writer writer) {
        return new TextBuffer(){

            @Override
            public void append(char c) {
                try {
                    writer.write(c);
                }
                catch (IOException e) {
                    throw new WriteException(e);
                }
            }

            @Override
            public void append(char[] chars, int off, int len) {
                try {
                    writer.write(chars, off, len);
                }
                catch (IOException e) {
                    throw new WriteException(e);
                }
            }

            @Override
            public void append(String s) {
                try {
                    writer.write(s);
                }
                catch (IOException e) {
                    throw new WriteException(e);
                }
            }
        };
    }

    private static class WriteException
    extends RuntimeException {
        IOException reason;

        WriteException(IOException io) {
            this.reason = io;
        }
    }

    private static class DummySubstitution
    implements Substitution {
        String str;

        DummySubstitution(String s) {
            this.str = s;
        }

        @Override
        public void appendSubstitution(MatchResult match, TextBuffer res) {
            if (this.str != null) {
                res.append(this.str);
            }
        }
    }
}

