/*
 * Decompiled with CFR 0.152.
 */
package org.jregex;

import org.jregex.MatchResult;
import org.jregex.Matcher;
import org.jregex.Pattern;
import org.jregex.PatternSyntaxException;
import org.jregex.Replacer;
import org.jregex.Substitution;
import org.jregex.TextBuffer;

public class PerlSubstitution
implements Substitution {
    private static Pattern refPtn;
    private static int NAME_ID;
    private static int ESC_ID;
    private static final String groupRef = "\\$(?:\\{({=name}\\w+)\\}|({=name}\\d+|&))|\\\\({esc}.)";
    private Element queueEntry;

    public PerlSubstitution(String s) {
        Matcher refMatcher = new Matcher(refPtn);
        refMatcher.setTarget(s);
        this.queueEntry = PerlSubstitution.makeQueue(refMatcher);
    }

    public String value(MatchResult mr) {
        TextBuffer dest = Replacer.wrap(new StringBuffer(mr.length()));
        this.appendSubstitution(mr, dest);
        return dest.toString();
    }

    private static Element makeQueue(Matcher refMatcher) {
        if (refMatcher.find()) {
            char c;
            Element element = refMatcher.isCaptured(NAME_ID) ? ((c = refMatcher.charAt(0, NAME_ID)) == '&' ? new IntRefHandler(refMatcher.prefix(), new Integer(0)) : (Character.isDigit(c) ? new IntRefHandler(refMatcher.prefix(), new Integer(refMatcher.group(NAME_ID))) : new StringRefHandler(refMatcher.prefix(), refMatcher.group(NAME_ID)))) : new PlainElement(refMatcher.prefix(), refMatcher.group(ESC_ID));
            refMatcher.setTarget(refMatcher, -2);
            element.next = PerlSubstitution.makeQueue(refMatcher);
            return element;
        }
        return new PlainElement(refMatcher.target());
    }

    @Override
    public void appendSubstitution(MatchResult match, TextBuffer dest) {
        Element element = this.queueEntry;
        while (element != null) {
            element.append(match, dest);
            element = element.next;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Element element = this.queueEntry;
        while (element != null) {
            sb.append(element.toString());
            element = element.next;
        }
        return sb.toString();
    }

    static {
        try {
            refPtn = new Pattern(groupRef);
            NAME_ID = refPtn.groupId("name");
            ESC_ID = refPtn.groupId("esc");
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
        }
    }

    private static class StringRefHandler
    extends Element {
        private String index;

        StringRefHandler(String s, String ind) {
            this.prefix = s;
            this.index = ind;
        }

        @Override
        void append(MatchResult match, TextBuffer dest) {
            if (this.prefix != null) {
                dest.append(this.prefix);
            }
            if (this.index == null) {
                return;
            }
            Integer id = match.pattern().groupId(this.index);
            int i = id;
            if (match.isCaptured(i)) {
                match.getGroup(i, dest);
            }
        }
    }

    private static class IntRefHandler
    extends Element {
        private Integer index;

        IntRefHandler(String s, Integer ind) {
            this.prefix = s;
            this.index = ind;
        }

        @Override
        void append(MatchResult match, TextBuffer dest) {
            if (this.prefix != null) {
                dest.append(this.prefix);
            }
            if (this.index == null) {
                return;
            }
            int i = this.index;
            if (i >= match.pattern().groupCount()) {
                return;
            }
            if (match.isCaptured(i)) {
                match.getGroup(i, dest);
            }
        }
    }

    private static class PlainElement
    extends Element {
        private String str;

        PlainElement(String s) {
            this.str = s;
        }

        PlainElement(String pref, String s) {
            this.prefix = pref;
            this.str = s;
        }

        @Override
        void append(MatchResult match, TextBuffer dest) {
            if (this.prefix != null) {
                dest.append(this.prefix);
            }
            if (this.str != null) {
                dest.append(this.str);
            }
        }
    }

    private static abstract class Element {
        protected String prefix;
        Element next;

        private Element() {
        }

        abstract void append(MatchResult var1, TextBuffer var2);
    }
}

