/*
 * Decompiled with CFR 0.152.
 */
package org.jregex;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.jregex.MatchResult;
import org.jregex.Matcher;
import org.jregex.PatternSyntaxException;
import org.jregex.REFlags;
import org.jregex.RETokenizer;
import org.jregex.Replacer;
import org.jregex.Substitution;
import org.jregex.Term;

public class Pattern
implements Serializable,
REFlags {
    String stringRepr;
    Term root;
    Term root0;
    int memregs;
    int counters;
    int lookaheads;
    Map namedGroupMap;

    protected Pattern() throws PatternSyntaxException {
    }

    public Pattern(String regex) throws PatternSyntaxException {
        this(regex, 0);
    }

    public Set getGroupNames() {
        return this.namedGroupMap.keySet();
    }

    public Pattern(String regex, String flags) throws PatternSyntaxException {
        this.stringRepr = regex;
        this.compile(regex, Pattern.parseFlags(flags));
    }

    public Pattern(String regex, int flags) throws PatternSyntaxException {
        this.compile(regex, flags);
    }

    protected void compile(String regex, int flags) throws PatternSyntaxException {
        this.stringRepr = regex;
        Term.makeTree(regex, flags, this);
    }

    private void printTree(Term val, int depth) {
        int i;
        for (i = 0; i < depth; ++i) {
            System.err.print(" ");
        }
        if (val == null) {
            System.err.println("null");
        } else if (depth > 15) {
            System.err.println("to deep");
        } else {
            System.err.println("" + (Object)((Object)val.type) + "==" + val);
            if (val.next != null) {
                for (i = 0; i < depth; ++i) {
                    System.err.print("-");
                }
                System.err.println("-next:");
                this.printTree(val.next, depth + 1);
            }
            if (val.failNext != null) {
                for (i = 0; i < depth; ++i) {
                    System.err.print("-");
                }
                System.err.println("-failNext:");
                this.printTree(val.failNext, depth + 1);
            }
            if (val.target != null) {
                for (i = 0; i < depth; ++i) {
                    System.err.print("-");
                }
                System.err.println("-target:");
                this.printTree(val.target, depth + 1);
            }
        }
    }

    public int groupCount() {
        return this.memregs;
    }

    public Integer groupId(String name) {
        return (Integer)this.namedGroupMap.get(name);
    }

    public boolean matches(String s) {
        return this.matcher(s).matches();
    }

    public boolean startsWith(String s) {
        return this.matcher(s).matchesPrefix();
    }

    public Matcher matcher() {
        return new Matcher(this);
    }

    public Matcher matcher(String s) {
        Matcher m = new Matcher(this);
        m.setTarget(s);
        return m;
    }

    public Matcher matcher(char[] data, int start, int end) {
        Matcher m = new Matcher(this);
        m.setTarget(data, start, end);
        return m;
    }

    public Matcher matcher(MatchResult res, int groupId) {
        Matcher m = new Matcher(this);
        if (res instanceof Matcher) {
            m.setTarget((Matcher)res, groupId);
        } else {
            m.setTarget(res.targetChars(), res.start(groupId) + res.targetStart(), res.length(groupId));
        }
        return m;
    }

    public Matcher matcher(MatchResult res, String groupName) {
        Integer id = res.pattern().groupId(groupName);
        if (id == null) {
            throw new IllegalArgumentException("group not found:" + groupName);
        }
        int group = id;
        return this.matcher(res, group);
    }

    public Matcher matcher(Reader text, int length) throws IOException {
        Matcher m = new Matcher(this);
        m.setTarget(text, length);
        return m;
    }

    public Replacer replacer(String expr) {
        return new Replacer(this, expr);
    }

    public Replacer replacer(Substitution model) {
        return new Replacer(this, model);
    }

    public RETokenizer tokenizer(String text) {
        return new RETokenizer(this, text);
    }

    public RETokenizer tokenizer(char[] data, int off, int len) {
        return new RETokenizer(this, data, off, len);
    }

    public RETokenizer tokenizer(Reader in, int length) throws IOException {
        return new RETokenizer(this, in, length);
    }

    public String toString() {
        return this.stringRepr;
    }

    public String toString_d() {
        return this.root.toStringAll();
    }

    static int parseFlags(String flags) throws PatternSyntaxException {
        boolean enable = true;
        int len = flags.length();
        int result = 0;
        block4: for (int i = 0; i < len; ++i) {
            char c = flags.charAt(i);
            switch (c) {
                case '+': {
                    enable = true;
                    continue block4;
                }
                case '-': {
                    enable = false;
                    continue block4;
                }
                default: {
                    int flag = Pattern.getFlag(c);
                    if (enable) {
                        result |= flag;
                        continue block4;
                    }
                    result &= ~flag;
                }
            }
        }
        return result;
    }

    static int parseFlags(char[] data, int start, int len) throws PatternSyntaxException {
        boolean enable = true;
        int result = 0;
        block4: for (int i = 0; i < len; ++i) {
            char c = data[start + i];
            switch (c) {
                case '+': {
                    enable = true;
                    continue block4;
                }
                case '-': {
                    enable = false;
                    continue block4;
                }
                default: {
                    int flag = Pattern.getFlag(c);
                    if (enable) {
                        result |= flag;
                        continue block4;
                    }
                    result &= ~flag;
                }
            }
        }
        return result;
    }

    private static int getFlag(char c) throws PatternSyntaxException {
        switch (c) {
            case 'i': {
                return 1;
            }
            case 'm': {
                return 6;
            }
            case 's': {
                return 4;
            }
            case 'x': {
                return 8;
            }
            case 'u': {
                return 16;
            }
        }
        throw new PatternSyntaxException("unknown flag: " + c);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String quote(String input) {
        int p = 0;
        char[] entries = input.toCharArray();
        int end = entries.length;
        block11: while (true) {
            if (p >= end) {
                return input;
            }
            char c = entries[p];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    break block11;
                }
                default: {
                    ++p;
                    continue block11;
                }
            }
            break;
        }
        StringBuilder result = new StringBuilder();
        result.append(entries, 0, p);
        while (true) {
            block15: {
                if (p >= end) {
                    return result.toString();
                }
                char c = entries[p];
                switch (c) {
                    case '$': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '.': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        result.append('\\');
                        break;
                    }
                    case ' ': {
                        result.append("\\ ");
                        break block15;
                    }
                    case '\t': {
                        result.append("\\t");
                        break block15;
                    }
                    case '\n': {
                        result.append("\\n");
                        break block15;
                    }
                    case '\r': {
                        result.append("\\r");
                        break block15;
                    }
                    case '\f': {
                        result.append("\\f");
                        break block15;
                    }
                }
                result.append(c);
            }
            ++p;
        }
    }
}

