/*
 * Decompiled with CFR 0.152.
 */
package org.jregex;

import java.util.List;
import org.jregex.Optimizer;
import org.jregex.PatternSyntaxException;
import org.jregex.Term;

class Iterator
extends Term {
    Iterator(Term term, int min, int max, List collection) throws PatternSyntaxException {
        collection.add(this);
        switch (term.type) {
            case CHAR: 
            case ANY_CHAR: 
            case ANY_CHAR_NE: 
            case BITSET: 
            case BITSET2: {
                this.target = term;
                Term back = new Term();
                if (min <= 0 && max < 0) {
                    this.type = Term.TermType.REPEAT_0_INF;
                    back.type = Term.TermType.BACKTRACK_0;
                } else if (min > 0 && max < 0) {
                    this.type = Term.TermType.REPEAT_MIN_INF;
                    back.type = Term.TermType.BACKTRACK_MIN;
                    this.minCount = back.minCount = min;
                } else {
                    this.type = Term.TermType.REPEAT_MIN_MAX;
                    back.type = Term.TermType.BACKTRACK_MIN;
                    this.minCount = back.minCount = min;
                    this.maxCount = max;
                }
                this.failNext = back;
                this.in = this;
                this.out = this;
                this.out1 = back;
                this.branchOut = null;
                return;
            }
            case REG: {
                this.target = term;
                this.memreg = term.memreg;
                Term back = new Term();
                if (max < 0) {
                    this.type = Term.TermType.REPEAT_REG_MIN_INF;
                    back.type = Term.TermType.BACKTRACK_REG_MIN;
                    this.minCount = back.minCount = min;
                } else {
                    this.type = Term.TermType.REPEAT_REG_MIN_MAX;
                    back.type = Term.TermType.BACKTRACK_REG_MIN;
                    this.minCount = back.minCount = min;
                    this.maxCount = max;
                }
                this.failNext = back;
                this.in = this;
                this.out = this;
                this.out1 = back;
                this.branchOut = null;
                return;
            }
        }
        throw new PatternSyntaxException("can't iterate this type: " + (Object)((Object)term.type));
    }

    void optimize() {
        Term back = this.failNext;
        Optimizer opt = Optimizer.find(back.next);
        if (opt == null) {
            return;
        }
        this.failNext = opt.makeBacktrack(back);
    }
}

