/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.IntNum;
import java.lang.invoke.MethodHandle;
import seph.lang.LexicalScope;
import seph.lang.SThread;
import seph.lang.SephObject;
import seph.lang.bim.NumberBase;
import seph.lang.persistent.IPersistentList;

public abstract class Numeric
extends Number
implements SephObject {
    public static final int FLOOR = 1;
    public static final int CEILING = 2;
    public static final int TRUNCATE = 3;
    public static final int ROUND = 4;

    @Override
    public SephObject get(String cellName) {
        return NumberBase.get(cellName);
    }

    @Override
    public Object identity() {
        return NumberBase.IDENTITY;
    }

    @Override
    public boolean isActivatable() {
        return false;
    }

    @Override
    public boolean isTrue() {
        return true;
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, IPersistentList arguments) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, SephObject arg0) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, SephObject arg0, SephObject arg1) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, SephObject arg0, SephObject arg1, SephObject arg2) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, SephObject arg0, SephObject arg1, SephObject arg2, SephObject arg3) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, SephObject arg0, SephObject arg1, SephObject arg2, SephObject arg3, SephObject arg4) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public SephObject activateWith(SephObject receiver, SThread thread, LexicalScope scope, MethodHandle arg0, MethodHandle arg1, MethodHandle arg2, MethodHandle arg3, MethodHandle arg4) {
        throw new RuntimeException(" *** couldn't activate: " + this);
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    public abstract Numeric add(Object var1, int var2);

    public final Numeric add(Object obj) {
        return this.add(obj, 1);
    }

    public final Numeric sub(Object obj) {
        return this.add(obj, -1);
    }

    public abstract Numeric mul(Object var1);

    public abstract Numeric div(Object var1);

    public abstract Numeric abs();

    public abstract Numeric neg();

    public abstract String toString(int var1);

    public String toString() {
        return this.toString(10);
    }

    public abstract boolean isExact();

    public abstract boolean isZero();

    public int compare(Object obj) {
        return -3;
    }

    public int compareReversed(Numeric x) {
        throw new IllegalArgumentException();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Numeric)) {
            return false;
        }
        return this.compare(obj) == 0;
    }

    public boolean grt(Object x) {
        return this.compare(x) > 0;
    }

    public boolean geq(Object x) {
        return this.compare(x) >= 0;
    }

    public Numeric addReversed(Numeric x, int k) {
        throw new IllegalArgumentException();
    }

    public Numeric mulReversed(Numeric x) {
        throw new IllegalArgumentException();
    }

    public Numeric divReversed(Numeric x) {
        throw new IllegalArgumentException();
    }

    public Numeric div_inv() {
        return IntNum.one().div(this);
    }

    public Numeric mul_ident() {
        return IntNum.one();
    }

    public Numeric power(IntNum y) {
        if (y.isNegative()) {
            return this.power(IntNum.neg(y)).div_inv();
        }
        Numeric pow2 = this;
        Numeric r = null;
        while (true) {
            if (y.isOdd()) {
                Numeric numeric = r = r == null ? pow2 : r.mul(pow2);
            }
            if ((y = IntNum.shift(y, -1)).isZero()) break;
            pow2 = pow2.mul(pow2);
        }
        return r == null ? this.mul_ident() : r;
    }
}

